/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.attach.util.WaitingInlineElementsHelper;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.styledxmlparser.node.IElementNode;

public class PTagWorker
implements ITagWorker,
IDisplayAware {
    private Paragraph paragraph = new Paragraph();
    private WaitingInlineElementsHelper inlineHelper;
    private String display;

    public PTagWorker(IElementNode element, ProcessorContext context) {
        this.inlineHelper = new WaitingInlineElementsHelper((String)element.getStyles().get("white-space"), (String)element.getStyles().get("text-transform"));
        this.display = element.getStyles() != null ? (String)element.getStyles().get("display") : null;
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        this.inlineHelper.flushHangingLeaves((IPropertyContainer)this.paragraph);
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        this.inlineHelper.add(content);
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        IPropertyContainer element = childTagWorker.getElementResult();
        if (element instanceof ILeafElement) {
            this.inlineHelper.add((ILeafElement)element);
            return true;
        }
        if (element instanceof IBlockElement && childTagWorker instanceof IDisplayAware && "inline-block".equals(((IDisplayAware)((Object)childTagWorker)).getDisplay())) {
            this.inlineHelper.add((IBlockElement)element);
            return true;
        }
        if (childTagWorker instanceof SpanTagWorker) {
            boolean allChildrenProcessed = true;
            for (IPropertyContainer propertyContainer : ((SpanTagWorker)childTagWorker).getAllElements()) {
                if (propertyContainer instanceof ILeafElement) {
                    this.inlineHelper.add((ILeafElement)propertyContainer);
                    continue;
                }
                if (propertyContainer instanceof IBlockElement && "inline-block".equals(((SpanTagWorker)childTagWorker).getElementDisplay(propertyContainer))) {
                    this.inlineHelper.add((IBlockElement)propertyContainer);
                    continue;
                }
                allChildrenProcessed = false;
            }
            return allChildrenProcessed;
        }
        return false;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.paragraph;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }
}

