/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.font.FontIdentification;
import com.itextpdf.io.font.FontMetrics;
import com.itextpdf.io.font.FontNames;
import com.itextpdf.io.font.otf.Glyph;
import java.util.HashMap;
import java.util.Map;

public abstract class FontProgram {
    public static final int HORIZONTAL_SCALING_FACTOR = 100;
    public static final int DEFAULT_WIDTH = 1000;
    public static final int UNITS_NORMALIZATION = 1000;
    protected Map<Integer, Glyph> codeToGlyph = new HashMap<Integer, Glyph>();
    protected Map<Integer, Glyph> unicodeToGlyph = new HashMap<Integer, Glyph>();
    protected boolean isFontSpecific;
    protected FontNames fontNames;
    protected FontMetrics fontMetrics = new FontMetrics();
    protected FontIdentification fontIdentification = new FontIdentification();
    protected int avgWidth;
    protected String encodingScheme = "FontSpecific";
    protected String registry;

    public static float convertTextSpaceToGlyphSpace(float value) {
        return value / 1000.0f;
    }

    public static float convertGlyphSpaceToTextSpace(float value) {
        return value * 1000.0f;
    }

    public static double convertGlyphSpaceToTextSpace(double value) {
        return value * 1000.0;
    }

    public static int convertGlyphSpaceToTextSpace(int value) {
        return value * 1000;
    }

    public int countOfGlyphs() {
        return Math.max(this.codeToGlyph.size(), this.unicodeToGlyph.size());
    }

    public FontNames getFontNames() {
        return this.fontNames;
    }

    public FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    public FontIdentification getFontIdentification() {
        return this.fontIdentification;
    }

    public String getRegistry() {
        return this.registry;
    }

    public abstract int getPdfFontFlags();

    public boolean isFontSpecific() {
        return this.isFontSpecific;
    }

    public int getWidth(int unicode) {
        Glyph glyph = this.getGlyph(unicode);
        return glyph != null ? glyph.getWidth() : 0;
    }

    public int getAvgWidth() {
        return this.avgWidth;
    }

    public int[] getCharBBox(int unicode) {
        Glyph glyph = this.getGlyph(unicode);
        return glyph != null ? glyph.getBbox() : null;
    }

    public Glyph getGlyph(int unicode) {
        return this.unicodeToGlyph.get(unicode);
    }

    public Glyph getGlyphByCode(int charCode) {
        return this.codeToGlyph.get(charCode);
    }

    public boolean hasKernPairs() {
        return false;
    }

    public int getKerning(int first, int second) {
        return this.getKerning(this.unicodeToGlyph.get(first), this.unicodeToGlyph.get(second));
    }

    public abstract int getKerning(Glyph var1, Glyph var2);

    public boolean isBuiltWith(String fontName) {
        return false;
    }

    protected void setRegistry(String registry) {
        this.registry = registry;
    }

    static String trimFontStyle(String name) {
        if (name == null) {
            return null;
        }
        if (name.endsWith(",Bold")) {
            return name.substring(0, name.length() - 5);
        }
        if (name.endsWith(",Italic")) {
            return name.substring(0, name.length() - 7);
        }
        if (name.endsWith(",BoldItalic")) {
            return name.substring(0, name.length() - 11);
        }
        return name;
    }

    protected void setTypoAscender(int ascender) {
        this.fontMetrics.setTypoAscender(ascender);
    }

    protected void setTypoDescender(int descender) {
        this.fontMetrics.setTypoDescender(descender);
    }

    protected void setCapHeight(int capHeight) {
        this.fontMetrics.setCapHeight(capHeight);
    }

    protected void setXHeight(int xHeight) {
        this.fontMetrics.setXHeight(xHeight);
    }

    protected void setItalicAngle(int italicAngle) {
        this.fontMetrics.setItalicAngle(italicAngle);
    }

    protected void setStemV(int stemV) {
        this.fontMetrics.setStemV(stemV);
    }

    protected void setStemH(int stemH) {
        this.fontMetrics.setStemH(stemH);
    }

    protected void setFontWeight(int fontWeight) {
        this.fontNames.setFontWeight(fontWeight);
    }

    protected void setFontStretch(String fontWidth) {
        this.fontNames.setFontStretch(fontWidth);
    }

    protected void setFixedPitch(boolean isFixedPitch) {
        this.fontMetrics.setIsFixedPitch(isFixedPitch);
    }

    protected void setBold(boolean isBold) {
        if (isBold) {
            this.fontNames.setMacStyle(this.fontNames.getMacStyle() | 1);
        } else {
            this.fontNames.setMacStyle(this.fontNames.getMacStyle() & 0xFFFFFFFE);
        }
    }

    protected void setBbox(int[] bbox) {
        this.fontMetrics.setBbox(bbox[0], bbox[1], bbox[2], bbox[3]);
    }

    protected void setFontFamily(String fontFamily) {
        this.fontNames.setFamilyName(fontFamily);
    }

    protected void setFontName(String fontName) {
        this.fontNames.setFontName(fontName);
        if (this.fontNames.getFullName() == null) {
            this.fontNames.setFullName(fontName);
        }
    }

    protected void fixSpaceIssue() {
        Glyph space = this.unicodeToGlyph.get(32);
        if (space != null) {
            this.codeToGlyph.put(space.getCode(), space);
        }
    }

    public String toString() {
        String name = this.getFontNames().getFontName();
        return name != null && name.length() > 0 ? name : super.toString();
    }
}

