/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.util;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.canvas.parser.util.PdfCanvasParser;
import com.itextpdf.kernel.pdf.filters.FilterHandlers;
import com.itextpdf.kernel.pdf.filters.FlateDecodeStrictFilter;
import com.itextpdf.kernel.pdf.filters.IFilterHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InlineImageParsingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlineImageParsingUtils.class);
    private static final Map<PdfName, PdfName> inlineImageEntryAbbreviationMap = new HashMap<PdfName, PdfName>();
    private static final Map<PdfName, PdfName> inlineImageColorSpaceAbbreviationMap;
    private static final Map<PdfName, PdfName> inlineImageFilterAbbreviationMap;

    private InlineImageParsingUtils() {
    }

    public static PdfStream parse(PdfCanvasParser ps, PdfDictionary colorSpaceDic) throws IOException {
        PdfDictionary inlineImageDict = InlineImageParsingUtils.parseDictionary(ps);
        byte[] samples = InlineImageParsingUtils.parseSamples(inlineImageDict, colorSpaceDic, ps);
        PdfName colorSpaceName = inlineImageDict.getAsName(PdfName.ColorSpace);
        if (colorSpaceDic != null && colorSpaceName != null) {
            inlineImageDict.put(PdfName.ColorSpace, colorSpaceDic.get(colorSpaceName));
        }
        PdfStream inlineImageAsStreamObject = new PdfStream(samples);
        inlineImageAsStreamObject.putAll(inlineImageDict);
        return inlineImageAsStreamObject;
    }

    static int getComponentsPerPixel(PdfName colorSpaceName, PdfDictionary colorSpaceDic) {
        if (colorSpaceName == null) {
            return 1;
        }
        if (colorSpaceName.equals(PdfName.DeviceGray)) {
            return 1;
        }
        if (colorSpaceName.equals(PdfName.DeviceRGB)) {
            return 3;
        }
        if (colorSpaceName.equals(PdfName.DeviceCMYK)) {
            return 4;
        }
        if (colorSpaceDic != null) {
            PdfArray colorSpace = colorSpaceDic.getAsArray(colorSpaceName);
            if (colorSpace == null) {
                PdfName tempName = colorSpaceDic.getAsName(colorSpaceName);
                if (tempName != null) {
                    return InlineImageParsingUtils.getComponentsPerPixel(tempName, colorSpaceDic);
                }
            } else {
                if (PdfName.Indexed.equals(colorSpace.getAsName(0)) || PdfName.CalGray.equals(colorSpace.getAsName(0)) || PdfName.Pattern.equals(colorSpace.getAsName(0)) || PdfName.Separation.equals(colorSpace.getAsName(0))) {
                    return 1;
                }
                if (PdfName.CalRGB.equals(colorSpace.getAsName(0)) || PdfName.Lab.equals(colorSpace.getAsName(0))) {
                    return 3;
                }
                if (PdfName.ICCBased.equals(colorSpace.getAsName(0))) {
                    return colorSpace.getAsStream(1).getAsNumber(PdfName.N).intValue();
                }
                if (PdfName.DeviceN.equals(colorSpace.getAsName(0))) {
                    return colorSpace.getAsArray(1).size();
                }
            }
        }
        throw new InlineImageParseException("Unexpected ColorSpace: {0}.").setMessageParams(colorSpaceName);
    }

    private static PdfDictionary parseDictionary(PdfCanvasParser ps) throws IOException {
        PdfDictionary dict = new PdfDictionary();
        PdfObject key = ps.readObject();
        while (key != null && !"ID".equals(key.toString())) {
            PdfObject value = ps.readObject();
            PdfName resolvedKey = inlineImageEntryAbbreviationMap.get((PdfName)key);
            if (resolvedKey == null) {
                resolvedKey = (PdfName)key;
            }
            dict.put(resolvedKey, InlineImageParsingUtils.getAlternateValue(resolvedKey, value));
            key = ps.readObject();
        }
        int ch = ps.getTokeniser().peek();
        if (PdfTokenizer.isWhitespace((int)ch)) {
            ps.getTokeniser().read();
        }
        return dict;
    }

    private static PdfObject getAlternateValue(PdfName key, PdfObject value) {
        PdfName altValue;
        if (key == PdfName.Filter) {
            if (value instanceof PdfName) {
                PdfName altValue2 = inlineImageFilterAbbreviationMap.get((PdfName)value);
                if (altValue2 != null) {
                    return altValue2;
                }
            } else if (value instanceof PdfArray) {
                PdfArray array = (PdfArray)value;
                PdfArray altArray = new PdfArray();
                int count = array.size();
                for (int i = 0; i < count; ++i) {
                    altArray.add(InlineImageParsingUtils.getAlternateValue(key, array.get(i)));
                }
                return altArray;
            }
        } else if (key == PdfName.ColorSpace && value instanceof PdfName && (altValue = inlineImageColorSpaceAbbreviationMap.get((PdfName)value)) != null) {
            return altValue;
        }
        return value;
    }

    private static int computeBytesPerRow(PdfDictionary imageDictionary, PdfDictionary colorSpaceDic) {
        PdfNumber wObj = imageDictionary.getAsNumber(PdfName.Width);
        PdfNumber bpcObj = imageDictionary.getAsNumber(PdfName.BitsPerComponent);
        int cpp = InlineImageParsingUtils.getComponentsPerPixel(imageDictionary.getAsName(PdfName.ColorSpace), colorSpaceDic);
        int w = wObj.intValue();
        int bpc = bpcObj != null ? bpcObj.intValue() : 1;
        return (w * bpc * cpp + 7) / 8;
    }

    private static byte[] parseUnfilteredSamples(PdfDictionary imageDictionary, PdfDictionary colorSpaceDic, PdfCanvasParser ps) throws IOException {
        PdfObject ei2;
        if (imageDictionary.containsKey(PdfName.Filter)) {
            throw new IllegalArgumentException("Dictionary contains filters");
        }
        PdfNumber h = imageDictionary.getAsNumber(PdfName.Height);
        int bytesToRead = InlineImageParsingUtils.computeBytesPerRow(imageDictionary, colorSpaceDic) * h.intValue();
        byte[] bytes = new byte[bytesToRead];
        PdfTokenizer tokeniser = ps.getTokeniser();
        int shouldBeWhiteSpace = tokeniser.read();
        int startIndex = 0;
        if (!PdfTokenizer.isWhitespace((int)shouldBeWhiteSpace) || shouldBeWhiteSpace == 0) {
            bytes[0] = (byte)shouldBeWhiteSpace;
            ++startIndex;
        }
        for (int i = startIndex; i < bytesToRead; ++i) {
            int ch = tokeniser.read();
            if (ch == -1) {
                throw new InlineImageParseException("End of content stream reached before end of image data.");
            }
            bytes[i] = (byte)ch;
        }
        PdfObject ei = ps.readObject();
        if (!"EI".equals(ei.toString()) && !"EI".equals((ei2 = ps.readObject()).toString())) {
            throw new InlineImageParseException("Operator EI not found after the end of image data.");
        }
        return bytes;
    }

    private static byte[] parseSamples(PdfDictionary imageDictionary, PdfDictionary colorSpaceDic, PdfCanvasParser ps) throws IOException {
        if (!imageDictionary.containsKey(PdfName.Filter) && InlineImageParsingUtils.imageColorSpaceIsKnown(imageDictionary, colorSpaceDic)) {
            return InlineImageParsingUtils.parseUnfilteredSamples(imageDictionary, colorSpaceDic, ps);
        }
        PdfTokenizer tokenizer = ps.getTokeniser();
        ByteArrayOutputStream imageStream = new ByteArrayOutputStream();
        int lastByte = tokenizer.read();
        int currentByte = tokenizer.read();
        while (currentByte != -1) {
            byte[] image;
            if (lastByte == 69 && currentByte == 73 && PdfTokenizer.isWhitespace((int)tokenizer.peek()) && !InlineImageParsingUtils.followedByBinaryData(tokenizer) && InlineImageParsingUtils.inlineImageStreamBytesAreComplete(image = imageStream.toByteArray(), imageDictionary)) {
                return image;
            }
            imageStream.write(lastByte);
            lastByte = currentByte;
            currentByte = tokenizer.read();
        }
        throw new InlineImageParseException("Cannot find image data or EI.");
    }

    private static boolean followedByBinaryData(PdfTokenizer tokenizer) throws IOException {
        byte[] testSequence = new byte[10];
        tokenizer.peek(testSequence);
        boolean isBinaryData = false;
        int operatorStart = -1;
        int operatorEnd = -1;
        for (int i = 0; i < testSequence.length; ++i) {
            byte b = testSequence[i];
            if (b < 32 && !PdfTokenizer.isWhitespace((int)b)) {
                isBinaryData = true;
                break;
            }
            if (operatorStart == -1 && !PdfTokenizer.isWhitespace((int)b)) {
                operatorStart = i;
            }
            if (operatorStart == -1 || !PdfTokenizer.isWhitespace((int)b)) continue;
            operatorEnd = i;
            break;
        }
        if (operatorEnd == -1 && operatorStart != -1) {
            operatorEnd = testSequence.length;
        }
        if (operatorEnd - operatorStart > 3) {
            isBinaryData = true;
        }
        return isBinaryData;
    }

    private static boolean imageColorSpaceIsKnown(PdfDictionary imageDictionary, PdfDictionary colorSpaceDic) {
        PdfName cs = imageDictionary.getAsName(PdfName.ColorSpace);
        if (cs == null || cs.equals(PdfName.DeviceGray) || cs.equals(PdfName.DeviceRGB) || cs.equals(PdfName.DeviceCMYK)) {
            return true;
        }
        return colorSpaceDic != null && colorSpaceDic.containsKey(cs);
    }

    private static boolean inlineImageStreamBytesAreComplete(byte[] samples, PdfDictionary imageDictionary) {
        try {
            HashMap<PdfName, IFilterHandler> filters = new HashMap<PdfName, IFilterHandler>(FilterHandlers.getDefaultFilterHandlers());
            filters.put(PdfName.JPXDecode, new UnsupportedFilter(PdfName.JPXDecode.getValue()));
            filters.put(PdfName.JBIG2Decode, new UnsupportedFilter(PdfName.JBIG2Decode.getValue()));
            filters.put(PdfName.FlateDecode, new FlateDecodeStrictFilter());
            PdfReader.decodeBytes(samples, imageDictionary, filters);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    static {
        inlineImageEntryAbbreviationMap.put(PdfName.BitsPerComponent, PdfName.BitsPerComponent);
        inlineImageEntryAbbreviationMap.put(PdfName.ColorSpace, PdfName.ColorSpace);
        inlineImageEntryAbbreviationMap.put(PdfName.Decode, PdfName.Decode);
        inlineImageEntryAbbreviationMap.put(PdfName.DecodeParms, PdfName.DecodeParms);
        inlineImageEntryAbbreviationMap.put(PdfName.Filter, PdfName.Filter);
        inlineImageEntryAbbreviationMap.put(PdfName.Height, PdfName.Height);
        inlineImageEntryAbbreviationMap.put(PdfName.ImageMask, PdfName.ImageMask);
        inlineImageEntryAbbreviationMap.put(PdfName.Intent, PdfName.Intent);
        inlineImageEntryAbbreviationMap.put(PdfName.Interpolate, PdfName.Interpolate);
        inlineImageEntryAbbreviationMap.put(PdfName.Width, PdfName.Width);
        inlineImageEntryAbbreviationMap.put(new PdfName("BPC"), PdfName.BitsPerComponent);
        inlineImageEntryAbbreviationMap.put(new PdfName("CS"), PdfName.ColorSpace);
        inlineImageEntryAbbreviationMap.put(new PdfName("D"), PdfName.Decode);
        inlineImageEntryAbbreviationMap.put(new PdfName("DP"), PdfName.DecodeParms);
        inlineImageEntryAbbreviationMap.put(new PdfName("F"), PdfName.Filter);
        inlineImageEntryAbbreviationMap.put(new PdfName("H"), PdfName.Height);
        inlineImageEntryAbbreviationMap.put(new PdfName("IM"), PdfName.ImageMask);
        inlineImageEntryAbbreviationMap.put(new PdfName("I"), PdfName.Interpolate);
        inlineImageEntryAbbreviationMap.put(new PdfName("W"), PdfName.Width);
        inlineImageColorSpaceAbbreviationMap = new HashMap<PdfName, PdfName>();
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("G"), PdfName.DeviceGray);
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("RGB"), PdfName.DeviceRGB);
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("CMYK"), PdfName.DeviceCMYK);
        inlineImageColorSpaceAbbreviationMap.put(new PdfName("I"), PdfName.Indexed);
        inlineImageFilterAbbreviationMap = new HashMap<PdfName, PdfName>();
        inlineImageFilterAbbreviationMap.put(new PdfName("AHx"), PdfName.ASCIIHexDecode);
        inlineImageFilterAbbreviationMap.put(new PdfName("A85"), PdfName.ASCII85Decode);
        inlineImageFilterAbbreviationMap.put(new PdfName("LZW"), PdfName.LZWDecode);
        inlineImageFilterAbbreviationMap.put(new PdfName("Fl"), PdfName.FlateDecode);
        inlineImageFilterAbbreviationMap.put(new PdfName("RL"), PdfName.RunLengthDecode);
        inlineImageFilterAbbreviationMap.put(new PdfName("CCF"), PdfName.CCITTFaxDecode);
        inlineImageFilterAbbreviationMap.put(new PdfName("DCT"), PdfName.DCTDecode);
    }

    private static class UnsupportedFilter
    implements IFilterHandler {
        private final String name;

        public UnsupportedFilter(String name) {
            this.name = name;
        }

        @Override
        public byte[] decode(byte[] b, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) {
            LOGGER.error(MessageFormatUtil.format((String)"Cannot parse inline image: {0} encoding is unsupported.", (Object[])new Object[]{this.name}));
            throw new UnsupportedOperationException();
        }
    }

    public static class InlineImageParseException
    extends PdfException {
        public InlineImageParseException(String message) {
            super(message);
        }
    }
}

