/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.utils.objectpathitems;

import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.utils.objectpathitems.LocalPathItem;
import com.itextpdf.kernel.utils.objectpathitems.ObjectPath;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class TrailerPath
extends ObjectPath {
    private final PdfDocument outDocument;
    private final PdfDocument cmpDocument;
    private static final String INITIAL_LINE = "Base cmp object: trailer. Base out object: trailer";

    public TrailerPath(PdfDocument cmpDoc, PdfDocument outDoc) {
        this.outDocument = outDoc;
        this.cmpDocument = cmpDoc;
    }

    public TrailerPath(TrailerPath trailerPath) {
        this.outDocument = trailerPath.getOutDocument();
        this.cmpDocument = trailerPath.getCmpDocument();
        this.path = trailerPath.getLocalPath();
    }

    public TrailerPath(PdfDocument cmpDoc, PdfDocument outDoc, Stack<LocalPathItem> path) {
        this.outDocument = outDoc;
        this.cmpDocument = cmpDoc;
        this.path = path;
    }

    public PdfDocument getOutDocument() {
        return this.outDocument;
    }

    public PdfDocument getCmpDocument() {
        return this.cmpDocument;
    }

    @Override
    public Node toXmlNode(Document document) {
        Element element = document.createElement("path");
        Element baseNode = document.createElement("base");
        baseNode.setAttribute("cmp", "trailer");
        baseNode.setAttribute("out", "trailer");
        element.appendChild(baseNode);
        for (LocalPathItem pathItem : this.path) {
            element.appendChild(pathItem.toXmlNode(document));
        }
        return element;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(INITIAL_LINE.length());
        sb.append(INITIAL_LINE);
        for (LocalPathItem pathItem : this.path) {
            sb.append('\n');
            sb.append(pathItem.toString());
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int hashCode = this.outDocument.hashCode() * 31 + this.cmpDocument.hashCode();
        for (LocalPathItem pathItem : this.path) {
            hashCode *= 31;
            hashCode += pathItem.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass() == this.getClass() && this.outDocument.equals(((TrailerPath)obj).outDocument) && this.cmpDocument.equals(((TrailerPath)obj).cmpDocument) && this.path.equals(((ObjectPath)obj).path);
    }
}

