/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.border;

import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.border.Border;

public class SolidBorder
extends Border {
    public SolidBorder(float width) {
        super(width);
    }

    public SolidBorder(Color color, float width) {
        super(color, width);
    }

    public SolidBorder(Color color, float width, float opacity) {
        super(color, width, opacity);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float borderWidthBefore, float borderWidthAfter) {
        float x3 = 0.0f;
        float y3 = 0.0f;
        float x4 = 0.0f;
        float y4 = 0.0f;
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2);
        switch (borderSide) {
            case TOP: {
                x3 = x2 + borderWidthAfter;
                y3 = y2 + this.width;
                x4 = x1 - borderWidthBefore;
                y4 = y1 + this.width;
                break;
            }
            case RIGHT: {
                x3 = x2 + this.width;
                y3 = y2 - borderWidthAfter;
                x4 = x1 + this.width;
                y4 = y1 + borderWidthBefore;
                break;
            }
            case BOTTOM: {
                x3 = x2 - borderWidthAfter;
                y3 = y2 - this.width;
                x4 = x1 + borderWidthBefore;
                y4 = y1 - this.width;
                break;
            }
            case LEFT: {
                x3 = x2 - this.width;
                y3 = y2 + borderWidthAfter;
                x4 = x1 - this.width;
                y4 = y1 - borderWidthBefore;
            }
        }
        canvas.saveState().setFillColor(this.transparentColor.getColor());
        this.transparentColor.applyFillTransparency(canvas);
        canvas.moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).lineTo((double)x3, (double)y3).lineTo((double)x4, (double)y4).lineTo((double)x1, (double)y1).fill().restoreState();
    }

    @Override
    public void drawCellBorder(PdfCanvas canvas, float x1, float y1, float x2, float y2) {
        canvas.saveState().setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineWidth(this.width).moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2).stroke().restoreState();
    }
}

