/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TableWidths {
    private TableRenderer tableRenderer;
    private int numberOfColumns;
    private float rightBorderMaxWidth;
    private float leftBorderMaxWidth;
    private ColumnWidthData[] widths;
    private List<CellInfo> cells;
    private float tableWidth;
    private boolean fixedTableWidth;
    private boolean fixedTableLayout = false;
    private float minWidth;

    TableWidths(TableRenderer tableRenderer, float availableWidth, boolean calculateTableMaxWidth, float rightBorderMaxWidth, float leftBorderMaxWidth) {
        this.tableRenderer = tableRenderer;
        this.numberOfColumns = ((Table)tableRenderer.getModelElement()).getNumberOfColumns();
        this.rightBorderMaxWidth = rightBorderMaxWidth;
        this.leftBorderMaxWidth = leftBorderMaxWidth;
        this.calculateTableWidth(availableWidth, calculateTableMaxWidth);
    }

    boolean hasFixedLayout() {
        return this.fixedTableLayout;
    }

    float getMinWidth() {
        return this.minWidth;
    }

    float[] autoLayout(float[] minWidths, float[] maxWidths) {
        block58: {
            float flexibleAddition;
            float fixedAddition;
            float minTotalNonPercent;
            float totalPercent;
            block61: {
                float sumOfPercents;
                block60: {
                    float minTableWidth;
                    int i;
                    block59: {
                        block57: {
                            int i2;
                            this.fillWidths(minWidths, maxWidths);
                            this.fillAndSortCells();
                            float minSum = 0.0f;
                            for (ColumnWidthData width : this.widths) {
                                minSum += width.min;
                            }
                            boolean[] minColumns = new boolean[this.numberOfColumns];
                            for (CellInfo cell : this.cells) {
                                int i3;
                                int flexibleCols;
                                UnitValue cellWidth = cell.getWidth();
                                if (cellWidth != null && cellWidth.getValue() >= 0.0f) {
                                    int i4;
                                    if (cellWidth.isPercentValue()) {
                                        if (cell.getColspan() == 1) {
                                            this.widths[cell.getCol()].setPercents(cellWidth.getValue());
                                            continue;
                                        }
                                        int pointColumns = 0;
                                        float percentSum = 0.0f;
                                        for (int i5 = cell.getCol(); i5 < cell.getCol() + cell.getColspan(); ++i5) {
                                            if (!this.widths[i5].isPercent) {
                                                ++pointColumns;
                                                continue;
                                            }
                                            percentSum += this.widths[i5].width;
                                        }
                                        float percentAddition = cellWidth.getValue() - percentSum;
                                        if (!(percentAddition > 0.0f)) continue;
                                        if (pointColumns == 0) {
                                            for (i = cell.getCol(); i < cell.getCol() + cell.getColspan(); ++i) {
                                                this.widths[i].addPercents(percentAddition / (float)cell.getColspan());
                                            }
                                            continue;
                                        }
                                        for (i = cell.getCol(); i < cell.getCol() + cell.getColspan(); ++i) {
                                            if (this.widths[i].isPercent) continue;
                                            this.widths[i].setPercents(percentAddition / (float)pointColumns).setFixed(true);
                                        }
                                        continue;
                                    }
                                    if (cell.getCol() == 1) {
                                        if (this.widths[cell.getCol()].isPercent) continue;
                                        this.widths[cell.getCol()].setPoints(cellWidth.getValue()).setFixed(true);
                                        if (!this.widths[cell.getCol()].hasCollision()) continue;
                                        minColumns[cell.getCol()] = true;
                                        continue;
                                    }
                                    flexibleCols = 0;
                                    float colspanRemain = cellWidth.getValue();
                                    for (i4 = cell.getCol(); i4 < cell.getCol() + cell.getColspan(); ++i4) {
                                        if (!this.widths[i4].isPercent) {
                                            colspanRemain -= this.widths[i4].width;
                                            if (this.widths[i4].isFixed) continue;
                                            ++flexibleCols;
                                            continue;
                                        }
                                        colspanRemain = -1.0f;
                                        break;
                                    }
                                    if (!(colspanRemain > 0.0f)) continue;
                                    if (flexibleCols > 0) {
                                        for (i4 = cell.getCol(); i4 < cell.getCol() + cell.getColspan(); ++i4) {
                                            if (this.widths[i4].isFixed || !this.widths[i4].checkCollision(colspanRemain / (float)flexibleCols)) continue;
                                            this.widths[i4].setPoints(this.widths[i4].min).setFixed(true);
                                            if ((colspanRemain -= this.widths[i4].min) <= 0.0f || flexibleCols-- <= 0) break;
                                        }
                                        if (!(colspanRemain > 0.0f) || flexibleCols <= 0) continue;
                                        for (int k = cell.getCol(); k < cell.getCol() + cell.getColspan(); ++k) {
                                            if (this.widths[k].isFixed) continue;
                                            this.widths[k].addPoints(colspanRemain / (float)flexibleCols).setFixed(true);
                                        }
                                        continue;
                                    }
                                    for (i4 = cell.getCol(); i4 < cell.getCol() + cell.getColspan(); ++i4) {
                                        this.widths[i4].addPoints(colspanRemain / (float)cell.getColspan());
                                    }
                                    continue;
                                }
                                if (this.widths[cell.getCol()].isFixed) continue;
                                flexibleCols = 0;
                                float remainWidth = 0.0f;
                                for (i3 = cell.getCol(); i3 < cell.getCol() + cell.getColspan(); ++i3) {
                                    if (this.widths[i3].isFixed || this.widths[i3].isPercent) continue;
                                    remainWidth += this.widths[i3].max - this.widths[i3].width;
                                    ++flexibleCols;
                                }
                                if (!(remainWidth > 0.0f)) continue;
                                if (flexibleCols > 0) {
                                    for (i3 = cell.getCol(); i3 < cell.getCol() + cell.getColspan(); ++i3) {
                                        if (this.widths[i3].isFixed || this.widths[i3].isPercent) continue;
                                        this.widths[i3].addPoints(remainWidth / (float)flexibleCols);
                                    }
                                    continue;
                                }
                                for (int k = cell.getCol(); k < cell.getCol() + cell.getColspan(); ++k) {
                                    this.widths[k].addPoints(remainWidth / (float)cell.getColspan());
                                }
                            }
                            for (int col = 0; col < minColumns.length; ++col) {
                                if (!minColumns[col] || this.widths[col].isPercent || !this.widths[col].isFixed || !this.widths[col].hasCollision()) continue;
                                minSum += this.widths[col].min - this.widths[col].width;
                                this.widths[col].setPoints(this.widths[col].min);
                            }
                            for (i2 = 0; i2 < this.numberOfColumns; ++i2) {
                                UnitValue colWidth = this.getTable().getColumnWidth(i2);
                                if (!(colWidth.getValue() >= 0.0f)) continue;
                                if (colWidth.isPercentValue()) {
                                    if (!this.widths[i2].isPercent && this.widths[i2].isFixed && this.widths[i2].width > this.widths[i2].min) {
                                        this.widths[i2].max = this.widths[i2].width;
                                        this.widths[i2].setFixed(false);
                                    }
                                    if (this.widths[i2].isPercent) continue;
                                    this.widths[i2].setPercents(colWidth.getValue());
                                    continue;
                                }
                                if (this.widths[i2].isPercent || !(colWidth.getValue() >= this.widths[i2].min)) continue;
                                if (this.widths[i2].isFixed) {
                                    this.widths[i2].setPoints(colWidth.getValue());
                                    continue;
                                }
                                this.widths[i2].resetPoints(colWidth.getValue());
                            }
                            if (!(this.tableWidth - minSum < 0.0f)) break block57;
                            for (i2 = 0; i2 < this.numberOfColumns; ++i2) {
                                this.widths[i2].finalWidth = this.widths[i2].min;
                            }
                            break block58;
                        }
                        sumOfPercents = 0.0f;
                        minTableWidth = 0.0f;
                        float totalNonPercent = 0.0f;
                        for (int i6 = 0; i6 < this.widths.length; ++i6) {
                            if (this.widths[i6].isPercent) {
                                if (sumOfPercents < 100.0f && sumOfPercents + this.widths[i6].width > 100.0f) {
                                    this.widths[i6].width -= sumOfPercents + this.widths[i6].width - 100.0f;
                                    sumOfPercents += this.widths[i6].width;
                                    this.warn100percent();
                                    continue;
                                }
                                if (sumOfPercents >= 100.0f) {
                                    this.widths[i6].resetPoints(this.widths[i6].min);
                                    minTableWidth += this.widths[i6].width;
                                    this.warn100percent();
                                    continue;
                                }
                                sumOfPercents += this.widths[i6].width;
                                continue;
                            }
                            minTableWidth += this.widths[i6].min;
                            totalNonPercent += this.widths[i6].width;
                        }
                        assert (sumOfPercents <= 100.0f);
                        boolean toBalance = true;
                        if (!this.fixedTableWidth) {
                            float tableWidthBasedOnPercents = sumOfPercents < 100.0f ? totalNonPercent * 100.0f / (100.0f - sumOfPercents) : 0.0f;
                            for (int i7 = 0; i7 < this.numberOfColumns; ++i7) {
                                if (!this.widths[i7].isPercent) continue;
                                tableWidthBasedOnPercents = Math.max(this.widths[i7].max * 100.0f / this.widths[i7].width, tableWidthBasedOnPercents);
                            }
                            if (tableWidthBasedOnPercents <= this.tableWidth) {
                                this.tableWidth = tableWidthBasedOnPercents;
                                toBalance = false;
                            }
                        }
                        if (sumOfPercents < 100.0f && totalNonPercent == 0.0f) {
                            for (int i8 = 0; i8 < this.widths.length; ++i8) {
                                this.widths[i8].width = 100.0f * this.widths[i8].width / sumOfPercents;
                            }
                            sumOfPercents = 100.0f;
                        }
                        if (toBalance) break block59;
                        for (int i9 = 0; i9 < this.numberOfColumns; ++i9) {
                            this.widths[i9].finalWidth = this.widths[i9].isPercent ? this.tableWidth * this.widths[i9].width / 100.0f : this.widths[i9].width;
                        }
                        break block58;
                    }
                    if (!(sumOfPercents >= 100.0f)) break block60;
                    sumOfPercents = 100.0f;
                    boolean recalculatePercents = false;
                    float remainingWidth = this.tableWidth - minTableWidth;
                    for (i = 0; i < this.numberOfColumns; ++i) {
                        if (this.widths[i].isPercent) {
                            if (remainingWidth * this.widths[i].width >= this.widths[i].min) {
                                this.widths[i].finalWidth = remainingWidth * this.widths[i].width / 100.0f;
                                continue;
                            }
                            this.widths[i].finalWidth = this.widths[i].min;
                            this.widths[i].isPercent = false;
                            remainingWidth -= this.widths[i].min;
                            sumOfPercents -= this.widths[i].width;
                            recalculatePercents = true;
                            continue;
                        }
                        this.widths[i].finalWidth = this.widths[i].min;
                    }
                    if (!recalculatePercents) break block58;
                    for (i = 0; i < this.numberOfColumns; ++i) {
                        if (!this.widths[i].isPercent) continue;
                        this.widths[i].finalWidth = remainingWidth * this.widths[i].width / sumOfPercents;
                    }
                    break block58;
                }
                totalPercent = 0.0f;
                minTotalNonPercent = 0.0f;
                fixedAddition = 0.0f;
                flexibleAddition = 0.0f;
                for (int i = 0; i < this.numberOfColumns; ++i) {
                    if (this.widths[i].isPercent) {
                        if (this.tableWidth * this.widths[i].width >= this.widths[i].min) {
                            this.widths[i].finalWidth = this.tableWidth * this.widths[i].width / 100.0f;
                            totalPercent += this.widths[i].finalWidth;
                            continue;
                        }
                        sumOfPercents -= this.widths[i].width;
                        this.widths[i].resetPoints(this.widths[i].min);
                        this.widths[i].finalWidth = this.widths[i].min;
                        minTotalNonPercent += this.widths[i].min;
                        continue;
                    }
                    this.widths[i].finalWidth = this.widths[i].min;
                    minTotalNonPercent += this.widths[i].min;
                    float addition = this.widths[i].width - this.widths[i].min;
                    if (this.widths[i].isFixed) {
                        fixedAddition += addition;
                        continue;
                    }
                    flexibleAddition += addition;
                }
                if (!(totalPercent + minTotalNonPercent > this.tableWidth)) break block61;
                float extraWidth = this.tableWidth - minTotalNonPercent;
                if (!(sumOfPercents > 0.0f)) break block58;
                for (int i = 0; i < this.numberOfColumns; ++i) {
                    if (!this.widths[i].isPercent) continue;
                    this.widths[i].finalWidth = extraWidth * this.widths[i].width / sumOfPercents;
                }
                break block58;
            }
            float extraWidth = this.tableWidth - totalPercent - minTotalNonPercent;
            if (fixedAddition > 0.0f && (extraWidth < fixedAddition || flexibleAddition == 0.0f)) {
                for (int i = 0; i < this.numberOfColumns; ++i) {
                    if (this.widths[i].isPercent || !this.widths[i].isFixed) continue;
                    this.widths[i].finalWidth += (this.widths[i].width - this.widths[i].min) * extraWidth / fixedAddition;
                }
            } else if ((extraWidth -= fixedAddition) < flexibleAddition) {
                for (int i = 0; i < this.numberOfColumns; ++i) {
                    if (this.widths[i].isPercent) continue;
                    if (this.widths[i].isFixed) {
                        this.widths[i].finalWidth = this.widths[i].width;
                        continue;
                    }
                    this.widths[i].finalWidth += (this.widths[i].width - this.widths[i].min) * extraWidth / flexibleAddition;
                }
            } else {
                int i;
                float totalFixed = 0.0f;
                float totalFlexible = 0.0f;
                for (i = 0; i < this.numberOfColumns; ++i) {
                    if (this.widths[i].isPercent) continue;
                    if (this.widths[i].isFixed) {
                        this.widths[i].finalWidth = this.widths[i].width;
                        totalFixed += this.widths[i].width;
                        continue;
                    }
                    totalFlexible += this.widths[i].width;
                }
                extraWidth = this.tableWidth - totalPercent - totalFixed;
                for (i = 0; i < this.numberOfColumns; ++i) {
                    if (this.widths[i].isPercent || this.widths[i].isFixed) continue;
                    this.widths[i].finalWidth = this.widths[i].width * extraWidth / totalFlexible;
                }
            }
        }
        return this.extractWidths();
    }

    float[] fixedLayout() {
        float[] columnWidths;
        block10: {
            int i;
            int processedColumns;
            block9: {
                columnWidths = new float[this.numberOfColumns];
                for (int i2 = 0; i2 < this.numberOfColumns; ++i2) {
                    UnitValue colWidth = this.getTable().getColumnWidth(i2);
                    columnWidths[i2] = colWidth == null || colWidth.getValue() < 0.0f ? -1.0f : (colWidth.isPercentValue() ? colWidth.getValue() * this.tableWidth / 100.0f : colWidth.getValue());
                }
                processedColumns = 0;
                float remainWidth = this.tableWidth;
                for (i = 0; i < this.numberOfColumns; ++i) {
                    if (columnWidths[i] == -1.0f) {
                        Float cellWidth;
                        CellRenderer cell = this.tableRenderer.rows.get(0)[i];
                        if (cell == null || (cellWidth = cell.retrieveUnitValue(this.tableWidth, 77)) == null || !(cellWidth.floatValue() >= 0.0f)) continue;
                        int colspan = cell.getModelElement().getColspan();
                        for (int j = 0; j < colspan; ++j) {
                            columnWidths[i + j] = cellWidth.floatValue() / (float)colspan;
                        }
                        remainWidth -= columnWidths[i];
                        ++processedColumns;
                        continue;
                    }
                    remainWidth -= columnWidths[i];
                    ++processedColumns;
                }
                if (!(remainWidth > 0.0f)) break block9;
                if (this.numberOfColumns == processedColumns) {
                    i = 0;
                    while (i < this.numberOfColumns) {
                        int n = i++;
                        columnWidths[n] = columnWidths[n] + remainWidth / (float)this.numberOfColumns;
                    }
                } else {
                    for (i = 0; i < this.numberOfColumns; ++i) {
                        if (columnWidths[i] != -1.0f) continue;
                        columnWidths[i] = remainWidth / (float)(this.numberOfColumns - processedColumns);
                    }
                }
                break block10;
            }
            if (this.numberOfColumns == processedColumns) break block10;
            for (i = 0; i < this.numberOfColumns; ++i) {
                if (columnWidths[i] != -1.0f) continue;
                columnWidths[i] = 0.0f;
            }
        }
        return columnWidths;
    }

    private void calculateTableWidth(float availableWidth, boolean calculateTableMaxWidth) {
        this.fixedTableLayout = "fixed".equals(this.tableRenderer.getProperty(93, "auto").toLowerCase());
        UnitValue width = (UnitValue)this.tableRenderer.getProperty(77);
        if (this.fixedTableLayout && width != null && width.getValue() >= 0.0f) {
            this.fixedTableWidth = true;
            this.tableWidth = this.retrieveTableWidth(width, availableWidth);
            this.minWidth = width.isPercentValue() ? 0.0f : this.tableWidth;
        } else {
            this.fixedTableLayout = false;
            this.minWidth = -1.0f;
            if (calculateTableMaxWidth) {
                this.fixedTableWidth = false;
                this.tableWidth = this.retrieveTableWidth(availableWidth);
            } else if (width != null && width.getValue() >= 0.0f) {
                this.fixedTableWidth = true;
                this.tableWidth = this.retrieveTableWidth(width, availableWidth);
            } else {
                this.fixedTableWidth = false;
                this.tableWidth = this.retrieveTableWidth(availableWidth);
            }
        }
    }

    private float retrieveTableWidth(UnitValue width, float availableWidth) {
        return this.retrieveTableWidth(width.isPercentValue() ? width.getValue() * availableWidth / 100.0f : width.getValue());
    }

    private float retrieveTableWidth(float width) {
        float result = width - this.rightBorderMaxWidth / 2.0f - this.leftBorderMaxWidth / 2.0f;
        return result > 0.0f ? result : 0.0f;
    }

    private Table getTable() {
        return (Table)this.tableRenderer.getModelElement();
    }

    private void fillWidths(float[] minWidths, float[] maxWidths) {
        this.widths = new ColumnWidthData[minWidths.length];
        for (int i = 0; i < this.widths.length; ++i) {
            this.widths[i] = new ColumnWidthData(minWidths[i], maxWidths[i]);
        }
    }

    private void fillAndSortCells() {
        this.cells = new ArrayList<CellInfo>();
        if (this.tableRenderer.headerRenderer != null) {
            this.fillRendererCells(this.tableRenderer.headerRenderer, (byte)1);
        }
        this.fillRendererCells(this.tableRenderer, (byte)2);
        if (this.tableRenderer.footerRenderer != null) {
            this.fillRendererCells(this.tableRenderer.footerRenderer, (byte)3);
        }
        Collections.sort(this.cells);
    }

    private void fillRendererCells(TableRenderer renderer, byte region) {
        for (int row = 0; row < renderer.rows.size(); ++row) {
            for (int col = 0; col < this.numberOfColumns; ++col) {
                CellRenderer cell = renderer.rows.get(row)[col];
                if (cell == null) continue;
                this.cells.add(new CellInfo(cell, region));
            }
        }
    }

    private void warn100percent() {
        Logger logger = LoggerFactory.getLogger(TableWidths.class);
        logger.warn("Sum of table columns is greater than 100%.");
    }

    private float[] extractWidths() {
        float actualWidth = 0.0f;
        this.minWidth = 0.0f;
        float[] columnWidths = new float[this.widths.length];
        for (int i = 0; i < this.widths.length; ++i) {
            assert (this.widths[i].finalWidth >= 0.0f);
            columnWidths[i] = this.widths[i].finalWidth;
            actualWidth += this.widths[i].finalWidth;
            this.minWidth += this.widths[i].min;
        }
        if (actualWidth > this.tableWidth + MinMaxWidthUtils.getEps() * (float)this.widths.length) {
            Logger logger = LoggerFactory.getLogger(TableWidths.class);
            logger.warn("Table width is more than expected due to min width of cell(s).");
        }
        return columnWidths;
    }

    public String toString() {
        return "width=" + this.tableWidth + (this.fixedTableWidth ? "!!" : "");
    }

    private static class CellInfo
    implements Comparable<CellInfo> {
        static final byte HEADER = 1;
        static final byte BODY = 2;
        static final byte FOOTER = 3;
        private CellRenderer cell;
        private byte region;

        CellInfo(CellRenderer cell, byte region) {
            this.cell = cell;
            this.region = region;
        }

        CellRenderer getCell() {
            return this.cell;
        }

        int getCol() {
            return this.cell.getModelElement().getCol();
        }

        int getColspan() {
            return this.cell.getModelElement().getColspan();
        }

        int getRow() {
            return this.cell.getModelElement().getRow();
        }

        int getRowspan() {
            return this.cell.getModelElement().getRowspan();
        }

        UnitValue getWidth() {
            UnitValue widthValue = (UnitValue)this.cell.getProperty(77);
            if (widthValue == null || widthValue.isPercentValue()) {
                return widthValue;
            }
            Border[] borders = this.cell.getBorders();
            if (borders[1] != null) {
                widthValue.setValue(widthValue.getValue() + borders[1].getWidth() / 2.0f);
            }
            if (borders[3] != null) {
                widthValue.setValue(widthValue.getValue() + borders[3].getWidth() / 2.0f);
            }
            float[] paddings = this.cell.getPaddings();
            widthValue.setValue(widthValue.getValue() + paddings[1] + paddings[3]);
            return widthValue;
        }

        @Override
        public int compareTo(CellInfo o) {
            if (this.getColspan() == 1 ^ o.getColspan() == 1) {
                return this.getColspan() - o.getColspan();
            }
            if (this.region == o.region && this.getRow() == o.getRow()) {
                return this.getCol() + this.getColspan() - o.getCol() - o.getColspan();
            }
            return this.region == o.region ? this.getRow() - o.getRow() : this.region - o.region;
        }
    }

    private static class ColumnWidthData {
        final float min;
        float max;
        float width = 0.0f;
        float finalWidth = -1.0f;
        boolean isPercent = false;
        boolean isFixed = false;

        ColumnWidthData(float min, float max) {
            assert (min >= 0.0f);
            assert (max >= 0.0f);
            this.min = min > 0.0f ? min + MinMaxWidthUtils.getEps() : 0.0f;
            this.max = max > 0.0f ? Math.min(max + MinMaxWidthUtils.getEps(), 32760.0f) : 0.0f;
        }

        ColumnWidthData setPoints(float width) {
            assert (!this.isPercent);
            this.width = Math.max(this.width, width);
            return this;
        }

        ColumnWidthData resetPoints(float width) {
            this.width = width;
            this.isPercent = false;
            return this;
        }

        ColumnWidthData addPoints(float width) {
            assert (!this.isPercent);
            this.width += width;
            return this;
        }

        ColumnWidthData setPercents(float percent) {
            if (this.isPercent) {
                this.width = Math.max(this.width, percent);
            } else {
                this.isPercent = true;
                this.width = percent;
            }
            return this;
        }

        ColumnWidthData addPercents(float width) {
            assert (this.isPercent);
            this.width += width;
            return this;
        }

        ColumnWidthData setFixed(boolean fixed) {
            this.isFixed = fixed;
            return this;
        }

        boolean hasCollision() {
            assert (!this.isPercent);
            return this.min > this.width;
        }

        boolean checkCollision(float availableWidth) {
            assert (!this.isPercent);
            return this.min > this.width + availableWidth;
        }

        public String toString() {
            return "w=" + this.width + (this.isPercent ? "%" : "pt") + (this.isFixed ? " !!" : "") + ", min=" + this.min + ", max=" + this.max + ", finalWidth=" + this.finalWidth;
        }
    }
}

