/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.layout.property.BaseDirection;
import com.itextpdf.layout.renderer.LineRenderer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TypographyUtils {
    private static final Logger logger = LoggerFactory.getLogger(TypographyUtils.class);
    private static final String TYPOGRAPHY_PACKAGE = "com.itextpdf.typography.";
    private static final String SHAPER = "shaping.Shaper";
    private static final String BIDI_CHARACTER_MAP = "bidi.BidiCharacterMap";
    private static final String BIDI_BRACKET_MAP = "bidi.BidiBracketMap";
    private static final String BIDI_ALGORITHM = "bidi.BidiAlgorithm";
    private static final String APPLY_OTF_SCRIPT = "applyOtfScript";
    private static final String APPLY_KERNING = "applyKerning";
    private static final String GET_SUPPORTED_SCRIPTS = "getSupportedScripts";
    private static final String GET_CHARACTER_TYPES = "getCharacterTypes";
    private static final String GET_BRACKET_TYPES = "getBracketTypes";
    private static final String GET_BRACKET_VALUES = "getBracketValues";
    private static final String GET_PAIRED_BRACKET = "getPairedBracket";
    private static final String GET_LEVELS = "getLevels";
    private static final String COMPUTE_REORDERING = "computeReordering";
    private static final String INVERSE_REORDERING = "inverseReordering";
    private static final Collection<Character.UnicodeScript> SUPPORTED_SCRIPTS;
    private static final boolean TYPOGRAPHY_MODULE_INITIALIZED;
    private static Map<String, Class<?>> cachedClasses;
    private static Map<TypographyMethodSignature, AccessibleObject> cachedMethods;
    private static final String typographyNotFoundException = "Cannot find pdfCalligraph module, which was implicitly required by one of the layout properties";

    TypographyUtils() {
    }

    static void applyOtfScript(FontProgram fontProgram, GlyphLine text, Character.UnicodeScript script) {
        if (!TYPOGRAPHY_MODULE_INITIALIZED) {
            logger.warn(typographyNotFoundException);
        } else {
            TypographyUtils.callMethod("com.itextpdf.typography.shaping.Shaper", APPLY_OTF_SCRIPT, new Class[]{TrueTypeFont.class, GlyphLine.class, Character.UnicodeScript.class}, new Object[]{fontProgram, text, script});
        }
    }

    static void applyKerning(FontProgram fontProgram, GlyphLine text) {
        if (!TYPOGRAPHY_MODULE_INITIALIZED) {
            logger.warn(typographyNotFoundException);
        } else {
            TypographyUtils.callMethod("com.itextpdf.typography.shaping.Shaper", APPLY_KERNING, new Class[]{FontProgram.class, GlyphLine.class}, fontProgram, text);
        }
    }

    static byte[] getBidiLevels(BaseDirection baseDirection, int[] unicodeIds) {
        if (TYPOGRAPHY_MODULE_INITIALIZED) {
            byte direction;
            switch (baseDirection) {
                case LEFT_TO_RIGHT: {
                    direction = 0;
                    break;
                }
                case RIGHT_TO_LEFT: {
                    direction = 1;
                    break;
                }
                default: {
                    direction = 2;
                }
            }
            int len = unicodeIds.length;
            byte[] types = (byte[])TypographyUtils.callMethod("com.itextpdf.typography.bidi.BidiCharacterMap", GET_CHARACTER_TYPES, new Class[]{int[].class, Integer.TYPE, Integer.TYPE}, unicodeIds, 0, len);
            byte[] pairTypes = (byte[])TypographyUtils.callMethod("com.itextpdf.typography.bidi.BidiBracketMap", GET_BRACKET_TYPES, new Class[]{int[].class, Integer.TYPE, Integer.TYPE}, unicodeIds, 0, len);
            int[] pairValues = (int[])TypographyUtils.callMethod("com.itextpdf.typography.bidi.BidiBracketMap", GET_BRACKET_VALUES, new Class[]{int[].class, Integer.TYPE, Integer.TYPE}, unicodeIds, 0, len);
            Object bidiReorder = TypographyUtils.callConstructor("com.itextpdf.typography.bidi.BidiAlgorithm", new Class[]{byte[].class, byte[].class, int[].class, Byte.TYPE}, types, pairTypes, pairValues, direction);
            return (byte[])TypographyUtils.callMethod("com.itextpdf.typography.bidi.BidiAlgorithm", GET_LEVELS, bidiReorder, new Class[]{int[].class}, new Object[]{new int[]{len}});
        }
        logger.warn(typographyNotFoundException);
        return null;
    }

    static int[] reorderLine(List<LineRenderer.RendererGlyph> line, byte[] lineLevels, byte[] levels) {
        if (TYPOGRAPHY_MODULE_INITIALIZED) {
            int i;
            if (levels == null) {
                return null;
            }
            int[] reorder = (int[])TypographyUtils.callMethod("com.itextpdf.typography.bidi.BidiAlgorithm", COMPUTE_REORDERING, new Class[]{byte[].class}, new Object[]{lineLevels});
            int[] inverseReorder = (int[])TypographyUtils.callMethod("com.itextpdf.typography.bidi.BidiAlgorithm", INVERSE_REORDERING, new Class[]{int[].class}, new Object[]{reorder});
            ArrayList<LineRenderer.RendererGlyph> reorderedLine = new ArrayList<LineRenderer.RendererGlyph>(lineLevels.length);
            for (i = 0; i < line.size(); ++i) {
                int unicode;
                int pairedBracket;
                reorderedLine.add(line.get(reorder[i]));
                if (levels[reorder[i]] % 2 != 1 || !((LineRenderer.RendererGlyph)reorderedLine.get((int)i)).glyph.hasValidUnicode() || (pairedBracket = ((Integer)TypographyUtils.callMethod("com.itextpdf.typography.bidi.BidiBracketMap", GET_PAIRED_BRACKET, new Class[]{Integer.TYPE}, unicode = ((LineRenderer.RendererGlyph)reorderedLine.get((int)i)).glyph.getUnicode())).intValue()) == unicode) continue;
                PdfFont font = ((LineRenderer.RendererGlyph)reorderedLine.get((int)i)).renderer.getPropertyAsFont(20);
                reorderedLine.set(i, new LineRenderer.RendererGlyph(font.getGlyph(pairedBracket), ((LineRenderer.RendererGlyph)reorderedLine.get((int)i)).renderer));
            }
            for (i = 0; i < reorderedLine.size(); ++i) {
                Glyph glyph = ((LineRenderer.RendererGlyph)reorderedLine.get((int)i)).glyph;
                if (!glyph.hasPlacement()) continue;
                int oldAnchor = reorder[i] + glyph.getAnchorDelta();
                int newPos = inverseReorder[oldAnchor];
                int newAnchorDelta = newPos - i;
                glyph.setAnchorDelta((short)newAnchorDelta);
            }
            line.clear();
            line.addAll(reorderedLine);
            return reorder;
        }
        logger.warn(typographyNotFoundException);
        return null;
    }

    static Collection<Character.UnicodeScript> getSupportedScripts() {
        if (!TYPOGRAPHY_MODULE_INITIALIZED) {
            logger.warn(typographyNotFoundException);
            return null;
        }
        if (SUPPORTED_SCRIPTS != null) {
            return SUPPORTED_SCRIPTS;
        }
        return (Collection)TypographyUtils.callMethod("com.itextpdf.typography.shaping.Shaper", GET_SUPPORTED_SCRIPTS, new Class[0], new Object[0]);
    }

    static boolean isTypographyModuleInitialized() {
        return TYPOGRAPHY_MODULE_INITIALIZED;
    }

    private static Object callMethod(String className, String methodName, Class[] parameterTypes, Object ... args) {
        return TypographyUtils.callMethod(className, methodName, null, parameterTypes, args);
    }

    private static Object callMethod(String className, String methodName, Object target, Class[] parameterTypes, Object ... args) {
        try {
            Method method = TypographyUtils.findMethod(className, methodName, parameterTypes);
            return method.invoke(target, args);
        }
        catch (NoSuchMethodException e) {
            logger.warn(MessageFormat.format("Cannot find method {0} for class {1}", methodName, className));
        }
        catch (ClassNotFoundException e) {
            logger.warn(MessageFormat.format("Cannot find class {0}", className));
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
        return null;
    }

    private static Object callConstructor(String className, Class[] parameterTypes, Object ... args) {
        try {
            Constructor<?> constructor = TypographyUtils.findConstructor(className, parameterTypes);
            return constructor.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            logger.warn(MessageFormat.format("Cannot find constructor for class {0}", className));
        }
        catch (ClassNotFoundException e) {
            logger.warn(MessageFormat.format("Cannot find class {0}", className));
        }
        catch (Exception exc) {
            throw new RuntimeException(exc.toString(), exc);
        }
        return null;
    }

    private static Method findMethod(String className, String methodName, Class[] parameterTypes) throws NoSuchMethodException, ClassNotFoundException {
        TypographyMethodSignature tm = new TypographyMethodSignature(className, parameterTypes, methodName);
        Method m = (Method)cachedMethods.get(tm);
        if (m == null) {
            m = TypographyUtils.findClass(className).getMethod(methodName, parameterTypes);
            cachedMethods.put(tm, m);
        }
        return m;
    }

    private static Constructor<?> findConstructor(String className, Class[] parameterTypes) throws NoSuchMethodException, ClassNotFoundException {
        TypographyMethodSignature tc = new TypographyMethodSignature(className, parameterTypes);
        Constructor<?> c = (Constructor<?>)cachedMethods.get(tc);
        if (c == null) {
            c = TypographyUtils.findClass(className).getConstructor(parameterTypes);
            cachedMethods.put(tc, c);
        }
        return c;
    }

    private static Class<?> findClass(String className) throws ClassNotFoundException {
        Class<?> c = cachedClasses.get(className);
        if (c == null) {
            c = TypographyUtils.getTypographyClass(className);
            cachedClasses.put(className, c);
        }
        return c;
    }

    private static Class<?> getTypographyClass(String typographyClassName) throws ClassNotFoundException {
        return Class.forName(typographyClassName);
    }

    static {
        cachedClasses = new HashMap();
        cachedMethods = new HashMap<TypographyMethodSignature, AccessibleObject>();
        boolean moduleFound = false;
        try {
            Class<?> type = TypographyUtils.getTypographyClass("com.itextpdf.typography.shaping.Shaper");
            if (type != null) {
                moduleFound = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        TYPOGRAPHY_MODULE_INITIALIZED = moduleFound;
        SUPPORTED_SCRIPTS = moduleFound ? TypographyUtils.getSupportedScripts() : null;
    }

    private static class TypographyMethodSignature {
        protected final String className;
        protected Class[] parameterTypes;
        private final String methodName;

        TypographyMethodSignature(String className, Class[] parameterTypes) {
            this(className, parameterTypes, null);
        }

        TypographyMethodSignature(String className, Class[] parameterTypes, String methodName) {
            this.methodName = methodName;
            this.className = className;
            this.parameterTypes = parameterTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypographyMethodSignature that = (TypographyMethodSignature)o;
            if (!this.className.equals(that.className)) {
                return false;
            }
            if (!Arrays.equals(this.parameterTypes, that.parameterTypes)) {
                return false;
            }
            return this.methodName != null ? this.methodName.equals(that.methodName) : that.methodName == null;
        }

        public int hashCode() {
            int result = this.className.hashCode();
            result = 31 * result + Arrays.hashCode(this.parameterTypes);
            result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
            return result;
        }
    }
}

