/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.hyphenation.HyphenationConfig;
import com.itextpdf.layout.property.Background;
import com.itextpdf.layout.property.BaseDirection;
import com.itextpdf.layout.property.BorderRadius;
import com.itextpdf.layout.property.FontKerning;
import com.itextpdf.layout.property.HorizontalAlignment;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.TransparentColor;
import com.itextpdf.layout.property.Underline;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.splitting.ISplitCharacters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ElementPropertyContainer<T extends IPropertyContainer>
implements IPropertyContainer {
    protected Map<Integer, Object> properties = new HashMap<Integer, Object>();

    @Override
    public void setProperty(int property, Object value) {
        this.properties.put(property, value);
    }

    @Override
    public boolean hasProperty(int property) {
        return this.hasOwnProperty(property);
    }

    @Override
    public boolean hasOwnProperty(int property) {
        return this.properties.containsKey(property);
    }

    @Override
    public void deleteOwnProperty(int property) {
        this.properties.remove(property);
    }

    @Override
    public <T1> T1 getProperty(int property) {
        return this.getOwnProperty(property);
    }

    @Override
    public <T1> T1 getOwnProperty(int property) {
        return (T1)this.properties.get(property);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        switch (property) {
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return (T1)UnitValue.createPointValue(0.0f);
            }
        }
        return null;
    }

    public T setRelativePosition(float left, float top, float right, float bottom) {
        this.setProperty(52, 2);
        this.setProperty(34, Float.valueOf(left));
        this.setProperty(54, Float.valueOf(right));
        this.setProperty(73, Float.valueOf(top));
        this.setProperty(14, Float.valueOf(bottom));
        return (T)this;
    }

    public T setFixedPosition(float left, float bottom, float width) {
        this.setFixedPosition(left, bottom, UnitValue.createPointValue(width));
        return (T)this;
    }

    public T setFixedPosition(float left, float bottom, UnitValue width) {
        this.setProperty(52, 4);
        this.setProperty(34, Float.valueOf(left));
        this.setProperty(14, Float.valueOf(bottom));
        this.setProperty(77, width);
        return (T)this;
    }

    public T setFixedPosition(int pageNumber, float left, float bottom, float width) {
        this.setFixedPosition(left, bottom, width);
        this.setProperty(51, pageNumber);
        return (T)this;
    }

    public T setFixedPosition(int pageNumber, float left, float bottom, UnitValue width) {
        this.setFixedPosition(left, bottom, width);
        this.setProperty(51, pageNumber);
        return (T)this;
    }

    public T setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.setProperty(28, (Object)horizontalAlignment);
        return (T)this;
    }

    public T setFont(PdfFont font) {
        this.setProperty(20, font);
        return (T)this;
    }

    public T setFont(String font) {
        this.setProperty(20, font);
        return (T)this;
    }

    public T setFontColor(Color fontColor) {
        return this.setFontColor(fontColor, 1.0f);
    }

    public T setFontColor(Color fontColor, float opacity) {
        this.setProperty(21, fontColor != null ? new TransparentColor(fontColor, opacity) : null);
        return (T)this;
    }

    public T setFontSize(float fontSize) {
        UnitValue fontSizeAsUV = UnitValue.createPointValue(fontSize);
        this.setProperty(24, fontSizeAsUV);
        return (T)this;
    }

    public T setTextAlignment(TextAlignment alignment) {
        this.setProperty(70, (Object)alignment);
        return (T)this;
    }

    public T setCharacterSpacing(float charSpacing) {
        this.setProperty(15, Float.valueOf(charSpacing));
        return (T)this;
    }

    public T setWordSpacing(float wordSpacing) {
        this.setProperty(78, Float.valueOf(wordSpacing));
        return (T)this;
    }

    public T setFontKerning(FontKerning fontKerning) {
        this.setProperty(22, (Object)fontKerning);
        return (T)this;
    }

    public T setBackgroundColor(Color backgroundColor) {
        return this.setBackgroundColor(backgroundColor, 1.0f);
    }

    public T setBackgroundColor(Color backgroundColor, float opacity) {
        return this.setBackgroundColor(backgroundColor, opacity, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public T setBackgroundColor(Color backgroundColor, float extraLeft, float extraTop, float extraRight, float extraBottom) {
        return this.setBackgroundColor(backgroundColor, 1.0f, extraLeft, extraTop, extraRight, extraBottom);
    }

    public T setBackgroundColor(Color backgroundColor, float opacity, float extraLeft, float extraTop, float extraRight, float extraBottom) {
        this.setProperty(6, backgroundColor != null ? new Background(backgroundColor, opacity, extraLeft, extraTop, extraRight, extraBottom) : null);
        return (T)this;
    }

    public T setBorder(Border border) {
        this.setProperty(9, border);
        return (T)this;
    }

    public T setBorderTop(Border border) {
        this.setProperty(13, border);
        return (T)this;
    }

    public T setBorderRight(Border border) {
        this.setProperty(12, border);
        return (T)this;
    }

    public T setBorderBottom(Border border) {
        this.setProperty(10, border);
        return (T)this;
    }

    public T setBorderLeft(Border border) {
        this.setProperty(11, border);
        return (T)this;
    }

    public T setBorderRadius(BorderRadius borderRadius) {
        this.setProperty(101, borderRadius);
        return (T)this;
    }

    public T setBorderBottomLeftRadius(BorderRadius borderRadius) {
        this.setProperty(113, borderRadius);
        return (T)this;
    }

    public T setBorderBottomRightRadius(BorderRadius borderRadius) {
        this.setProperty(112, borderRadius);
        return (T)this;
    }

    public T setBorderTopLeftRadius(BorderRadius borderRadius) {
        this.setProperty(110, borderRadius);
        return (T)this;
    }

    public T setBorderTopRightRadius(BorderRadius borderRadius) {
        this.setProperty(111, borderRadius);
        return (T)this;
    }

    public T setSplitCharacters(ISplitCharacters splitCharacters) {
        this.setProperty(62, splitCharacters);
        return (T)this;
    }

    public ISplitCharacters getSplitCharacters() {
        return (ISplitCharacters)this.getProperty(62);
    }

    public Integer getTextRenderingMode() {
        return (Integer)this.getProperty(71);
    }

    public T setTextRenderingMode(int textRenderingMode) {
        this.setProperty(71, textRenderingMode);
        return (T)this;
    }

    public Color getStrokeColor() {
        return (Color)this.getProperty(63);
    }

    public T setStrokeColor(Color strokeColor) {
        this.setProperty(63, strokeColor);
        return (T)this;
    }

    public Float getStrokeWidth() {
        return (Float)this.getProperty(64);
    }

    public T setStrokeWidth(float strokeWidth) {
        this.setProperty(64, Float.valueOf(strokeWidth));
        return (T)this;
    }

    public T setBold() {
        this.setProperty(8, true);
        return (T)this;
    }

    public T setItalic() {
        this.setProperty(31, true);
        return (T)this;
    }

    public T setLineThrough() {
        return this.setUnderline(null, 0.75f, 0.0f, 0.0f, 0.29166666f, 0);
    }

    public T setUnderline() {
        return this.setUnderline(null, 0.75f, 0.0f, 0.0f, -0.125f, 0);
    }

    public T setUnderline(float thickness, float yPosition) {
        return this.setUnderline(null, thickness, 0.0f, yPosition, 0.0f, 0);
    }

    public T setUnderline(Color color, float thickness, float thicknessMul, float yPosition, float yPositionMul, int lineCapStyle) {
        return this.setUnderline(color, 1.0f, thickness, thicknessMul, yPosition, yPositionMul, lineCapStyle);
    }

    public T setUnderline(Color color, float opacity, float thickness, float thicknessMul, float yPosition, float yPositionMul, int lineCapStyle) {
        Underline newUnderline = new Underline(color, opacity, thickness, thicknessMul, yPosition, yPositionMul, lineCapStyle);
        Object currentProperty = this.getProperty(74);
        if (currentProperty instanceof List) {
            ((List)currentProperty).add(newUnderline);
        } else if (currentProperty instanceof Underline) {
            ArrayList<Underline> mergedUnderlines = new ArrayList<Underline>();
            mergedUnderlines.add((Underline)currentProperty);
            mergedUnderlines.add(newUnderline);
            this.setProperty(74, mergedUnderlines);
        } else {
            this.setProperty(74, newUnderline);
        }
        return (T)this;
    }

    public T setBaseDirection(BaseDirection baseDirection) {
        this.setProperty(7, (Object)baseDirection);
        return (T)this;
    }

    public T setHyphenation(HyphenationConfig hyphenationConfig) {
        this.setProperty(30, hyphenationConfig);
        return (T)this;
    }

    public T setFontScript(Character.UnicodeScript script) {
        this.setProperty(23, (Object)script);
        return (T)this;
    }

    public T setDestination(String destination) {
        this.setProperty(17, destination);
        return (T)this;
    }

    public T setOpacity(Float opacity) {
        this.setProperty(92, opacity);
        return (T)this;
    }
}

