/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.TableBorderUtil;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.List;

abstract class TableBorders {
    protected List<List<Border>> horizontalBorders = new ArrayList<List<Border>>();
    protected List<List<Border>> verticalBorders = new ArrayList<List<Border>>();
    protected final int numberOfColumns;
    protected Border[] tableBoundingBorders = new Border[4];
    protected List<CellRenderer[]> rows;
    protected int startRow;
    protected int finishRow;
    protected float leftBorderMaxWidth;
    protected float rightBorderMaxWidth;
    protected int largeTableIndexOffset = 0;

    public TableBorders(List<CellRenderer[]> rows, int numberOfColumns, Border[] tableBoundingBorders) {
        this.rows = rows;
        this.numberOfColumns = numberOfColumns;
        this.setTableBoundingBorders(tableBoundingBorders);
    }

    public TableBorders(List<CellRenderer[]> rows, int numberOfColumns, Border[] tableBoundingBorders, int largeTableIndexOffset) {
        this(rows, numberOfColumns, tableBoundingBorders);
        this.largeTableIndexOffset = largeTableIndexOffset;
    }

    protected abstract TableBorders drawHorizontalBorder(int var1, float var2, float var3, PdfCanvas var4, float[] var5);

    protected abstract TableBorders drawVerticalBorder(int var1, float var2, float var3, PdfCanvas var4, List<Float> var5);

    protected abstract TableBorders applyTopTableBorder(Rectangle var1, Rectangle var2, boolean var3, boolean var4, boolean var5);

    protected abstract TableBorders applyTopTableBorder(Rectangle var1, Rectangle var2, boolean var3);

    protected abstract TableBorders applyBottomTableBorder(Rectangle var1, Rectangle var2, boolean var3, boolean var4, boolean var5);

    protected abstract TableBorders applyBottomTableBorder(Rectangle var1, Rectangle var2, boolean var3);

    protected abstract TableBorders applyLeftAndRightTableBorder(Rectangle var1, boolean var2);

    protected abstract TableBorders skipFooter(Border[] var1);

    protected abstract TableBorders skipHeader(Border[] var1);

    protected abstract TableBorders collapseTableWithFooter(TableBorders var1, boolean var2);

    protected abstract TableBorders collapseTableWithHeader(TableBorders var1, boolean var2);

    protected abstract TableBorders fixHeaderOccupiedArea(Rectangle var1, Rectangle var2);

    protected abstract TableBorders applyCellIndents(Rectangle var1, float var2, float var3, float var4, float var5, boolean var6);

    public abstract List<Border> getVerticalBorder(int var1);

    public abstract List<Border> getHorizontalBorder(int var1);

    protected abstract float getCellVerticalAddition(float[] var1);

    protected abstract TableBorders updateBordersOnNewPage(boolean var1, boolean var2, TableRenderer var3, TableRenderer var4, TableRenderer var5);

    protected TableBorders initializeBorders() {
        ArrayList tempBorders;
        while (this.numberOfColumns + 1 > this.verticalBorders.size()) {
            tempBorders = new ArrayList();
            while (Math.max(this.rows.size(), 1) > tempBorders.size()) {
                tempBorders.add(null);
            }
            this.verticalBorders.add(tempBorders);
        }
        while (Math.max(this.rows.size(), 1) + 1 > this.horizontalBorders.size()) {
            tempBorders = new ArrayList();
            while (this.numberOfColumns > tempBorders.size()) {
                tempBorders.add(null);
            }
            this.horizontalBorders.add(tempBorders);
        }
        return this;
    }

    protected TableBorders setTableBoundingBorders(Border[] borders) {
        this.tableBoundingBorders = new Border[4];
        if (null != borders) {
            for (int i = 0; i < borders.length; ++i) {
                this.tableBoundingBorders[i] = borders[i];
            }
        }
        return this;
    }

    protected TableBorders setRowRange(int startRow, int finishRow) {
        this.startRow = startRow;
        this.finishRow = finishRow;
        return this;
    }

    protected TableBorders setStartRow(int row) {
        this.startRow = row;
        return this;
    }

    protected TableBorders setFinishRow(int row) {
        this.finishRow = row;
        return this;
    }

    public float getLeftBorderMaxWidth() {
        return this.leftBorderMaxWidth;
    }

    public float getRightBorderMaxWidth() {
        return this.rightBorderMaxWidth;
    }

    public float getMaxTopWidth() {
        float width = 0.0f;
        Border widestBorder = this.getWidestHorizontalBorder(this.startRow);
        if (null != widestBorder && widestBorder.getWidth() >= width) {
            width = widestBorder.getWidth();
        }
        return width;
    }

    public float getMaxBottomWidth() {
        float width = 0.0f;
        Border widestBorder = this.getWidestHorizontalBorder(this.finishRow + 1);
        if (null != widestBorder && widestBorder.getWidth() >= width) {
            width = widestBorder.getWidth();
        }
        return width;
    }

    public float getMaxRightWidth() {
        float width = 0.0f;
        Border widestBorder = this.getWidestVerticalBorder(this.verticalBorders.size() - 1);
        if (null != widestBorder && widestBorder.getWidth() >= width) {
            width = widestBorder.getWidth();
        }
        return width;
    }

    public float getMaxLeftWidth() {
        float width = 0.0f;
        Border widestBorder = this.getWidestVerticalBorder(0);
        if (null != widestBorder && widestBorder.getWidth() >= width) {
            width = widestBorder.getWidth();
        }
        return width;
    }

    public Border getWidestVerticalBorder(int col) {
        return TableBorderUtil.getWidestBorder(this.getVerticalBorder(col));
    }

    public Border getWidestVerticalBorder(int col, int start, int end) {
        return TableBorderUtil.getWidestBorder(this.getVerticalBorder(col), start, end);
    }

    public Border getWidestHorizontalBorder(int row) {
        return TableBorderUtil.getWidestBorder(this.getHorizontalBorder(row));
    }

    public Border getWidestHorizontalBorder(int row, int start, int end) {
        return TableBorderUtil.getWidestBorder(this.getHorizontalBorder(row), start, end);
    }

    public List<Border> getFirstHorizontalBorder() {
        return this.getHorizontalBorder(this.startRow);
    }

    public List<Border> getLastHorizontalBorder() {
        return this.getHorizontalBorder(this.finishRow + 1);
    }

    public List<Border> getFirstVerticalBorder() {
        return this.getVerticalBorder(0);
    }

    public List<Border> getLastVerticalBorder() {
        return this.getVerticalBorder(this.verticalBorders.size() - 1);
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getFinishRow() {
        return this.finishRow;
    }

    public Border[] getTableBoundingBorders() {
        return this.tableBoundingBorders;
    }

    public float[] getCellBorderIndents(int row, int col, int rowspan, int colspan) {
        Border border;
        int i;
        float[] indents = new float[4];
        List<Border> borderList = this.getHorizontalBorder(this.startRow + row - rowspan + 1);
        for (i = col; i < col + colspan; ++i) {
            border = borderList.get(i);
            if (null == border || !(border.getWidth() > indents[0])) continue;
            indents[0] = border.getWidth();
        }
        borderList = this.getVerticalBorder(col + colspan);
        for (i = this.startRow + row - rowspan + 1; i < this.startRow + row + 1; ++i) {
            border = borderList.get(i);
            if (null == border || !(border.getWidth() > indents[1])) continue;
            indents[1] = border.getWidth();
        }
        borderList = this.getHorizontalBorder(this.startRow + row + 1);
        for (i = col; i < col + colspan; ++i) {
            border = borderList.get(i);
            if (null == border || !(border.getWidth() > indents[2])) continue;
            indents[2] = border.getWidth();
        }
        borderList = this.getVerticalBorder(col);
        for (i = this.startRow + row - rowspan + 1; i < this.startRow + row + 1; ++i) {
            border = borderList.get(i);
            if (null == border || !(border.getWidth() > indents[3])) continue;
            indents[3] = border.getWidth();
        }
        return indents;
    }
}

