/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.font.selectorstrategy;

import com.itextpdf.commons.datastructures.Tuple2;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.layout.font.FontInfo;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSelector;
import com.itextpdf.layout.font.FontSet;
import com.itextpdf.layout.font.selectorstrategy.IFontSelectorStrategy;
import com.itextpdf.layout.renderer.TextPreprocessingUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFontSelectorStrategy
implements IFontSelectorStrategy {
    private final FontProvider fontProvider;
    private final FontSet additionalFonts;
    private final FontSelector fontSelector;

    public AbstractFontSelectorStrategy(FontProvider fontProvider, FontSelector fontSelector, FontSet additionalFonts) {
        this.fontProvider = fontProvider;
        this.additionalFonts = additionalFonts;
        this.fontSelector = fontSelector;
    }

    protected abstract boolean isCurrentFontCheckRequired();

    @Override
    public List<Tuple2<GlyphLine, PdfFont>> getGlyphLines(String text) {
        ArrayList<Tuple2<GlyphLine, PdfFont>> result = new ArrayList<Tuple2<GlyphLine, PdfFont>>();
        int index = 0;
        int indexDiacritic = -1;
        while (index < text.length()) {
            PdfFont currentFont = null;
            int indexSignificant = AbstractFontSelectorStrategy.nextSignificantIndex(index, text);
            if (indexSignificant < text.length()) {
                int codePoint = AbstractFontSelectorStrategy.extractCodePoint(text, indexDiacritic == -1 ? indexSignificant : indexDiacritic);
                currentFont = this.matchFont(codePoint, this.fontSelector, this.fontProvider, this.additionalFonts);
            }
            ArrayList resolvedGlyphs = new ArrayList();
            if (currentFont != null) {
                Character.UnicodeScript firstScript = null;
                int to = indexSignificant;
                boolean breakRequested = false;
                int i = indexSignificant;
                while (i < text.length()) {
                    Character.UnicodeScript currScript;
                    int codePoint = AbstractFontSelectorStrategy.extractCodePoint(text, i);
                    if (codePoint > 65535) {
                        ++i;
                    }
                    if (this.isCurrentFontCheckRequired() && i != indexDiacritic - 1) {
                        PdfFont pdfFont = this.matchFont(codePoint, this.fontSelector, this.fontProvider, this.additionalFonts);
                        int nextSignificant = AbstractFontSelectorStrategy.nextSignificantIndex(i, text);
                        if (nextSignificant != i && nextSignificant < text.length()) {
                            PdfFont nextFont = this.matchFont(AbstractFontSelectorStrategy.extractCodePoint(text, nextSignificant), this.fontSelector, this.fontProvider, this.additionalFonts);
                            if (currentFont != pdfFont && nextFont != currentFont) {
                                breakRequested = true;
                            }
                        } else if (pdfFont != null && currentFont != pdfFont) {
                            breakRequested = true;
                        }
                    }
                    if (i > indexDiacritic) {
                        if (TextUtil.isDiacritic((int)codePoint)) {
                            boolean isPreviousMatchFont;
                            PdfFont diacriticFont = this.matchFont(codePoint, this.fontSelector, this.fontProvider, this.additionalFonts);
                            boolean bl = isPreviousMatchFont = i == 0 || diacriticFont == null || diacriticFont.containsGlyph(AbstractFontSelectorStrategy.extractCodePoint(text, i - 1));
                            if (diacriticFont != null && diacriticFont != currentFont && isPreviousMatchFont) {
                                if (indexDiacritic != i - 1) {
                                    breakRequested = true;
                                }
                                indexDiacritic = i;
                                if (breakRequested) {
                                    to = i - 2;
                                }
                            }
                        } else {
                            indexDiacritic = -1;
                        }
                    }
                    if (AbstractFontSelectorStrategy.isSignificantUnicodeScript(currScript = Character.UnicodeScript.of(codePoint))) {
                        if (firstScript == null) {
                            firstScript = currScript;
                        } else if (firstScript != currScript) {
                            breakRequested = true;
                        }
                    }
                    if (breakRequested) break;
                    to = i++;
                }
                if (to < index) continue;
                int numOfAppendedGlyphs = currentFont.appendGlyphs(text, index, to, resolvedGlyphs);
                index += numOfAppendedGlyphs;
            }
            if (resolvedGlyphs.isEmpty()) {
                currentFont = AbstractFontSelectorStrategy.getPdfFont(this.fontSelector.bestMatch(), this.fontProvider, this.additionalFonts);
                if (index != indexSignificant) {
                    index += currentFont.appendGlyphs(text, index, indexSignificant - 1, resolvedGlyphs);
                }
                while (index <= indexSignificant && index < text.length()) {
                    index += currentFont.appendAnyGlyph(text, index, resolvedGlyphs);
                }
            }
            GlyphLine tempGlyphLine = new GlyphLine(resolvedGlyphs);
            GlyphLine finalGlyphLine = TextPreprocessingUtil.replaceSpecialWhitespaceGlyphs(tempGlyphLine, currentFont);
            result.add((Tuple2<GlyphLine, PdfFont>)new Tuple2((Object)finalGlyphLine, (Object)currentFont));
        }
        return result;
    }

    protected PdfFont matchFont(int codePoint, FontSelector fontSelector, FontProvider fontProvider, FontSet additionalFonts) {
        PdfFont matchedFont = null;
        for (FontInfo fontInfo : fontSelector.getFonts()) {
            PdfFont temptFont;
            if (!fontInfo.getFontUnicodeRange().contains(codePoint) || !(temptFont = AbstractFontSelectorStrategy.getPdfFont(fontInfo, fontProvider, additionalFonts)).containsGlyph(codePoint)) continue;
            matchedFont = temptFont;
            break;
        }
        return matchedFont;
    }

    private static int nextSignificantIndex(int startIndex, String text) {
        int nextValidChar;
        for (nextValidChar = startIndex; nextValidChar < text.length() && TextUtil.isWhitespaceOrNonPrintable((int)text.charAt(nextValidChar)); ++nextValidChar) {
        }
        return nextValidChar;
    }

    private static boolean isSignificantUnicodeScript(Character.UnicodeScript unicodeScript) {
        return unicodeScript != Character.UnicodeScript.COMMON && unicodeScript != Character.UnicodeScript.INHERITED;
    }

    private static int extractCodePoint(String text, int idx) {
        return TextUtil.isSurrogatePair((String)text, (int)idx) ? TextUtil.convertToUtf32((String)text, (int)idx) : (int)text.charAt(idx);
    }

    private static PdfFont getPdfFont(FontInfo fontInfo, FontProvider fontProvider, FontSet additionalFonts) {
        return fontProvider.getPdfFont(fontInfo, additionalFonts);
    }
}

