/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.tagging;

import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.tagutils.IRoleMappingResolver;
import com.itextpdf.kernel.pdf.tagutils.PdfAllowedTagRelations;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import com.itextpdf.layout.renderer.AreaBreakRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import com.itextpdf.layout.tagging.TaggingHintKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProhibitedTagRelationsResolver {
    private static final Map<String, String> updateRules20 = new HashMap<String, String>();
    private static final Map<String, String> updateRules17 = new HashMap<String, String>();
    private static final List<String> rolesToSkip = Arrays.asList("Div", "NonStruct", null);
    private static final PdfAllowedTagRelations allowedRelations = new PdfAllowedTagRelations();
    private final PdfDocument pdfDocument;
    private final Map<String, String> overriddenRoles = new HashMap<String, String>();

    public ProhibitedTagRelationsResolver(PdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
    }

    public void repairTagStructure(LayoutTaggingHelper taggingHelper, IRenderer topRender) {
        TaggingHintKey currentThk = LayoutTaggingHelper.getOrCreateHintKey(topRender);
        if (!currentThk.isAccessible()) {
            return;
        }
        String normalizedParentRole = this.resolveToFinalRole(taggingHelper, currentThk, false);
        for (IRenderer childRenderer : topRender.getChildRenderers()) {
            TaggingHintKey kid;
            if (childRenderer instanceof AreaBreakRenderer || !(kid = LayoutTaggingHelper.getOrCreateHintKey(childRenderer)).isAccessible() || ProhibitedTagRelationsResolver.isKidNonStructElement(kid)) continue;
            String normalizedKidRole = this.resolveToFinalRole(taggingHelper, kid, true);
            String key = ProhibitedTagRelationsResolver.generateKey(normalizedParentRole, normalizedKidRole);
            this.executeRoleReplacementRule(kid, key);
        }
    }

    public void overwriteTaggingRule(String parentRole, String childRole, String newRole) {
        this.overriddenRoles.put(ProhibitedTagRelationsResolver.generateKey(parentRole, childRole), newRole);
    }

    private void executeRoleReplacementRule(TaggingHintKey kid, String key) {
        Map<String, String> updateRules;
        Map<String, String> map = updateRules = PdfVersion.PDF_2_0.equals((Object)this.pdfDocument.getPdfVersion()) ? updateRules20 : updateRules17;
        if (updateRules.containsKey(key)) {
            kid.setOverriddenRole(updateRules.get(key));
        }
        if (this.overriddenRoles.containsKey(key)) {
            kid.setOverriddenRole(this.overriddenRoles.get(key));
        }
    }

    private static boolean isKidNonStructElement(TaggingHintKey kid) {
        if (kid.getAccessibleElement() == null) {
            return false;
        }
        if (kid.getAccessibleElement().getAccessibilityProperties() == null) {
            return false;
        }
        return "NonStruct".equals(kid.getAccessibleElement().getAccessibilityProperties().getRole()) || "NonStruct".equals(kid.getOverriddenRole());
    }

    private static String generateKey(String parentRole, String childRole) {
        return parentRole + ":" + childRole;
    }

    private String resolveToFinalRole(LayoutTaggingHelper helper, TaggingHintKey taggingHintKey, boolean isKid) {
        String role = taggingHintKey.getAccessibilityProperties().getRole();
        if (taggingHintKey.getOverriddenRole() != null) {
            role = taggingHintKey.getOverriddenRole();
        }
        role = this.resolveToStandardRole(role);
        role = allowedRelations.normalizeRole(role);
        if (isKid) {
            return role;
        }
        if (rolesToSkip.contains(role)) {
            return this.getParentRole(helper, taggingHintKey, rolesToSkip);
        }
        return role;
    }

    private String getParentRole(LayoutTaggingHelper helper, TaggingHintKey hintKey, List<String> rolesToSkip) {
        String currentRole = hintKey.getAccessibilityProperties().getRole();
        if (hintKey.getOverriddenRole() != null) {
            currentRole = hintKey.getOverriddenRole();
        }
        if (!rolesToSkip.contains(currentRole = this.resolveToStandardRole(currentRole))) {
            return currentRole;
        }
        TaggingHintKey parent = helper.getAccessibleParentHint(hintKey);
        if (parent == null) {
            return null;
        }
        return this.getParentRole(helper, parent, rolesToSkip);
    }

    private String resolveToStandardRole(String role) {
        if (role == null) {
            return null;
        }
        TagStructureContext tagStructureContext = this.pdfDocument.getTagStructureContext();
        IRoleMappingResolver resolver = tagStructureContext.resolveMappingToStandardOrDomainSpecificRole(role, tagStructureContext.getDocumentDefaultNamespace());
        if (resolver == null) {
            return role;
        }
        return resolver.getRole();
    }

    static {
        updateRules17.put(ProhibitedTagRelationsResolver.generateKey("H", "P"), "Span");
        updateRules17.put(ProhibitedTagRelationsResolver.generateKey("P", "P"), "Span");
        updateRules17.put(ProhibitedTagRelationsResolver.generateKey("P", "Div"), "Span");
        updateRules17.put(ProhibitedTagRelationsResolver.generateKey("TOC", "Span"), "Caption");
        updateRules17.put(ProhibitedTagRelationsResolver.generateKey("TOCI", "Span"), "Lbl");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("H", "P"), "Sub");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("Hn", "P"), "Sub");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("Form", "P"), "Lbl");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("Form", "Form"), "Div");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("Form", "Span"), "Lbl");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("Form", "Hn"), "Lbl");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("Lbl", "P"), "Span");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("P", "P"), "Span");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("P", "Div"), "Sub");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("Span", "P"), "Span");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("Span", "Div"), "Sub");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("Sub", "P"), "Span");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("Sub", "Sub"), "Span");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("Sub", "Div"), "Span");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("TOC", "Span"), "Caption");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("TOCI", "Span"), "Lbl");
        updateRules20.put(ProhibitedTagRelationsResolver.generateKey("Document", "Span"), "P");
    }
}

