/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1EncodableVector;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Enumerated;
import com.itextpdf.commons.bouncycastle.asn1.IASN1InputStream;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.IASN1OctetString;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Primitive;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Sequence;
import com.itextpdf.commons.bouncycastle.asn1.IASN1TaggedObject;
import com.itextpdf.commons.bouncycastle.asn1.IDERIA5String;
import com.itextpdf.commons.bouncycastle.asn1.IDEROctetString;
import com.itextpdf.commons.bouncycastle.asn1.IDERSet;
import com.itextpdf.commons.bouncycastle.asn1.ocsp.IBasicOCSPResponse;
import com.itextpdf.commons.bouncycastle.asn1.ocsp.IOCSPObjectIdentifiers;
import com.itextpdf.commons.bouncycastle.asn1.x509.ICRLDistPoint;
import com.itextpdf.commons.bouncycastle.asn1.x509.IDistributionPoint;
import com.itextpdf.commons.bouncycastle.asn1.x509.IDistributionPointName;
import com.itextpdf.commons.bouncycastle.asn1.x509.IGeneralName;
import com.itextpdf.commons.bouncycastle.asn1.x509.IGeneralNames;
import com.itextpdf.commons.bouncycastle.cert.IX509CertificateHolder;
import com.itextpdf.commons.bouncycastle.cert.jcajce.IJcaX509CertificateConverter;
import com.itextpdf.commons.bouncycastle.cert.ocsp.AbstractOCSPException;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IBasicOCSPResp;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ICertificateID;
import com.itextpdf.commons.bouncycastle.openssl.IPEMParser;
import com.itextpdf.commons.bouncycastle.operator.AbstractOperatorCreationException;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.signatures.SignUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtil {
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateUtil.class);

    public static List<CRL> getCRLs(X509Certificate certificate) throws CertificateException, CRLException, IOException {
        ArrayList<CRL> crls = new ArrayList<CRL>();
        for (String crlUrl : CertificateUtil.getCRLURLs(certificate)) {
            crls.add(CertificateUtil.getCRL(crlUrl));
        }
        return crls;
    }

    public static List<String> getCRLURLs(X509Certificate certificate) {
        IDistributionPoint[] dists;
        ArrayList<String> crls = new ArrayList<String>();
        for (IDistributionPoint p : dists = CertificateUtil.getDistributionPoints(certificate)) {
            IGeneralName[] names;
            IDistributionPointName distributionPointName = p.getDistributionPoint();
            if (FACTORY.createDistributionPointName().getFullName() != distributionPointName.getType()) continue;
            IGeneralNames generalNames = FACTORY.createGeneralNames(distributionPointName.getName());
            for (IGeneralName name : names = generalNames.getNames()) {
                if (name.getTagNo() != FACTORY.createGeneralName().getUniformResourceIdentifier()) continue;
                IDERIA5String derStr = FACTORY.createDERIA5String(FACTORY.createASN1TaggedObject((IASN1Encodable)name.toASN1Primitive()), false);
                crls.add(derStr.getString());
            }
        }
        return crls;
    }

    public static IDistributionPoint getDistributionPointByName(X509Certificate certificate, IDistributionPointName issuingDistributionPointName) {
        IDistributionPoint[] distributionPoints = CertificateUtil.getDistributionPoints(certificate);
        List<IGeneralName> issuingNames = Arrays.asList(FACTORY.createGeneralNames(issuingDistributionPointName.getName()).getNames());
        for (IDistributionPoint distributionPoint : distributionPoints) {
            IGeneralName[] names;
            IDistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
            IGeneralNames generalNames = distributionPointName.isNull() ? distributionPoint.getCRLIssuer() : FACTORY.createGeneralNames(distributionPointName.getName());
            for (IGeneralName name : names = generalNames.getNames()) {
                if (!issuingNames.contains(name)) continue;
                return distributionPoint;
            }
        }
        return null;
    }

    public static CRL getCRL(String url) throws IOException, CertificateException, CRLException {
        if (url == null) {
            return null;
        }
        return CertificateUtil.parseCrlFromStream(new URL(url).openStream());
    }

    public static CRL parseCrlFromStream(InputStream input) throws CertificateException, CRLException {
        return SignUtils.parseCrlFromStream(input);
    }

    public static CRL parseCrlFromBytes(byte[] crlBytes) throws CertificateException, CRLException {
        return SignUtils.parseCrlFromStream(new ByteArrayInputStream(crlBytes));
    }

    public static String getIssuerCertURL(CRL crl) {
        try {
            IASN1Primitive obj = CertificateUtil.getExtensionValue(crl, FACTORY.createExtension().getAuthorityInfoAccess().getId());
            return CertificateUtil.getValueFromAIAExtension(obj, "1.3.6.1.5.5.7.48.2");
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getOCSPURL(X509Certificate certificate) {
        try {
            IASN1Primitive obj = CertificateUtil.getExtensionValue(certificate, FACTORY.createExtension().getAuthorityInfoAccess().getId());
            return CertificateUtil.getValueFromAIAExtension(obj, "1.3.6.1.5.5.7.48.1");
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getIssuerCertURL(X509Certificate certificate) {
        try {
            IASN1Primitive obj = CertificateUtil.getExtensionValue(certificate, FACTORY.createExtension().getAuthorityInfoAccess().getId());
            return CertificateUtil.getValueFromAIAExtension(obj, "1.3.6.1.5.5.7.48.2");
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getTSAURL(X509Certificate certificate) {
        byte[] der = SignUtils.getExtensionValueByOid(certificate, "1.2.840.113583.1.1.9.1");
        if (der == null) {
            return null;
        }
        try {
            IASN1Primitive asn1obj = FACTORY.createASN1Primitive(der);
            IDEROctetString octets = FACTORY.createDEROctetString((IASN1Encodable)asn1obj);
            asn1obj = FACTORY.createASN1Primitive(octets.getOctets());
            IASN1Sequence asn1seq = FACTORY.createASN1SequenceInstance((Object)asn1obj);
            return CertificateUtil.getStringFromGeneralName(asn1seq.getObjectAt(1).toASN1Primitive());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Certificate generateCertificate(InputStream data) throws CertificateException {
        return SignUtils.generateCertificate(data, FACTORY.getProvider());
    }

    public static void retrieveRevocationInfoFromSignedData(IASN1TaggedObject taggedObj, Collection<CRL> crls, Collection<IBasicOCSPResponse> ocsps, Collection<IASN1Sequence> otherRevocationInfoFormats) throws IOException, CertificateException {
        Enumeration revInfo = FACTORY.createASN1Set(taggedObj, false).getObjects();
        while (revInfo.hasMoreElements()) {
            IASN1Sequence s = FACTORY.createASN1Sequence(revInfo.nextElement());
            IASN1ObjectIdentifier o = FACTORY.createASN1ObjectIdentifier(s.getObjectAt(0));
            if (o != null && "1.3.6.1.5.5.7.16.2".equals(o.getId())) {
                IASN1Sequence responseBytes;
                IASN1Sequence ocspResp = FACTORY.createASN1Sequence(s.getObjectAt(1));
                IASN1Enumerated respStatus = FACTORY.createASN1Enumerated(ocspResp.getObjectAt(0));
                if (respStatus.intValueExact() != FACTORY.createOCSPRespBuilderInstance().getSuccessful() || (responseBytes = FACTORY.createASN1Sequence(ocspResp.getObjectAt(1))) == null) continue;
                ocsps.add(CertificateUtil.createOcsp(responseBytes));
                continue;
            }
            try {
                crls.addAll(SignUtils.readAllCRLs(s.getEncoded()));
            }
            catch (CRLException ignored) {
                LOGGER.warn("Unable to parse signed data revocation info item since it is incorrect or unsupported (e.g. SCVP Request and Response).");
                otherRevocationInfoFormats.add(s);
            }
        }
    }

    public static IDERSet createRevocationInfoChoices(Collection<CRL> crls, Collection<IBasicOCSPResponse> ocsps, Collection<IASN1Sequence> otherRevocationInfoFormats) throws CRLException, IOException {
        if (crls.isEmpty() && ocsps.isEmpty()) {
            return null;
        }
        IASN1EncodableVector revocationInfoChoices = FACTORY.createASN1EncodableVector();
        for (CRL cRL : crls) {
            revocationInfoChoices.add((IASN1Primitive)FACTORY.createASN1Sequence(((X509CRL)cRL).getEncoded()));
        }
        for (IBasicOCSPResponse iBasicOCSPResponse : ocsps) {
            IASN1EncodableVector ocspResponseRevInfo = FACTORY.createASN1EncodableVector();
            ocspResponseRevInfo.add((IASN1Primitive)FACTORY.createASN1ObjectIdentifier("1.3.6.1.5.5.7.16.2"));
            IASN1EncodableVector ocspResponse = FACTORY.createASN1EncodableVector();
            ocspResponse.add(FACTORY.createOCSPResponseStatus(FACTORY.createOCSPRespBuilderInstance().getSuccessful()).toASN1Primitive());
            ocspResponse.add(FACTORY.createResponseBytes(FACTORY.createOCSPObjectIdentifiers().getIdPkixOcspBasic(), FACTORY.createDEROctetString(iBasicOCSPResponse.toASN1Primitive().getEncoded())).toASN1Primitive());
            ocspResponseRevInfo.add((IASN1Primitive)FACTORY.createDERSequence(ocspResponse));
            revocationInfoChoices.add((IASN1Primitive)FACTORY.createDERSequence(ocspResponseRevInfo));
        }
        for (IASN1Sequence iASN1Sequence : otherRevocationInfoFormats) {
            revocationInfoChoices.add((IASN1Primitive)iASN1Sequence);
        }
        return FACTORY.createDERSet(revocationInfoChoices);
    }

    public static boolean checkIfIssuersMatch(ICertificateID certID, X509Certificate issuerCert) throws AbstractOperatorCreationException, AbstractOCSPException, CertificateEncodingException, IOException {
        return SignUtils.checkIfIssuersMatch(certID, issuerCert);
    }

    public static byte[] getExtensionValueByOid(X509Certificate certificate, String id) {
        return SignUtils.getExtensionValueByOid(certificate, id);
    }

    public static boolean isSignatureValid(IBasicOCSPResp ocspResp, Certificate responderCert) {
        try {
            return SignUtils.isSignatureValid(ocspResp, responderCert, FACTORY.getProviderName());
        }
        catch (Exception e) {
            return false;
        }
    }

    static boolean isIssuerCertificate(X509Certificate subjectCertificate, X509Certificate issuerCertificate) {
        return subjectCertificate.getIssuerX500Principal().equals(issuerCertificate.getSubjectX500Principal());
    }

    public static boolean isSelfSigned(X509Certificate certificate) {
        return certificate.getIssuerX500Principal().equals(certificate.getSubjectX500Principal());
    }

    public static IASN1Primitive getExtensionValue(X509Certificate certificate, String oid) throws IOException {
        return CertificateUtil.getExtensionValueFromByteArray(SignUtils.getExtensionValueByOid(certificate, oid));
    }

    public static IASN1Primitive getExtensionValue(CRL crl, String oid) throws IOException {
        return CertificateUtil.getExtensionValueFromByteArray(SignUtils.getExtensionValueByOid(crl, oid));
    }

    public static X509Certificate createCertificateFromEncodedData(String encodedCertificateBytes) {
        try {
            byte[] bytes = Base64.getDecoder().decode(encodedCertificateBytes);
            IX509CertificateHolder certificateHolder = FACTORY.createX509CertificateHolder(bytes);
            return FACTORY.createJcaX509CertificateConverter().setProvider(FACTORY.getProvider()).getCertificate(certificateHolder);
        }
        catch (IOException | CertificateException e) {
            throw new PdfException("Failed to retrieve certificates from binary data.", (Throwable)e);
        }
    }

    public static Certificate[] readCertificatesFromPem(InputStream pemFileStream) {
        try {
            List<IX509CertificateHolder> certificatesHolders = CertificateUtil.readCertificates(pemFileStream);
            IJcaX509CertificateConverter converter = FACTORY.createJcaX509CertificateConverter().setProvider(FACTORY.getProvider());
            Certificate[] certificates = new Certificate[certificatesHolders.size()];
            for (int i = 0; i < certificatesHolders.size(); ++i) {
                certificates[i] = converter.getCertificate(certificatesHolders.get(i));
            }
            return certificates;
        }
        catch (IOException | CertificateException e) {
            throw new PdfException("Failed to retrieve certificates from binary data.", (Throwable)e);
        }
    }

    private static List<IX509CertificateHolder> readCertificates(InputStream pemFileStream) throws IOException {
        try (IPEMParser parser = FACTORY.createPEMParser((Reader)new InputStreamReader(pemFileStream, StandardCharsets.UTF_8));){
            Object readObject = parser.readObject();
            ArrayList<IX509CertificateHolder> certificateHolders = new ArrayList<IX509CertificateHolder>();
            while (readObject != null) {
                if (readObject instanceof IX509CertificateHolder) {
                    certificateHolders.add((IX509CertificateHolder)readObject);
                }
                readObject = parser.readObject();
            }
            ArrayList<IX509CertificateHolder> arrayList = certificateHolders;
            return arrayList;
        }
    }

    private static IASN1Primitive getExtensionValueFromByteArray(byte[] extensionValue) throws IOException {
        IASN1OctetString octs;
        if (extensionValue == null) {
            return null;
        }
        try (IASN1InputStream aIn = FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(extensionValue));){
            octs = FACTORY.createASN1OctetString((IASN1Encodable)aIn.readObject());
        }
        aIn = FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(octs.getOctets()));
        var3_2 = null;
        try {
            IASN1Primitive iASN1Primitive = aIn.readObject();
            return iASN1Primitive;
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (aIn != null) {
                if (var3_2 != null) {
                    try {
                        aIn.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    aIn.close();
                }
            }
        }
    }

    private static String getStringFromGeneralName(IASN1Primitive names) {
        IASN1TaggedObject taggedObject = FACTORY.createASN1TaggedObject((IASN1Encodable)names);
        return new String(FACTORY.createASN1OctetString(taggedObject, false).getOctets(), StandardCharsets.ISO_8859_1);
    }

    private static String getValueFromAIAExtension(IASN1Primitive extensionValue, String accessMethod) {
        if (extensionValue == null) {
            return null;
        }
        IASN1Sequence accessDescriptions = FACTORY.createASN1Sequence((IASN1Encodable)extensionValue);
        for (int i = 0; i < accessDescriptions.size(); ++i) {
            IASN1Sequence accessDescription = FACTORY.createASN1Sequence(accessDescriptions.getObjectAt(i));
            IASN1ObjectIdentifier id = FACTORY.createASN1ObjectIdentifier(accessDescription.getObjectAt(0));
            if (accessDescription.size() != 2 || id == null || !accessMethod.equals(id.getId())) continue;
            IASN1Primitive description = FACTORY.createASN1Primitive(accessDescription.getObjectAt(1));
            return CertificateUtil.getStringFromGeneralName(description);
        }
        return null;
    }

    private static IBasicOCSPResponse createOcsp(IASN1Sequence seq) throws IOException {
        IASN1ObjectIdentifier objectIdentifier = FACTORY.createASN1ObjectIdentifier(seq.getObjectAt(0));
        IOCSPObjectIdentifiers ocspObjectIdentifiers = FACTORY.createOCSPObjectIdentifiers();
        if (objectIdentifier != null && objectIdentifier.getId().equals(ocspObjectIdentifiers.getIdPkixOcspBasic().getId())) {
            IASN1OctetString os = FACTORY.createASN1OctetString(seq.getObjectAt(1));
            try (IASN1InputStream inp = FACTORY.createASN1InputStream(os.getOctets());){
                IBasicOCSPResponse iBasicOCSPResponse = FACTORY.createBasicOCSPResponse(inp.readObject());
                return iBasicOCSPResponse;
            }
        }
        return null;
    }

    private static IDistributionPoint[] getDistributionPoints(X509Certificate certificate) {
        IASN1Primitive obj;
        try {
            obj = CertificateUtil.getExtensionValue(certificate, FACTORY.createExtension().getCRlDistributionPoints().getId());
        }
        catch (IOException e) {
            obj = null;
        }
        if (obj == null) {
            return new IDistributionPoint[0];
        }
        ICRLDistPoint dist = FACTORY.createCRLDistPoint((Object)obj);
        return dist.getDistributionPoints();
    }
}

