/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation;

import com.itextpdf.commons.utils.Action;
import com.itextpdf.commons.utils.ThrowingAction;
import com.itextpdf.commons.utils.ThrowingSupplier;
import com.itextpdf.signatures.validation.SafeCallingAvoidantException;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.util.function.Function;
import java.util.function.Supplier;

public final class SafeCalling {
    private SafeCalling() {
    }

    public static void onExceptionLog(ThrowingAction action, ValidationReport report, Function<Exception, ReportItem> reportItemCreator) {
        try {
            action.execute();
        }
        catch (SafeCallingAvoidantException e) {
            throw e;
        }
        catch (Exception e) {
            report.addReportItem(reportItemCreator.apply(e));
        }
    }

    public static <T> T onExceptionLog(ThrowingSupplier<T> action, T defaultValue, ValidationReport report, Function<Exception, ReportItem> reportItemCreator) {
        try {
            return (T)action.get();
        }
        catch (SafeCallingAvoidantException e) {
            throw e;
        }
        catch (Exception e) {
            report.addReportItem(reportItemCreator.apply(e));
            return defaultValue;
        }
    }

    public static void onRuntimeExceptionLog(Action action, ValidationReport report, Function<Exception, ReportItem> reportItemCreator) {
        try {
            action.execute();
        }
        catch (SafeCallingAvoidantException e) {
            throw e;
        }
        catch (RuntimeException e) {
            report.addReportItem(reportItemCreator.apply(e));
        }
    }

    public static <T> T onRuntimeExceptionLog(Supplier<T> action, T defaultValue, ValidationReport report, Function<Exception, ReportItem> reportItemCreator) {
        try {
            return action.get();
        }
        catch (SafeCallingAvoidantException e) {
            throw e;
        }
        catch (RuntimeException e) {
            report.addReportItem(reportItemCreator.apply(e));
            return defaultValue;
        }
    }
}

