/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.signatures.validation.lotl.CountryServiceContext;
import com.itextpdf.signatures.validation.lotl.CountrySpecificLotlFetcher;
import com.itextpdf.signatures.validation.lotl.EuropeanLotlFetcher;
import com.itextpdf.signatures.validation.lotl.EuropeanResourceFetcher;
import com.itextpdf.signatures.validation.lotl.IServiceContext;
import com.itextpdf.signatures.validation.lotl.LotlService;
import com.itextpdf.signatures.validation.lotl.LotlTrustedStore;
import com.itextpdf.signatures.validation.lotl.PivotFetcher;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.util.ArrayList;
import java.util.List;

public class LotlValidator {
    public static final String LOTL_VALIDATION = "Lotl validation.";
    static final String JOURNAL_CERT_NOT_PARSABLE = "One of EU Journal trusted certificates in not parsable. It will be ignored.";
    static final String LOTL_FETCHING_PROPERTIES_NOT_PROVIDED = "Lotl fetching properties have to be provided in order to use Lotl Validator. See \"ValidationChainBuilder#withLotlFetchingProperties\"";
    static final String LOTL_VALIDATION_UNSUCCESSFUL = "Lotl chain validation wasn't successful, trusted certificates were not parsed.";
    static final String UNABLE_TO_RETRIEVE_PIVOT = "Unable to retrieve pivot Lotl with {0} url. Lotl validation isn't successful.";
    static final String UNABLE_TO_RETRIEVE_LOTL = "Unable to retrieve main Lotl file. Lotl validation isn't successful.";
    private final List<CountryServiceContext> nationalTrustedCertificates = new ArrayList<CountryServiceContext>();
    private final LotlService service;

    public LotlValidator(LotlService service) {
        this.service = service;
    }

    public ValidationReport validate() {
        ValidationReport report = new ValidationReport();
        EuropeanLotlFetcher.Result lotl = this.service.getLotlBytes();
        if (!lotl.getLocalReport().getLogs().isEmpty()) {
            report.merge(lotl.getLocalReport());
            return report;
        }
        EuropeanResourceFetcher.Result europeanResult = this.service.getEUJournalCertificates();
        report.merge(europeanResult.getLocalReport());
        PivotFetcher.Result result = this.service.getAndValidatePivotFiles(lotl.getLotlXml(), europeanResult.getCertificates());
        report.merge(result.getLocalReport());
        if (result.getLocalReport().getValidationResult() != ValidationReport.ValidationResult.VALID) {
            return report;
        }
        List<CountrySpecificLotlFetcher.Result> entries = this.service.getCountrySpecificLotlFiles(lotl.getLotlXml());
        for (CountrySpecificLotlFetcher.Result countrySpecificResult : entries) {
            if (!this.service.getLotlFetchingProperties().shouldProcessCountry(countrySpecificResult.getCountrySpecificLotl().getSchemeTerritory())) continue;
            report.merge(countrySpecificResult.getLocalReport());
            this.nationalTrustedCertificates.addAll(LotlTrustedStore.mapIServiceContextToCountry(countrySpecificResult.getContexts()));
        }
        return report;
    }

    List<IServiceContext> getNationalTrustedCertificates() {
        return new ArrayList<IServiceContext>(this.nationalTrustedCertificates);
    }
}

