/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.utils.XmlProcessorCreator;
import com.itextpdf.signatures.validation.lotl.CertificateSelector;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class XmlValidationUtils {
    static final String CERTIFICATE_NOT_FOUND = "\"X509Certificate\" object isn't found in the signature. Other certificate sources are not supported.";
    static final String KEY_INFO_NULL = "Key info in XML signature cannot be null.";

    private XmlValidationUtils() {
    }

    static boolean createXmlDocumentAndCheckValidity(InputStream xmlDocumentInputStream, CertificateSelector keySelector) throws IOException, SAXException, XMLSecurityException {
        Document xmlDocument = XmlProcessorCreator.createSafeDocumentBuilder((boolean)true, (boolean)false).parse(xmlDocumentInputStream);
        XmlValidationUtils.preProcessXmlDocument(xmlDocument);
        Node sigElement = xmlDocument.getElementsByTagName("ds:Signature").item(0);
        if (sigElement == null) {
            sigElement = xmlDocument.getElementsByTagName("dsig:Signature").item(0);
        }
        if (sigElement == null) {
            sigElement = xmlDocument.getElementsByTagName("Signature").item(0);
        }
        Init.init();
        XMLSignature signature = new XMLSignature((Element)sigElement, "", true, BouncyCastleFactoryCreator.getFactory().getProvider());
        if (signature.getKeyInfo() == null) {
            throw new PdfException(KEY_INFO_NULL);
        }
        X509Certificate cert = signature.getKeyInfo().getX509Certificate();
        if (cert == null) {
            throw new PdfException(CERTIFICATE_NOT_FOUND);
        }
        keySelector.setCertificate(cert);
        return signature.checkSignatureValue(cert);
    }

    private static void preProcessXmlDocument(Document xmlDocument) {
        Element rootElement = xmlDocument.getDocumentElement();
        XmlValidationUtils.setIdRecursively(rootElement);
    }

    private static void setIdRecursively(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (!"ID".equalsIgnoreCase(attribute.getLocalName())) continue;
            element.setIdAttribute(attribute.getNodeName(), true);
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            XmlValidationUtils.setIdRecursively((Element)child);
        }
    }
}

