/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.report.xml;

import com.itextpdf.commons.utils.EncodingUtil;
import com.itextpdf.signatures.validation.report.xml.AbstractCollectableObject;
import com.itextpdf.signatures.validation.report.xml.CollectableObjectVisitor;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Objects;

class CertificateWrapper
extends AbstractCollectableObject {
    private final X509Certificate certificate;

    public CertificateWrapper(X509Certificate signingCertificate) {
        super("C");
        this.certificate = signingCertificate;
    }

    @Override
    public void accept(CollectableObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateWrapper that = (CertificateWrapper)o;
        return this.certificate.equals(that.certificate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.certificate);
    }

    public String getBase64ASN1Structure() {
        try {
            return EncodingUtil.toBase64((byte[])this.certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException("Error encoding certificate.", e);
        }
    }
}

