/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.selector.item;

import com.itextpdf.styledxmlparser.css.selector.CssSelector;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassDisabledSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassEmptySelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassFirstChildSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassFirstOfTypeSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassLastChildSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassLastOfTypeSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassNotSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassNthChildSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassNthLastChildSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassNthLastOfTypeSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassNthOfTypeSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoClassRootSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.CssPseudoElementSelectorItem;
import com.itextpdf.styledxmlparser.css.selector.item.ICssSelectorItem;
import com.itextpdf.styledxmlparser.node.INode;

public abstract class CssPseudoClassSelectorItem
implements ICssSelectorItem {
    protected String arguments;
    private String pseudoClass;

    protected CssPseudoClassSelectorItem(String pseudoClass) {
        this(pseudoClass, "");
    }

    protected CssPseudoClassSelectorItem(String pseudoClass, String arguments) {
        this.pseudoClass = pseudoClass;
        this.arguments = arguments;
    }

    public static CssPseudoClassSelectorItem create(String fullSelectorString) {
        String arguments;
        String pseudoClass;
        int indexOfParentheses = fullSelectorString.indexOf(40);
        if (indexOfParentheses == -1) {
            pseudoClass = fullSelectorString;
            arguments = "";
        } else {
            pseudoClass = fullSelectorString.substring(0, indexOfParentheses);
            arguments = fullSelectorString.substring(indexOfParentheses + 1, fullSelectorString.length() - 1).trim();
        }
        return CssPseudoClassSelectorItem.create(pseudoClass, arguments);
    }

    public static CssPseudoClassSelectorItem create(String pseudoClass, String arguments) {
        switch (pseudoClass) {
            case "empty": {
                return CssPseudoClassEmptySelectorItem.getInstance();
            }
            case "first-child": {
                return CssPseudoClassFirstChildSelectorItem.getInstance();
            }
            case "first-of-type": {
                return CssPseudoClassFirstOfTypeSelectorItem.getInstance();
            }
            case "last-child": {
                return CssPseudoClassLastChildSelectorItem.getInstance();
            }
            case "last-of-type": {
                return CssPseudoClassLastOfTypeSelectorItem.getInstance();
            }
            case "nth-child": {
                return new CssPseudoClassNthChildSelectorItem(arguments);
            }
            case "nth-last-child": {
                return new CssPseudoClassNthLastChildSelectorItem(arguments);
            }
            case "nth-of-type": {
                return new CssPseudoClassNthOfTypeSelectorItem(arguments);
            }
            case "nth-last-of-type": {
                return new CssPseudoClassNthLastOfTypeSelectorItem(arguments);
            }
            case "not": {
                CssSelector selector = new CssSelector(arguments);
                for (ICssSelectorItem item : selector.getSelectorItems()) {
                    if (!(item instanceof CssPseudoClassNotSelectorItem) && !(item instanceof CssPseudoElementSelectorItem)) continue;
                    return null;
                }
                return new CssPseudoClassNotSelectorItem(selector);
            }
            case "root": {
                return CssPseudoClassRootSelectorItem.getInstance();
            }
            case "link": {
                return new AlwaysApplySelectorItem(pseudoClass, arguments);
            }
            case "active": 
            case "focus": 
            case "hover": 
            case "target": 
            case "visited": {
                return new AlwaysNotApplySelectorItem(pseudoClass, arguments);
            }
            case "disabled": {
                return CssPseudoClassDisabledSelectorItem.getInstance();
            }
        }
        return null;
    }

    @Override
    public int getSpecificity() {
        return 1024;
    }

    @Override
    public boolean matches(INode node) {
        return false;
    }

    public String toString() {
        return ":" + this.pseudoClass + (!this.arguments.isEmpty() ? "(" + this.arguments + ")" : "");
    }

    public String getPseudoClass() {
        return this.pseudoClass;
    }

    private static class AlwaysNotApplySelectorItem
    extends CssPseudoClassSelectorItem {
        AlwaysNotApplySelectorItem(String pseudoClass, String arguments) {
            super(pseudoClass, arguments);
        }

        @Override
        public boolean matches(INode node) {
            return false;
        }
    }

    private static class AlwaysApplySelectorItem
    extends CssPseudoClassSelectorItem {
        AlwaysApplySelectorItem(String pseudoClass, String arguments) {
            super(pseudoClass, arguments);
        }

        @Override
        public boolean matches(INode node) {
            return true;
        }
    }
}

