/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.pipeline.html;

import com.itextpdf.text.Element;
import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.NoTagProcessorException;
import com.itextpdf.tool.xml.html.TagProcessor;
import com.itextpdf.tool.xml.pipeline.AbstractPipeline;
import com.itextpdf.tool.xml.pipeline.WritableElement;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.pipeline.html.NoStackException;
import com.itextpdf.tool.xml.pipeline.html.StackKeeper;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlPipeline
extends AbstractPipeline<HtmlPipelineContext> {
    private final HtmlPipelineContext hpc;

    public HtmlPipeline(HtmlPipelineContext hpc, Pipeline<?> next) {
        super(next);
        this.hpc = hpc;
    }

    @Override
    public Pipeline<?> init(WorkerContext context) throws PipelineException {
        try {
            HtmlPipelineContext clone = this.hpc.clone();
            context.put(this.getContextKey(), clone);
        }
        catch (CloneNotSupportedException e) {
            String message = String.format(LocaleMessages.getInstance().getMessage("unsupported.clone"), this.hpc.getClass().toString());
            throw new PipelineException(message, e);
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> open(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        block8: {
            HtmlPipelineContext hcc = (HtmlPipelineContext)this.getLocalContext(context);
            try {
                t.setLastMarginBottom(hcc.getMemory().get("lastMarginBottom"));
                hcc.getMemory().remove("lastMarginBottom");
                TagProcessor tp = hcc.resolveProcessor(t.getName(), t.getNameSpace());
                this.addStackKeeper(t, hcc, tp);
                List<Element> content = tp.startElement(context, t);
                if (content.size() > 0) {
                    if (tp.isStackOwner()) {
                        StackKeeper peek = hcc.peek();
                        if (peek == null) {
                            throw new PipelineException(String.format("pipeline.html.missingstack", t.toString()));
                        }
                        for (Element elem : content) {
                            peek.add(elem);
                        }
                    } else {
                        for (Element elem : content) {
                            hcc.currentContent().add(elem);
                            if (elem.type() != 38) continue;
                            WritableElement writableElement = new WritableElement();
                            writableElement.add(elem);
                            po.add(writableElement);
                            hcc.currentContent().remove(elem);
                        }
                    }
                }
            }
            catch (NoTagProcessorException e) {
                if (hcc.acceptUnknown()) break block8;
                throw e;
            }
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> content(WorkerContext context, Tag t, String text, ProcessObject po) throws PipelineException {
        block7: {
            HtmlPipelineContext hcc = (HtmlPipelineContext)this.getLocalContext(context);
            try {
                TagProcessor tp = hcc.resolveProcessor(t.getName(), t.getNameSpace());
                List<Element> elems = tp.content(context, t, text);
                if (elems.size() > 0) {
                    StackKeeper peek = hcc.peek();
                    if (peek != null) {
                        for (Element e : elems) {
                            peek.add(e);
                        }
                    } else {
                        WritableElement writableElement = new WritableElement();
                        for (Element elem : elems) {
                            writableElement.add(elem);
                        }
                        po.add(writableElement);
                    }
                }
            }
            catch (NoTagProcessorException e) {
                if (hcc.acceptUnknown()) break block7;
                throw e;
            }
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> close(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        block12: {
            HtmlPipelineContext hcc = (HtmlPipelineContext)this.getLocalContext(context);
            try {
                if (t.getLastMarginBottom() != null) {
                    hcc.getMemory().put("lastMarginBottom", t.getLastMarginBottom());
                } else {
                    hcc.getMemory().remove("lastMarginBottom");
                }
                TagProcessor tp = hcc.resolveProcessor(t.getName(), t.getNameSpace());
                List<Element> elems = null;
                if (tp.isStackOwner()) {
                    StackKeeper tagStack;
                    try {
                        tagStack = hcc.poll();
                    }
                    catch (NoStackException e) {
                        throw new PipelineException(String.format(LocaleMessages.getInstance().getMessage("pipeline.html.missingstack"), t.toString()), e);
                    }
                    elems = tp.endElement(context, t, tagStack.getElements());
                } else {
                    elems = tp.endElement(context, t, hcc.currentContent());
                    hcc.currentContent().clear();
                }
                if (elems.size() > 0) {
                    StackKeeper stack = hcc.peek();
                    if (stack != null) {
                        for (Element elem : elems) {
                            stack.add(elem);
                        }
                    } else {
                        WritableElement writableElement = new WritableElement();
                        po.add(writableElement);
                        writableElement.addAll(elems);
                    }
                }
            }
            catch (NoTagProcessorException e) {
                if (hcc.acceptUnknown()) break block12;
                throw e;
            }
        }
        return this.getNext();
    }

    protected void addStackKeeper(Tag t, HtmlPipelineContext hcc, TagProcessor tp) {
        if (tp.isStackOwner()) {
            hcc.addFirst(new StackKeeper(t));
        }
    }
}

