/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.integration.extendedattributes;

import com.ithit.webdav.integration.extendedattributes.ExtendedAttribute;
import com.sun.jna.platform.mac.XAttrUtil;
import java.io.IOException;

class OSXExtendedAttribute
implements ExtendedAttribute {
    OSXExtendedAttribute() {
    }

    @Override
    public void setExtendedAttribute(String path, String attribName, String attribValue) throws IOException {
        int result = XAttrUtil.setXAttr((String)path, (String)attribName, (String)attribValue);
        if (result == -1) {
            throw new IOException(String.format("Writing attribute '%s' with value '%s' to file '%s' failed.", attribName, attribValue, path));
        }
    }

    @Override
    public String getExtendedAttribute(String path, String attribName) throws IOException {
        try {
            return XAttrUtil.getXAttr((String)path, (String)attribName);
        }
        catch (Exception e) {
            throw new IOException(String.format("Reading attribute '%s' from file '%s' failed.", attribName, path));
        }
    }

    @Override
    public void deleteExtendedAttribute(String path, String attribName) throws IOException {
        int result = XAttrUtil.removeXAttr((String)path, (String)attribName);
        if (result == -1) {
            throw new IOException(String.format("Removing attribute '%s' from file '%s' failed.", attribName, path));
        }
    }
}

