/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server;

import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.MethodHandler;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.MultistatusException;
import com.ithit.webdav.server.exceptions.Response;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.HandlerFactory;
import com.ithit.webdav.server.handler.MultistatusResponseWriter;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.http.FilteredDavRequest;
import com.ithit.webdav.server.http.FilteredDavResponse;
import com.ithit.webdav.server.license.LicenseValidator;
import com.ithit.webdav.server.util.ArgumentUtil;
import com.ithit.webdav.server.util.RequestUtil;
import com.ithit.webdav.server.util.ResponseUtil;
import com.ithit.webdav.server.util.StringUtil;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public abstract class Engine {
    private final Hashtable<String, MethodHandler> a = new Hashtable();
    private static String b;

    public abstract HierarchyItem getHierarchyItem(String var1) throws ServerException;

    public abstract Logger getLogger();

    public abstract String getLicense();

    public String getResponseCharacterEncoding() {
        return "UTF-8";
    }

    public MethodHandler registerMethodHandler(String string, MethodHandler methodHandler) {
        ArgumentUtil.checkArgumentNotNull(string, "method");
        ArgumentUtil.checkArgumentNotNull(methodHandler, "handler");
        ArgumentUtil.checkArgument(string.length() > 0, "method should not be empty");
        string = string.toUpperCase();
        MethodHandler methodHandler2 = this.a.get(string);
        this.a.put(string, methodHandler);
        if (methodHandler2 != null) {
            return methodHandler2;
        }
        return HandlerFactory.createHandler(string, this, this.getLogger());
    }

    public static List<String> getClientLockTokens(DavRequest davRequest) {
        return davRequest.getClientLockTokens();
    }

    public boolean getAutoPutUnderVersionControl() {
        return false;
    }

    public boolean getCalculateContentLength() {
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(DavRequest object, DavResponse object2) throws DavException, IOException {
        ArgumentUtil.checkArgumentNotNull(object, "davRequest");
        ArgumentUtil.checkArgumentNotNull(object2, "davResponse");
        try {
            FilteredDavResponse filteredDavResponse;
            Object object3 = this.getLicense();
            LicenseValidator.checkLicense((String)object3);
            Object object4 = "IT Hit WebDAV Server v" + Engine.getVersion();
            if (((String)object3).contains("Evaluation")) {
                object4 = (String)object4 + " (Evaluation License)";
            }
            ((DavResponse)object2).addHeader("X-Engine", (String)object4);
            object3 = object2;
            object2 = object;
            object = this;
            object4 = ((DavRequest)object2).getMethod().toUpperCase();
            MethodHandler methodHandler = ((Engine)object).a.get(object4);
            if (methodHandler == null) {
                methodHandler = HandlerFactory.createHandler((String)object4, (Engine)object, ((Engine)object).getLogger());
            }
            object4 = new FilteredDavRequest((DavRequest)object2, ((Engine)object).getLogger().isDebugEnabled() && methodHandler != null && methodHandler.getLogInput());
            FilteredDavResponse filteredDavResponse2 = filteredDavResponse = new FilteredDavResponse((DavResponse)object3, ((Engine)object).getCalculateContentLength(), ((Engine)object).getLogger().isDebugEnabled() && methodHandler != null && methodHandler.getLogOutput());
            Object object5 = object2;
            object5 = ((DavRequest)object5).getHeader("Origin");
            ((DavResponse)filteredDavResponse2).addHeader("Access-Control-Allow-Origin", StringUtil.isNullOrEmpty((String)object5) ? "*" : StringUtil.trimEnd((String)object5, "/"));
            ((DavResponse)filteredDavResponse2).addHeader("Access-Control-Allow-Credentials", "true");
            ((DavResponse)filteredDavResponse2).addHeader("Access-Control-Allow-Methods", "PROPFIND, PROPPATCH, COPY, MOVE, DELETE, MKCOL, LOCK, UNLOCK, PUT, GETLIB, VERSION-CONTROL, CHECKIN, CHECKOUT, UNCHECKOUT, REPORT, UPDATE, CANCELUPLOAD, HEAD, OPTIONS, GET, POST");
            ((DavResponse)filteredDavResponse2).addHeader("Access-Control-Allow-Headers", "Overwrite, Destination, Content-Type, Depth, User-Agent, Translate, Range, Content-Range, Timeout, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control, Location, Lock-Token, If");
            ((DavResponse)filteredDavResponse2).addHeader("Access-Control-Expose-Headers", "DAV, content-length, Allow");
            ((DavResponse)filteredDavResponse2).addHeader("Access-Control-Max-Age", Integer.toString(Integer.MAX_VALUE));
            try {
                if (methodHandler == null) {
                    throw new ServerException(WebDavStatus.METHOD_NOT_ALLOWED);
                }
                if (!methodHandler.getCalculateContentLength()) {
                    filteredDavResponse.setCalcContentLength(false);
                }
                object2 = ((Engine)object).getHierarchyItem(RequestUtil.getRequestPathAndQueryString((DavRequest)object2));
                methodHandler.processRequest((DavRequest)object4, filteredDavResponse, (HierarchyItem)object2);
            }
            catch (MultistatusException multistatusException) {
                try {
                    filteredDavResponse.setStatus(multistatusException.getStatus().getCode(), multistatusException.getStatus().getDescription());
                    super.a((DavRequest)object4, filteredDavResponse, multistatusException);
                    throw multistatusException;
                    catch (DavException davException) {
                        filteredDavResponse.setStatus(davException.getStatus().getCode(), davException.getStatus().getDescription());
                        if (!super.a((DavResponse)object3, davException) && ((Engine)object).getCalculateContentLength()) {
                            ((DavResponse)object3).setContentLength(0L);
                        }
                        if (!(davException instanceof ServerException)) throw davException;
                        if (davException.getCause() == null) throw davException;
                        if (davException.getStatus() != WebDavStatus.INTERNAL_ERROR) throw davException;
                        ((Engine)object).getLogger().logError(davException.getMessage(), davException);
                        throw davException;
                    }
                }
                catch (Throwable throwable) {
                    filteredDavResponse.finish();
                    if (!((Engine)object).getLogger().isDebugEnabled()) throw throwable;
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("\n");
                    ((StringBuilder)object3).append(((FilteredDavRequest)object4).toString());
                    ((StringBuilder)object3).append("\n\n");
                    ((StringBuilder)object3).append(filteredDavResponse.toString());
                    ((Engine)object).getLogger().logDebug(((StringBuilder)object3).toString());
                    throw throwable;
                }
            }
            filteredDavResponse.finish();
            if (!((Engine)object).getLogger().isDebugEnabled()) return;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("\n");
            ((StringBuilder)object2).append(((FilteredDavRequest)object4).toString());
            ((StringBuilder)object2).append("\n\n");
            ((StringBuilder)object2).append(filteredDavResponse.toString());
            ((Engine)object).getLogger().logDebug(((StringBuilder)object2).toString());
            return;
        }
        catch (IOException iOException) {
            this.getLogger().logError(iOException.getMessage(), iOException);
            throw iOException;
        }
    }

    public static String getVersion() {
        if (b == null || b.equals("")) {
            b = "3.2.2420";
        }
        return b;
    }

    private void a(DavRequest object, DavResponse responseArray, MultistatusException multistatusException) throws ServerException, IOException {
        object = new MultistatusResponseWriter((DavRequest)object, (DavResponse)responseArray, this.getResponseCharacterEncoding());
        try {
            ((MultistatusResponseWriter)object).startMultiStatusResponse();
            for (Response response : multistatusException.getResponses()) {
                ((MultistatusResponseWriter)object).addStatusResponse(response);
            }
            ((MultistatusResponseWriter)object).endMultiStatusResponse();
            return;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ServerException(xMLStreamException);
        }
    }

    private boolean a(DavResponse object, DavException davException) throws IOException {
        try {
            if (!StringUtil.isNullOrEmpty(davException.getLocalName()) || !StringUtil.isNullOrEmpty(davException.getMessage())) {
                object = ResponseUtil.createXmlResponse((DavResponse)object, this.getResponseCharacterEncoding());
                object.writeStartDocument();
                String string = "DAV:";
                object.writeStartElement("d", "error", string);
                object.writeNamespace("d", string);
                if (!StringUtil.isNullOrEmpty(davException.getLocalName())) {
                    if (string.equals(davException.getNamespace())) {
                        object.writeEmptyElement("d", davException.getLocalName(), string);
                    } else {
                        object.writeNamespace("m", davException.getNamespace());
                        object.writeEmptyElement("m", davException.getLocalName(), davException.getNamespace());
                    }
                }
                if (!StringUtil.isNullOrEmpty(davException.getMessage())) {
                    object.writeStartElement("d", "responsedescription", string);
                    object.writeCharacters(davException.getMessage());
                    object.writeEndElement();
                }
                object.writeEndElement();
                object.writeEndDocument();
                object.flush();
                return true;
            }
        }
        catch (XMLStreamException xMLStreamException) {
            this.getLogger().logError("", xMLStreamException);
        }
        return false;
    }
}

