/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server;

import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.MethodHandler;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.MultistatusException;
import com.ithit.webdav.server.exceptions.Response;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.HandlerFactory;
import com.ithit.webdav.server.handler.MultistatusResponseWriter;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.http.FilteredDavRequest;
import com.ithit.webdav.server.http.FilteredDavResponse;
import com.ithit.webdav.server.license.LicenseValidator;
import com.ithit.webdav.server.util.ArgumentUtil;
import com.ithit.webdav.server.util.RequestUtil;
import com.ithit.webdav.server.util.ResponseUtil;
import com.ithit.webdav.server.util.StringUtil;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public abstract class Engine {
    private final Hashtable<String, MethodHandler> a = new Hashtable();
    private static String b;

    public abstract HierarchyItem getHierarchyItem(String var1) throws ServerException;

    public abstract Logger getLogger();

    public abstract String getLicense();

    public String getResponseCharacterEncoding() {
        return "UTF-8";
    }

    public MethodHandler registerMethodHandler(String string, MethodHandler methodHandler) {
        ArgumentUtil.checkArgumentNotNull(string, "method");
        ArgumentUtil.checkArgumentNotNull(methodHandler, "handler");
        ArgumentUtil.checkArgument(string.length() > 0, "method should not be empty");
        string = string.toUpperCase();
        MethodHandler methodHandler2 = this.a.get(string);
        this.a.put(string, methodHandler);
        if (methodHandler2 != null) {
            return methodHandler2;
        }
        return HandlerFactory.createHandler(string, this, this.getLogger());
    }

    public static List<String> getClientLockTokens(DavRequest davRequest) {
        return davRequest.getClientLockTokens();
    }

    public boolean getAutoPutUnderVersionControl() {
        return false;
    }

    public boolean getCalculateContentLength() {
        return true;
    }

    /*
     * Loose catch block
     */
    public void service(DavRequest object, DavResponse object2) throws DavException, IOException {
        block17: {
            ArgumentUtil.checkArgumentNotNull(object, "davRequest");
            ArgumentUtil.checkArgumentNotNull(object2, "davResponse");
            try {
                block16: {
                    Object object3 = this.getLicense();
                    LicenseValidator.checkLicense((String)object3);
                    Object object4 = "IT Hit WebDAV Server v" + Engine.getVersion();
                    if (((String)object3).contains("Evaluation")) {
                        object4 = (String)object4 + " (Evaluation License)";
                    }
                    ((DavResponse)object2).addHeader("X-Engine", (String)object4);
                    object3 = object2;
                    object2 = object;
                    object = this;
                    object4 = ((DavRequest)object2).getMethod().toUpperCase();
                    MethodHandler methodHandler = ((Engine)object).a.get(object4);
                    if (methodHandler == null) {
                        methodHandler = HandlerFactory.createHandler((String)object4, (Engine)object, ((Engine)object).getLogger());
                    }
                    object4 = new FilteredDavRequest((DavRequest)object2, ((Engine)object).getLogger().isDebugEnabled() && methodHandler != null && methodHandler.getLogInput());
                    FilteredDavResponse filteredDavResponse = new FilteredDavResponse((DavResponse)object3, ((Engine)object).getCalculateContentLength(), ((Engine)object).getLogger().isDebugEnabled() && methodHandler != null && methodHandler.getLogOutput());
                    Object object5 = filteredDavResponse;
                    Object object6 = object2;
                    object6 = ((DavRequest)object6).getHeader("Origin");
                    ((DavResponse)object5).addHeader("Access-Control-Allow-Origin", StringUtil.isNullOrEmpty((String)object6) ? "*" : StringUtil.trimEnd((String)object6, "/"));
                    ((DavResponse)object5).addHeader("Access-Control-Allow-Credentials", "true");
                    ((DavResponse)object5).addHeader("Access-Control-Allow-Methods", "PROPFIND, PROPPATCH, COPY, MOVE, DELETE, MKCOL, LOCK, UNLOCK, PUT, GETLIB, VERSION-CONTROL, CHECKIN, CHECKOUT, UNCHECKOUT, REPORT, UPDATE, CANCELUPLOAD, HEAD, OPTIONS, GET, POST");
                    ((DavResponse)object5).addHeader("Access-Control-Allow-Headers", "Overwrite, Destination, Content-Type, Depth, User-Agent, Translate, Range, Content-Range, Timeout, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control, Location, Lock-Token, If");
                    ((DavResponse)object5).addHeader("Access-Control-Expose-Headers", "DAV, content-length, Allow");
                    ((DavResponse)object5).addHeader("Access-Control-Max-Age", Integer.toString(Integer.MAX_VALUE));
                    try {
                        if (methodHandler == null) {
                            throw new ServerException(WebDavStatus.METHOD_NOT_ALLOWED);
                        }
                        if (!methodHandler.getCalculateContentLength()) {
                            filteredDavResponse.setCalcContentLength(false);
                        }
                        object5 = ((Engine)object).getHierarchyItem(RequestUtil.getRequestPathAndQueryString((DavRequest)object2));
                        methodHandler.processRequest((DavRequest)object4, filteredDavResponse, (HierarchyItem)object5);
                        filteredDavResponse.finish();
                        if (!((Engine)object).getLogger().isDebugEnabled()) break block16;
                        object5 = new StringBuilder();
                        ((StringBuilder)object5).append("\n");
                    }
                    catch (MultistatusException multistatusException) {
                        filteredDavResponse.setStatus(multistatusException.getStatus().getCode(), multistatusException.getStatus().getDescription());
                        super.a((DavRequest)object4, filteredDavResponse, multistatusException);
                        break block17;
                    }
                    catch (DavException davException) {
                        filteredDavResponse.setStatus(davException.getStatus().getCode(), davException.getStatus().getDescription());
                        if (!super.a((DavResponse)object3, davException) && ((Engine)object).getCalculateContentLength()) {
                            ((DavResponse)object3).setContentLength(0L);
                        }
                        if (davException instanceof ServerException && davException.getCause() != null && davException.getStatus() == WebDavStatus.INTERNAL_ERROR) {
                            object6 = object2;
                            if (!((String)(object2 = ((DavRequest)object6).getMethod())).equalsIgnoreCase("HEAD") && !((String)object2).equalsIgnoreCase("OPTIONS")) {
                                object2 = davException.getMessage().getBytes(((Engine)object).getResponseCharacterEncoding());
                                filteredDavResponse.geFilteredDavOutputStream().write((byte[])object2, 0, ((Object)object2).length);
                            }
                            ((Engine)object).getLogger().logError(davException.getMessage(), davException);
                            throw davException;
                        }
                        break block17;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        filteredDavResponse.finish();
                        if (!((Engine)object).getLogger().isDebugEnabled()) break block16;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("\n");
                        stringBuilder.append(((FilteredDavRequest)object4).toString());
                        stringBuilder.append("\n\n");
                        stringBuilder.append(filteredDavResponse.toString());
                        ((Engine)object).getLogger().logDebug(stringBuilder.toString());
                    }
                    ((StringBuilder)object5).append(((FilteredDavRequest)object4).toString());
                    ((StringBuilder)object5).append("\n\n");
                    ((StringBuilder)object5).append(filteredDavResponse.toString());
                    ((Engine)object).getLogger().logDebug(((StringBuilder)object5).toString());
                    break block17;
                }
                return;
            }
            catch (IOException iOException) {
                this.getLogger().logError(iOException.getMessage(), iOException);
                throw iOException;
            }
        }
    }

    public static String getVersion() {
        if (b == null || b.equals("")) {
            b = "4.2.2810";
        }
        return b;
    }

    private void a(DavRequest object, DavResponse responseArray, MultistatusException multistatusException) throws ServerException, IOException {
        object = new MultistatusResponseWriter((DavRequest)object, (DavResponse)responseArray, this.getResponseCharacterEncoding());
        try {
            ((MultistatusResponseWriter)object).startMultiStatusResponse();
            for (Response response : multistatusException.getResponses()) {
                ((MultistatusResponseWriter)object).addStatusResponse(response);
            }
            ((MultistatusResponseWriter)object).endMultiStatusResponse();
            return;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ServerException(xMLStreamException);
        }
    }

    private boolean a(DavResponse object, DavException davException) throws IOException {
        try {
            if (!StringUtil.isNullOrEmpty(davException.getLocalName()) || !StringUtil.isNullOrEmpty(davException.getMessage())) {
                object = ResponseUtil.createXmlResponse((DavResponse)object, this.getResponseCharacterEncoding());
                object.writeStartDocument();
                String string = "DAV:";
                object.writeStartElement("d", "error", string);
                object.writeNamespace("d", string);
                if (!StringUtil.isNullOrEmpty(davException.getLocalName())) {
                    if (string.equals(davException.getNamespace())) {
                        object.writeEmptyElement("d", davException.getLocalName(), string);
                    } else {
                        object.writeNamespace("m", davException.getNamespace());
                        object.writeEmptyElement("m", davException.getLocalName(), davException.getNamespace());
                    }
                }
                if (!StringUtil.isNullOrEmpty(davException.getMessage())) {
                    object.writeStartElement("d", "responsedescription", string);
                    object.writeCharacters(davException.getMessage());
                    object.writeEndElement();
                }
                object.writeEndElement();
                object.writeEndDocument();
                object.flush();
                return true;
            }
        }
        catch (XMLStreamException xMLStreamException) {
            this.getLogger().logError("", xMLStreamException);
        }
        return false;
    }
}

