/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.File;
import com.ithit.webdav.server.Folder;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.LockInfo;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.MethodHandler;
import com.ithit.webdav.server.Property;
import com.ithit.webdav.server.deltav.AutoVersion;
import com.ithit.webdav.server.deltav.DeltaVItem;
import com.ithit.webdav.server.deltav.Version;
import com.ithit.webdav.server.deltav.VersionableItem;
import com.ithit.webdav.server.exceptions.ConflictException;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.LockedException;
import com.ithit.webdav.server.exceptions.MultistatusException;
import com.ithit.webdav.server.exceptions.MultistatusResponse;
import com.ithit.webdav.server.exceptions.PreconditionFailedException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.IfHelper;
import com.ithit.webdav.server.handler.MultistatusResponseWriter;
import com.ithit.webdav.server.handler.h;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.quota.Quota;
import com.ithit.webdav.server.util.RequestUtil;
import com.ithit.webdav.server.util.StringUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

abstract class a
implements MethodHandler {
    DavRequest a;
    DavResponse b;
    final Engine c;
    final Logger d;
    private static final String[] e = new String[]{"creationdate", "displayname", "getcontentlength", "getcontenttype", "getlastmodified", "resourcetype", "supportedlock", "lockdiscovery", "checkout-set", "predecessor-set", "successor-set", "version-name", "getetag"};

    protected a(Engine engine, Logger logger) {
        this.c = engine;
        this.d = logger;
    }

    @Override
    public void processRequest(DavRequest davRequest, DavResponse davResponse, HierarchyItem hierarchyItem) throws DavException, IOException {
        this.a = davRequest;
        this.b = davResponse;
    }

    protected final String a() {
        return this.a.getHeader("Depth");
    }

    protected final String b() throws ServerException {
        try {
            URI uRI = new URI(this.a.getHeader("Destination"));
            return RequestUtil.stripContextPath(uRI.getRawPath(), this.a);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ServerException("Invalid destination Uri", uRISyntaxException);
        }
    }

    protected final boolean a(HierarchyItem hierarchyItem) {
        if (hierarchyItem == null) {
            this.a(WebDavStatus.NOT_FOUND);
            return false;
        }
        return true;
    }

    protected static void a(Folder folder) throws ConflictException {
        if (folder == null) {
            throw new ConflictException();
        }
    }

    protected final void a(WebDavStatus webDavStatus) {
        this.b.setStatus(webDavStatus.getCode(), webDavStatus.getDescription());
    }

    protected static Property a(String string, String string2) {
        return new Property(string, string2, null);
    }

    protected final void b(String string, String string2) {
        this.b.addHeader(string, string2);
    }

    protected final Folder a(String object) throws DavException {
        object = StringUtil.trimEnd((String)object, "/");
        int n2 = ((String)object).lastIndexOf(47);
        object = ((String)object).substring(0, n2 + 1);
        if ((object = this.c.getHierarchyItem((String)object)) instanceof Folder) {
            return (Folder)object;
        }
        return null;
    }

    protected static String b(String string) throws ServerException {
        string = StringUtil.trimEnd(string, "/");
        int n2 = string.lastIndexOf(47);
        try {
            return URLDecoder.decode(string.substring(n2 + 1).replaceAll("\\+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ServerException(unsupportedEncodingException);
        }
    }

    public final boolean a(MultistatusResponseWriter multistatusResponseWriter, HierarchyItem object) throws XMLStreamException, ServerException {
        long l2 = object.getModified();
        if (l2 != Long.MIN_VALUE) {
            object = com.ithit.webdav.server.handler.a.a(l2);
            multistatusResponseWriter.writeProperty("getlastmodified", "DAV:", (String)object);
            return true;
        }
        return false;
    }

    protected static String a(long l2) {
        Object object = "EEE, dd MMM yyyy HH:mm:ss zzz";
        object = new SimpleDateFormat((String)object, Locale.ENGLISH);
        ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("GMT"));
        return ((DateFormat)object).format(new Date(l2));
    }

    public static boolean b(MultistatusResponseWriter multistatusResponseWriter, HierarchyItem hierarchyItem) throws XMLStreamException, ServerException {
        if (hierarchyItem instanceof File) {
            hierarchyItem = (File)hierarchyItem;
            multistatusResponseWriter.writeProperty("getcontentlength", "DAV:", Long.toString(hierarchyItem.getContentLength()));
            return true;
        }
        return false;
    }

    public static boolean c(MultistatusResponseWriter multistatusResponseWriter, HierarchyItem hierarchyItem) throws XMLStreamException, ServerException {
        if (hierarchyItem instanceof File) {
            if ((hierarchyItem = (File)hierarchyItem).getEtag() != null) {
                multistatusResponseWriter.writeProperty("getetag", "DAV:", String.format("\"%s\"", hierarchyItem.getEtag()));
            }
            return true;
        }
        return false;
    }

    protected final Document c() throws IOException, ServerException {
        Object object;
        Object object2;
        Object object3 = DocumentBuilderFactory.newInstance();
        try {
            object2 = "http://apache.org/xml/features/disallow-doctype-decl";
            ((DocumentBuilderFactory)object3).setFeature((String)object2, true);
        }
        catch (Exception exception) {
            object = this;
            ((a)object).d.logError("Cannot configure XXE defense", exception);
        }
        ((DocumentBuilderFactory)object3).setNamespaceAware(true);
        try {
            object2 = ((DocumentBuilderFactory)object3).newDocumentBuilder();
            object3 = new StringBuilder();
            object = this;
            Object object4 = ((a)object).a.getCharacterEncoding();
            object = this;
            object4 = new InputStreamReader(((a)object).a.getInputStream(), (String)(object4 == null ? "UTF-8" : object4));
            try {
                int n2;
                object = new char[1000];
                while ((n2 = ((InputStreamReader)object4).read((char[])object, 0, 1000)) > 0) {
                    ((StringBuilder)object3).append((char[])object, 0, n2);
                }
            }
            finally {
                ((InputStreamReader)object4).close();
            }
            object = ((StringBuilder)object3).toString();
            if (((String)object).length() == 0) {
                return null;
            }
            return ((DocumentBuilder)object2).parse(new InputSource(new StringReader((String)object)));
        }
        catch (SAXException sAXException) {
            throw new ServerException(sAXException, WebDavStatus.BAD_REQUEST);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ServerException(parserConfigurationException);
        }
    }

    protected static Node a(Document document, String object) throws ServerException {
        try {
            Object object2 = XPathFactory.newInstance();
            object2 = ((XPathFactory)object2).newXPath();
            object2.setNamespaceContext(new h());
            object = object2.compile((String)object);
            return (Node)object.evaluate(document, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new ServerException(xPathExpressionException);
        }
    }

    protected static NodeList b(Document document, String object) throws ServerException {
        try {
            Object object2 = XPathFactory.newInstance();
            object2 = ((XPathFactory)object2).newXPath();
            object2.setNamespaceContext(new h());
            object = object2.compile((String)object);
            return (NodeList)object.evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new ServerException(xPathExpressionException);
        }
    }

    protected static void a(XMLStreamWriter xMLStreamWriter, LockInfo lockInfo) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("DAV:", "activelock");
        xMLStreamWriter.writeStartElement("DAV:", "lockscope");
        xMLStreamWriter.writeEmptyElement("DAV:", lockInfo.isShared() ? "shared" : "exclusive");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("DAV:", "locktype");
        xMLStreamWriter.writeEmptyElement("DAV:", "write");
        xMLStreamWriter.writeEndElement();
        MultistatusResponse.writeElementString(xMLStreamWriter, "depth", "DAV:", lockInfo.isDeep() ? "infinity" : "0");
        MultistatusResponse.writeElementString(xMLStreamWriter, "owner", "DAV:", lockInfo.getOwner());
        xMLStreamWriter.writeStartElement("DAV:", "timeout");
        if (lockInfo.getTimeout() == -1L) {
            xMLStreamWriter.writeCharacters("Infinite");
        } else {
            xMLStreamWriter.writeCharacters("Second-" + lockInfo.getTimeout());
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("DAV:", "locktoken");
        MultistatusResponse.writeElementString(xMLStreamWriter, "href", "DAV:", "opaquelocktoken:" + lockInfo.getToken());
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    @Override
    public boolean getLogInput() {
        return true;
    }

    @Override
    public boolean getLogOutput() {
        return true;
    }

    @Override
    public boolean getCalculateContentLength() {
        return true;
    }

    protected final void d() throws DavException {
        a a2 = this;
        if (!"T".equals(a2.a.getHeader("Overwrite"))) {
            throw new PreconditionFailedException("Overwrite required");
        }
    }

    protected static boolean[] a(List<Property> list) {
        boolean bl = false;
        boolean[] blArray = new boolean[list.size()];
        block0: for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!"DAV:".equals(list.get(i2).getNamespace())) continue;
            String[] stringArray = e;
            for (int i3 = 0; i3 < 13; ++i3) {
                String string = stringArray[i3];
                if (list.get(i2).getName().equals(string)) {
                    blArray[i2] = true;
                    bl = true;
                    continue block0;
                }
                blArray[i2] = false;
            }
        }
        if (bl) {
            return blArray;
        }
        return null;
    }

    protected static void a(String string, List<Property> list, List<Property> list2, boolean[] blArray, boolean[] blArray2) throws MultistatusException {
        int n2;
        MultistatusException multistatusException = new MultistatusException();
        for (n2 = 0; n2 < list.size(); ++n2) {
            if (blArray != null && blArray[n2]) {
                multistatusException.addResponse(string, list.get(n2), WebDavStatus.CONFLICT);
                continue;
            }
            multistatusException.addResponse(string, list.get(n2), WebDavStatus.FAILED_DEPENDENCY);
        }
        for (n2 = 0; n2 < list2.size(); ++n2) {
            if (blArray2 != null && blArray2[n2]) {
                multistatusException.addResponse(string, list2.get(n2), WebDavStatus.CONFLICT);
                continue;
            }
            multistatusException.addResponse(string, list2.get(n2), WebDavStatus.FAILED_DEPENDENCY);
        }
        throw multistatusException;
    }

    protected static List<Property> a(HierarchyItem hierarchyItem, List<Property> list) throws ServerException, MultistatusException, LockedException {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        if ((hierarchyItem = hierarchyItem instanceof DeltaVItem ? (DeltaVItem)hierarchyItem : null) == null) {
            return arrayList;
        }
        for (Property property : list) {
            if (!property.getNamespace().equals("DAV:")) continue;
            if (property.getName().equals("comment")) {
                hierarchyItem.setComment(property.getValue());
                arrayList.add(property);
                continue;
            }
            if (property.getName().equals("creator-displayname")) {
                hierarchyItem.setCreatorDisplayName(property.getValue());
                arrayList.add(property);
                continue;
            }
            if (!property.getName().equals("auto-version")) continue;
            VersionableItem versionableItem = hierarchyItem instanceof VersionableItem ? (VersionableItem)hierarchyItem : null;
            if (versionableItem != null) {
                if (property.getValue().equals("checkout-checkin")) {
                    versionableItem.setAutoVersion(AutoVersion.CheckOutCheckIn);
                } else if (property.getValue().equals("checkout-unlocked-checkin")) {
                    versionableItem.setAutoVersion(AutoVersion.CheckOutUnlockedCheckIn);
                } else if (property.getValue().equals("checkout")) {
                    versionableItem.setAutoVersion(AutoVersion.CheckOut);
                } else if (property.getValue().equals("locked-checkout")) {
                    versionableItem.setAutoVersion(AutoVersion.LockedCheckOut);
                } else if (property.getValue().equals("")) {
                    versionableItem.setAutoVersion(AutoVersion.NoAutoVersioning);
                } else {
                    throw new ServerException(WebDavStatus.NOT_IMPLEMENTED);
                }
            }
            arrayList.add(property);
        }
        for (Property property : arrayList) {
            list.remove(property);
        }
        return arrayList;
    }

    protected static boolean d(MultistatusResponseWriter multistatusResponseWriter, HierarchyItem object) throws ServerException, XMLStreamException {
        long l2 = object.getCreated();
        if (l2 == Long.MIN_VALUE) {
            return false;
        }
        object = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        object = new SimpleDateFormat((String)object);
        ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("GMT"));
        multistatusResponseWriter.writeProperty("creationdate", "DAV:", ((DateFormat)object).format(new Date(l2)));
        return true;
    }

    protected static boolean e(MultistatusResponseWriter multistatusResponseWriter, HierarchyItem object) throws XMLStreamException, ServerException {
        if (object instanceof File) {
            multistatusResponseWriter.writeProperty("getcontenttype", "DAV:", (String)((object = ((File)object).getContentType()) == null ? "" : object));
            return true;
        }
        return false;
    }

    protected static boolean f(MultistatusResponseWriter multistatusResponseWriter, HierarchyItem object) throws ServerException, XMLStreamException {
        if ((object = object instanceof DeltaVItem ? (DeltaVItem)object : null) == null) {
            return false;
        }
        if ((object = object.getCreatorDisplayName()) != null) {
            multistatusResponseWriter.writeProperty("creator-displayname", "DAV:", (String)object);
            return true;
        }
        return false;
    }

    protected static boolean g(MultistatusResponseWriter multistatusResponseWriter, HierarchyItem hierarchyItem) throws XMLStreamException, ServerException {
        if ((hierarchyItem = hierarchyItem instanceof DeltaVItem ? (DeltaVItem)hierarchyItem : null) == null) {
            return false;
        }
        multistatusResponseWriter.writeProperty("comment", "DAV:", hierarchyItem.getComment());
        return true;
    }

    protected final boolean h(MultistatusResponseWriter multistatusResponseWriter, HierarchyItem hierarchyItem) throws ServerException, XMLStreamException {
        Object object = hierarchyItem instanceof Version ? (Version)hierarchyItem : null;
        if (object != null) {
            hierarchyItem = object;
            object = multistatusResponseWriter.startProperty("DAV:", "predecessor-set");
            do {
                if ((hierarchyItem = hierarchyItem.getPredecessor()) == null) continue;
                multistatusResponseWriter.writeItemHref((XMLStreamWriter)object, IfHelper.getPath(hierarchyItem));
            } while (hierarchyItem != null);
            multistatusResponseWriter.endProperty();
            return true;
        }
        if ((hierarchyItem = hierarchyItem instanceof VersionableItem ? (VersionableItem)hierarchyItem : null) == null || !hierarchyItem.isCheckedOut()) {
            return false;
        }
        object = multistatusResponseWriter.startProperty("DAV:", "predecessor-set");
        for (hierarchyItem = IfHelper.getCurrenVersion(hierarchyItem.getVersionHistory()); hierarchyItem != null; hierarchyItem = hierarchyItem.getPredecessor()) {
            multistatusResponseWriter.writeItemHref((XMLStreamWriter)object, IfHelper.getPath(hierarchyItem));
        }
        multistatusResponseWriter.endProperty();
        return true;
    }

    protected final boolean i(MultistatusResponseWriter multistatusResponseWriter, HierarchyItem hierarchyItem) throws ServerException, XMLStreamException {
        if ((hierarchyItem = hierarchyItem instanceof Version ? (Version)hierarchyItem : null) != null) {
            com.ithit.webdav.server.handler.a.a(multistatusResponseWriter, (Version)hierarchyItem);
            return true;
        }
        return false;
    }

    protected static void a(MultistatusResponseWriter multistatusResponseWriter, Version version) throws ServerException, XMLStreamException {
        XMLStreamWriter xMLStreamWriter = multistatusResponseWriter.startProperty("DAV:", "successor-set");
        do {
            if ((version = version.getSuccessor()) == null) continue;
            multistatusResponseWriter.writeItemHref(xMLStreamWriter, IfHelper.getPath(version));
        } while (version != null);
        multistatusResponseWriter.endProperty();
    }

    protected final boolean j(MultistatusResponseWriter multistatusResponseWriter, HierarchyItem hierarchyItem) throws ServerException, XMLStreamException {
        if ((hierarchyItem = hierarchyItem instanceof Version ? (Version)hierarchyItem : null) != null) {
            com.ithit.webdav.server.handler.a.b(multistatusResponseWriter, (Version)hierarchyItem);
            return true;
        }
        return false;
    }

    protected static void b(MultistatusResponseWriter multistatusResponseWriter, Version version) throws ServerException, XMLStreamException {
        VersionableItem versionableItem;
        XMLStreamWriter xMLStreamWriter = multistatusResponseWriter.startProperty("DAV:", "checkout-set");
        if (version != null && (versionableItem = IfHelper.getVersionableItem(version)).isCheckedOut() && version.getSuccessor() == null) {
            multistatusResponseWriter.writeItemHref(xMLStreamWriter, IfHelper.getPath(versionableItem));
        }
        multistatusResponseWriter.endProperty();
    }

    protected final boolean k(MultistatusResponseWriter multistatusResponseWriter, HierarchyItem hierarchyItem) throws ServerException, XMLStreamException {
        if ((hierarchyItem = hierarchyItem instanceof Version ? (Version)hierarchyItem : null) != null) {
            com.ithit.webdav.server.handler.a.c(multistatusResponseWriter, (Version)hierarchyItem);
            return true;
        }
        return false;
    }

    protected static void c(MultistatusResponseWriter multistatusResponseWriter, Version version) throws XMLStreamException, ServerException {
        multistatusResponseWriter.writeProperty("version-name", "DAV:", IfHelper.getVersionName(version));
    }

    final boolean l(MultistatusResponseWriter multistatusResponseWriter, HierarchyItem object) throws ServerException, XMLStreamException {
        if ((object = object instanceof Quota ? (Quota)object : null) != null) {
            long l2 = 0L;
            try {
                l2 = object.getAvailableBytes();
            }
            catch (Exception exception) {}
            long l3 = l2;
            multistatusResponseWriter.writeProperty("quota-available-bytes", "DAV:", String.valueOf(l3));
            return true;
        }
        return false;
    }

    final boolean m(MultistatusResponseWriter multistatusResponseWriter, HierarchyItem object) throws ServerException, XMLStreamException {
        if ((object = object instanceof Quota ? (Quota)object : null) != null) {
            long l2 = 0L;
            try {
                l2 = object.getUsedBytes();
            }
            catch (Exception exception) {}
            long l3 = l2;
            multistatusResponseWriter.writeProperty("quota-used-bytes", "DAV:", String.valueOf(l3));
            return true;
        }
        return false;
    }

    protected static boolean a(HierarchyItem hierarchyItem, String stringArray) throws ServerException {
        stringArray = stringArray.trim();
        if ((hierarchyItem = (File)hierarchyItem) == null) {
            return false;
        }
        if ("*".equals(stringArray) && StringUtil.isNullOrEmpty(hierarchyItem.getEtag())) {
            return false;
        }
        for (String string : stringArray.split(",")) {
            if (!(string = StringUtil.trimStart(StringUtil.trimEnd(string.trim(), "\""), "\"")).equals(hierarchyItem.getEtag())) continue;
            return true;
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected final boolean a(HierarchyItem var1_1, WebDavStatus var2_3) throws ServerException {
        block19: {
            block23: {
                block20: {
                    block22: {
                        block21: {
                            var3_6 = this.a.getHeader("If");
                            var4_7 = this.a.getHeader("If-Match");
                            var5_9 = this.a.getHeader("If-None-Match");
                            var6_10 = this.a.getHeader("If-Modified-Since");
                            var7_11 = this.a.getHeader("If-Unmodified-Since");
                            if (StringUtil.isNullOrEmpty((String)var3_6)) break block21;
                            var8_12 /* !! */  = var3_6;
                            var3_6 = var1_1;
                            if (!(var8_12 /* !! */  = var8_12 /* !! */ .trim()).contains("[") || !var8_12 /* !! */ .contains("]")) ** GOTO lbl-1000
                            if ((var3_6 = (File)var3_6) == null) {
                                v0 = false;
                            } else {
                                var8_12 /* !! */  = var8_12 /* !! */ .substring(var8_12 /* !! */ .lastIndexOf("[") + 1, var8_12 /* !! */ .lastIndexOf("]"));
                                if (!(var8_12 /* !! */  = StringUtil.trimEnd(StringUtil.trimStart((String)var8_12 /* !! */ , "\""), "\"")).equals(var3_6.getEtag())) {
                                    v0 = false;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v0 = true;
                                }
                            }
                            if (!v0) {
                                this.a(WebDavStatus.PRECONDITION_FAILED);
                                return false;
                            }
                        }
                        if (!StringUtil.isNullOrEmpty(var4_7) && !com.ithit.webdav.server.handler.a.a((HierarchyItem)var1_1, var4_7)) {
                            this.a(WebDavStatus.PRECONDITION_FAILED);
                            return false;
                        }
                        if (StringUtil.isNullOrEmpty(var7_11)) break block22;
                        if (var1_1 == null) {
                            return true;
                        }
                        try {
                            var2_3 = com.ithit.webdav.server.handler.a.c(var7_11);
                            var9_13 = com.ithit.webdav.server.handler.a.b((HierarchyItem)var1_1);
                            if (var9_13 > var2_3.getTime()) {
                                this.a(WebDavStatus.PRECONDITION_FAILED);
                                return false;
                            }
                            break block19;
                        }
                        catch (ParseException var2_4) {
                            var1_1 = this;
                            var1_1.d.logError("Cannot parse since modified date.", var2_4);
                        }
                        break block19;
                    }
                    if (StringUtil.isNullOrEmpty(var5_9)) break block23;
                    var8_12 /* !! */  = var5_9;
                    var3_6 = var1_1;
                    var8_12 /* !! */  = var8_12 /* !! */ .trim();
                    if ((var3_6 = (File)var3_6) == null) ** GOTO lbl52
                    if ("*".equals(var8_12 /* !! */ ) && !StringUtil.isNullOrEmpty(var3_6.getEtag())) {
                        v1 = false;
                    } else {
                        for (String var5_9 : var8_12 /* !! */ .split(",")) {
                            if (!(var5_9 = StringUtil.trimStart(StringUtil.trimEnd(var5_9.trim(), "\""), "\"")).equals(var3_6.getEtag())) continue;
                            v1 = false;
                            break block20;
                        }
lbl52:
                        // 2 sources

                        v1 = true;
                    }
                }
                if (!v1) {
                    this.a((WebDavStatus)var2_3);
                    return false;
                }
                break block19;
            }
            if (!StringUtil.isNullOrEmpty(var6_10)) {
                if (var1_1 == null) {
                    return true;
                }
                try {
                    var2_3 = com.ithit.webdav.server.handler.a.c(var6_10);
                    var9_14 = com.ithit.webdav.server.handler.a.b((HierarchyItem)var1_1);
                    if (var9_14 <= var2_3.getTime()) {
                        this.a(WebDavStatus.NOT_MODIFIED);
                        return false;
                    }
                }
                catch (ParseException var2_5) {
                    var1_1 = this;
                    var1_1.d.logError("Cannot parse since modified date.", var2_5);
                }
            }
        }
        return true;
    }

    private static Date c(String string) throws ParseException {
        Object object = "EEE, dd MMM yyyy HH:mm:ss zzz";
        object = new SimpleDateFormat((String)object, Locale.ENGLISH);
        return ((DateFormat)object).parse(string);
    }

    private static long b(HierarchyItem hierarchyItem) throws ServerException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.setTimeInMillis(hierarchyItem.getModified());
        gregorianCalendar.clear(14);
        return gregorianCalendar.getTimeInMillis();
    }
}

