/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.util;

import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.util.ArgumentUtil;
import com.ithit.webdav.server.util.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;

public class RequestUtil {
    public static String getRequestPathAndQueryString(DavRequest davRequest) {
        String string = davRequest.getRequestURI();
        if (string.startsWith("//")) {
            string = string.replaceFirst("//", "/");
        }
        if (davRequest.getQueryString() != null && davRequest.getQueryString().length() > 0) {
            string = string + "?" + davRequest.getQueryString();
        }
        return RequestUtil.stripContextPath(string, davRequest);
    }

    public static String getPathAndQueryString(String object, DavRequest davRequest) throws ServerException {
        try {
            object = new URI((String)object);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ServerException((Throwable)uRISyntaxException, WebDavStatus.BAD_REQUEST);
        }
        String string = ((URI)object).getRawPath();
        if (((URI)object).getRawQuery() != null && ((URI)object).getRawQuery().length() > 0) {
            string = string + "?" + ((URI)object).getRawQuery();
        }
        return RequestUtil.stripContextPath(string, davRequest);
    }

    public static String getRequestPath(DavRequest davRequest) {
        return RequestUtil.stripContextPath(davRequest.getRequestURI(), davRequest);
    }

    public static String createUrl(String string, DavRequest davRequest) {
        String string2 = StringUtil.trimEnd(davRequest.getContextPath() + davRequest.getServerPath(), "/");
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = ":" + davRequest.getServerPort();
        if ("http".equals(davRequest.getScheme()) && davRequest.getServerPort() == 80 || "https".equals(davRequest.getScheme()) && davRequest.getServerPort() == 443) {
            string3 = "";
        }
        return stringBuilder.append(davRequest.getScheme() + "://" + davRequest.getServerName() + string3).append(string2).append("/").append(StringUtil.trimStart(string, "/")).toString();
    }

    public static String getGuidFromToken(String string) {
        ArgumentUtil.checkArgumentNotNull(string, "token");
        int n2 = string.indexOf(58);
        int n3 = string.indexOf(62);
        if (n3 < 0) {
            n3 = string.length();
        }
        return string.substring(n2 + 1, n3);
    }

    public static String stripContextPath(String string, DavRequest object) {
        if (((String)(object = StringUtil.trimEnd(((DavRequest)object).getContextPath() + ((DavRequest)object).getServerPath(), "/"))).length() == 0) {
            return string;
        }
        if (string.length() > ((String)object).length()) {
            return string.substring(((String)object).length());
        }
        return "/";
    }
}

