/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server;

import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.MethodHandler;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.MultistatusException;
import com.ithit.webdav.server.exceptions.Response;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.HandlerFactory;
import com.ithit.webdav.server.handler.MultistatusResponseWriter;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.http.FilteredDavRequest;
import com.ithit.webdav.server.http.FilteredDavResponse;
import com.ithit.webdav.server.license.LicenseValidator;
import com.ithit.webdav.server.util.ArgumentUtil;
import com.ithit.webdav.server.util.RequestUtil;
import com.ithit.webdav.server.util.ResponseUtil;
import com.ithit.webdav.server.util.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class Engine {
    private final Hashtable<String, MethodHandler> methodHandlers = new Hashtable();
    private static String version;

    public abstract HierarchyItem getHierarchyItem(String var1) throws ServerException;

    public abstract Logger getLogger();

    public abstract String getLicense();

    public String getResponseCharacterEncoding() {
        return "UTF-8";
    }

    public MethodHandler registerMethodHandler(String method, MethodHandler handler) {
        ArgumentUtil.checkArgumentNotNull(method, "method");
        ArgumentUtil.checkArgumentNotNull(handler, "handler");
        ArgumentUtil.checkArgument(method.length() > 0, "method should not be empty");
        method = method.toUpperCase();
        MethodHandler oldHandler = this.methodHandlers.get(method);
        this.methodHandlers.put(method, handler);
        return oldHandler != null ? oldHandler : HandlerFactory.createHandler(method, this, this.getLogger());
    }

    @Deprecated
    public static List<String> getClientLockTokens(DavRequest request) {
        return request.getClientLockTokens();
    }

    public boolean getAutoPutUnderVersionControl() {
        return false;
    }

    public boolean getCalculateContentLength() {
        return true;
    }

    public void service(DavRequest davRequest, DavResponse davResponse) throws DavException, IOException {
        ArgumentUtil.checkArgumentNotNull(davRequest, "davRequest");
        ArgumentUtil.checkArgumentNotNull(davResponse, "davResponse");
        try {
            String license = this.getLicense();
            LicenseValidator.checkLicense(license);
            String header = "IT Hit WebDAV Server v" + Engine.getVersion();
            if (license.contains("Evaluation")) {
                header = header + " (Evaluation License)";
            }
            this.processRequest(davRequest, davResponse, header);
        }
        catch (IOException e) {
            this.getLogger().logError(e.getMessage(), e);
            throw e;
        }
    }

    public static String getVersion() {
        if (version == null || version.equals("")) {
            version = "4.4.3821";
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(DavRequest davRequest, DavResponse davResponse, String engineHeader) throws IOException, DavException {
        String method = davRequest.getMethod().toUpperCase();
        MethodHandler handler = this.methodHandlers.get(method);
        if (handler == null) {
            handler = HandlerFactory.createHandler(method, this, this.getLogger());
        }
        FilteredDavRequest filteredRequest = new FilteredDavRequest(davRequest, this.getLogger().isDebugEnabled() && handler != null && handler.getLogInput());
        FilteredDavResponse filteredResponse = new FilteredDavResponse(davResponse, this.getCalculateContentLength(), this.getLogger().isDebugEnabled() && handler != null && handler.getLogOutput());
        this.addCrossDomainHeaders(davRequest, filteredResponse);
        filteredResponse.addHeader("X-Engine", engineHeader);
        try {
            if (handler == null) {
                throw new ServerException(WebDavStatus.METHOD_NOT_ALLOWED);
            }
            if (!handler.getCalculateContentLength()) {
                filteredResponse.setCalcContentLength(false);
            }
            HierarchyItem item = this.getHierarchyItem(RequestUtil.getRequestPathAndQueryString(davRequest));
            handler.processRequest(filteredRequest, filteredResponse, item);
        }
        catch (MultistatusException e) {
            filteredResponse.setStatus(e.getStatus().getCode(), e.getStatus().getDescription());
            this.writeMultistatus(filteredRequest, filteredResponse, e);
        }
        catch (DavException ex) {
            filteredResponse.setStatus(ex.getStatus().getCode(), ex.getStatus().getDescription());
            if (!this.writeErrors(davResponse, ex) && this.getCalculateContentLength()) {
                davResponse.setContentLength(0L);
            }
            if (ex instanceof ServerException && ex.getCause() != null && ex.getStatus() == WebDavStatus.INTERNAL_ERROR) {
                if (this.isResponseBodyAllowed(davRequest)) {
                    byte[] erMessage = ex.getMessage().getBytes(this.getResponseCharacterEncoding());
                    filteredResponse.geFilteredDavOutputStream().write(erMessage, 0, erMessage.length);
                }
                this.getLogger().logError(ex.getMessage(), ex);
                throw ex;
            }
        }
        finally {
            filteredResponse.finish();
            if (this.getLogger().isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("\n\n");
                sb.append(filteredRequest.toString());
                sb.append("\n\n");
                sb.append(filteredResponse.toString());
                this.getLogger().logDebug(sb.toString());
            }
        }
    }

    private void addCrossDomainHeaders(DavRequest request, DavResponse response) {
        String origin = request.getHeader("Origin");
        response.addHeader("Access-Control-Allow-Origin", StringUtil.isNullOrEmpty(origin) ? "*" : StringUtil.trimEnd(origin, "/"));
        response.addHeader("Access-Control-Allow-Credentials", "true");
        response.addHeader("Access-Control-Allow-Methods", "PROPFIND, PROPPATCH, COPY, MOVE, DELETE, MKCOL, LOCK, UNLOCK, PUT, GETLIB, VERSION-CONTROL, CHECKIN, CHECKOUT, UNCHECKOUT, REPORT, UPDATE, CANCELUPLOAD, HEAD, OPTIONS, GET, POST");
        response.addHeader("Access-Control-Allow-Headers", "Overwrite, Destination, Content-Type, Depth, User-Agent, Translate, Range, Content-Range, Timeout, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control, Location, Lock-Token, If");
        response.addHeader("Access-Control-Expose-Headers", "DAV, content-length, Allow");
        response.addHeader("Access-Control-Max-Age", Integer.toString(Integer.MAX_VALUE));
    }

    private void writeMultistatus(DavRequest davRequest, DavResponse davResponse, MultistatusException e) throws ServerException, IOException {
        MultistatusResponseWriter mResp = new MultistatusResponseWriter(davRequest, davResponse, this.getResponseCharacterEncoding());
        try {
            mResp.startMultiStatusResponse();
            for (Response r : e.getResponses()) {
                mResp.addStatusResponse(r);
            }
            mResp.endMultiStatusResponse();
        }
        catch (XMLStreamException e1) {
            throw new ServerException(e1);
        }
    }

    private boolean isResponseBodyAllowed(DavRequest request) {
        String method = request.getMethod();
        return !method.equalsIgnoreCase("HEAD") && !method.equalsIgnoreCase("OPTIONS");
    }

    private boolean writeErrors(DavResponse response, DavException exception) throws IOException {
        this.writeExtendedErrorHeader(response, exception);
        try {
            if (!StringUtil.isNullOrEmpty(exception.getLocalName()) || !StringUtil.isNullOrEmpty(exception.getMessage())) {
                XMLStreamWriter msWriter = ResponseUtil.createXmlResponse(response, this.getResponseCharacterEncoding());
                msWriter.writeStartDocument();
                String nsDav = "DAV:";
                msWriter.writeStartElement("d", "error", nsDav);
                msWriter.writeNamespace("d", nsDav);
                if (!StringUtil.isNullOrEmpty(exception.getLocalName())) {
                    if (nsDav.equals(exception.getNamespace())) {
                        msWriter.writeEmptyElement("d", exception.getLocalName(), nsDav);
                    } else {
                        msWriter.writeNamespace("m", exception.getNamespace());
                        msWriter.writeEmptyElement("m", exception.getLocalName(), exception.getNamespace());
                    }
                }
                if (!StringUtil.isNullOrEmpty(exception.getMessage())) {
                    msWriter.writeStartElement("d", "responsedescription", nsDav);
                    msWriter.writeCharacters(exception.getMessage());
                    msWriter.writeEndElement();
                }
                msWriter.writeEndElement();
                msWriter.writeEndDocument();
                msWriter.flush();
                return true;
            }
        }
        catch (XMLStreamException ex) {
            this.getLogger().logError("", ex);
        }
        return false;
    }

    private void writeExtendedErrorHeader(DavResponse response, DavException exception) {
        try {
            response.addHeader("X-MSDAVEXT_ERROR", exception.getExtendedError() + "; " + (exception.getMessage() == null ? "" : URLEncoder.encode(exception.getMessage(), "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().logError("UTF-8 not found", e);
        }
    }
}

