/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.exceptions;

import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.util.ArgumentUtil;

public abstract class DavException
extends Exception {
    private WebDavStatus status;
    private String namespace;
    private String elName;
    private int extendedError;

    protected DavException(WebDavStatus status) {
        ArgumentUtil.checkArgumentNotNull(status, "status");
        this.status = status;
    }

    protected DavException(WebDavStatus status, int extendedError) {
        this(status);
        this.extendedError = extendedError;
    }

    protected DavException(String message, WebDavStatus status) {
        super(message);
        ArgumentUtil.checkArgumentNotNull(status, "status");
        this.status = status;
    }

    protected DavException(String message, WebDavStatus status, int extendedError) {
        this(message, status);
        this.extendedError = extendedError;
    }

    protected DavException(String message, Throwable throwable, WebDavStatus status) {
        super(message, throwable);
        this.status = status;
        ArgumentUtil.checkArgumentNotNull(status, "status");
    }

    protected DavException(String message, Throwable throwable, WebDavStatus status, int extendedError) {
        this(message, throwable, status);
        this.extendedError = extendedError;
    }

    protected DavException(String message, WebDavStatus status, String ns, String elName) {
        super(message);
        ArgumentUtil.checkArgumentNotNull(ns, "ns");
        ArgumentUtil.checkArgumentNotNull(elName, "elName");
        ArgumentUtil.checkArgumentNotNull(status, "status");
        this.namespace = ns;
        this.elName = elName;
        this.status = status;
    }

    protected DavException(String message, WebDavStatus status, String ns, String elName, int extendedError) {
        this(message, status, ns, elName);
        this.extendedError = extendedError;
    }

    protected DavException(String message, Throwable throwable, WebDavStatus status, String ns, String elName) {
        super(message, throwable);
        ArgumentUtil.checkArgumentNotNull(ns, "ns");
        ArgumentUtil.checkArgumentNotNull(elName, "elName");
        ArgumentUtil.checkArgumentNotNull(status, "status");
        this.namespace = ns;
        this.elName = elName;
        this.status = status;
    }

    protected DavException(String message, Throwable throwable, WebDavStatus status, String ns, String elName, int extendedError) {
        this(message, throwable, status, ns, elName);
        this.extendedError = extendedError;
    }

    public DavException(Throwable throwable, WebDavStatus status) {
        super(throwable);
        ArgumentUtil.checkArgumentNotNull(status, "status");
        this.status = status;
    }

    protected DavException(Throwable throwable, WebDavStatus status, int extendedError) {
        this(throwable, status);
        this.extendedError = extendedError;
    }

    public WebDavStatus getStatus() {
        return this.status;
    }

    public String getLocalName() {
        return this.elName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setLocalName(String localName) {
        this.elName = localName;
    }

    public int getExtendedError() {
        return this.extendedError;
    }
}

