/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.exceptions;

import com.ithit.webdav.server.Property;
import com.ithit.webdav.server.exceptions.ItemResponse;
import com.ithit.webdav.server.exceptions.PropStat;
import com.ithit.webdav.server.exceptions.PropStatResponse;
import com.ithit.webdav.server.exceptions.Response;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.util.ArgumentUtil;
import java.util.ArrayList;
import java.util.Arrays;

class MultistatusResponse {
    private final ArrayList<Response> responses = new ArrayList();
    private String responseDescription;

    MultistatusResponse() {
    }

    public void addResponses(Response ... responses) {
        this.responses.addAll(Arrays.asList(responses));
    }

    public void addResponse(String path, WebDavStatus status) {
        this.addResponse(path, status, null, null);
    }

    public void addResponse(String path, Property property, WebDavStatus status) {
        this.addResponse(path, property, status, null, null);
    }

    public void addResponse(String path, WebDavStatus status, String href, String responseDescription) {
        ArgumentUtil.checkArgumentNotNull(path, "path");
        ArgumentUtil.checkArgumentNotNull(status, "status");
        boolean itemFound = false;
        for (Response resp : this.responses) {
            ItemResponse itemResp = resp instanceof ItemResponse ? (ItemResponse)resp : null;
            if (itemResp == null || !resp.getItemPath().equals(path) || !this.stringEquals(responseDescription, resp.getResponseDescription()) || !itemResp.getStatus().equals(status)) continue;
            if (href != null) {
                itemResp.getHrefs().add(href);
            }
            itemFound = true;
            break;
        }
        if (!itemFound) {
            ItemResponse resp = new ItemResponse(path, status, href, responseDescription);
            this.responses.add(resp);
        }
    }

    public void addResponse(String path, Property property, WebDavStatus status, String responseDescription, String propResponseDescription) {
        ArgumentUtil.checkArgumentNotNull(path, "path");
        ArgumentUtil.checkArgumentNotNull(status, "status");
        ArgumentUtil.checkArgumentNotNull(property, "property");
        boolean itemFound = false;
        for (Response resp : this.responses) {
            PropStatResponse propStatResp = resp instanceof PropStatResponse ? (PropStatResponse)resp : null;
            if (propStatResp == null || !resp.getItemPath().equals(path) || !this.stringEquals(responseDescription, resp.getResponseDescription())) continue;
            boolean propStatFound = false;
            for (PropStat propStat : propStatResp.getPropStats()) {
                if (!propStat.getStatus().equals(status) || !this.stringEquals(propResponseDescription, propStat.getDescription())) continue;
                propStat.getProperties().add(property);
                propStatFound = true;
                break;
            }
            if (!propStatFound) {
                PropStat propStat = new PropStat(new Property[]{property}, status, propResponseDescription);
                propStatResp.getPropStats().add(propStat);
            }
            itemFound = true;
            break;
        }
        if (!itemFound) {
            PropStat propStat = new PropStat(new Property[]{property}, status, propResponseDescription);
            this.responses.add(new PropStatResponse(path, new PropStat[]{propStat}, responseDescription));
        }
    }

    public Response[] getResponses() {
        return this.responses.toArray(new Response[this.responses.size()]);
    }

    public String getResponseDescription() {
        return this.responseDescription;
    }

    public void setResponseDescription(String responseDescription) {
        this.responseDescription = responseDescription;
    }

    private boolean stringEquals(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }
}

