/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.exceptions;

import com.ithit.webdav.server.util.ArgumentUtil;

public class WebDavStatus {
    private final int code;
    private final String description;
    public static final WebDavStatus OK = new WebDavStatus(200, "OK");
    public static final WebDavStatus ACCESS_DENIED = new WebDavStatus(401, "Access Denied");
    public static final WebDavStatus CONFLICT = new WebDavStatus(409, "Conflict");
    public static final WebDavStatus CREATED = new WebDavStatus(201, "Created");
    public static final WebDavStatus FAILED_DEPENDENCY = new WebDavStatus(424, "Failed Dependency");
    public static final WebDavStatus LOCKED = new WebDavStatus(423, "Locked");
    public static final WebDavStatus NO_CONTENT = new WebDavStatus(204, "No Content");
    public static final WebDavStatus NOT_ALLOWED = new WebDavStatus(405, "Method Not Allowed");
    public static final WebDavStatus PRECONDITION_FAILED = new WebDavStatus(412, "Precondition Failed");
    public static final WebDavStatus INTERNAL_ERROR = new WebDavStatus(500, "Internal server error");
    public static final WebDavStatus BAD_REQUEST = new WebDavStatus(400, "Bad Request");
    public static final WebDavStatus MULTISTATUS = new WebDavStatus(207, "Multistatus");
    public static final WebDavStatus NOT_FOUND = new WebDavStatus(404, "Not Found");
    public static final WebDavStatus METHOD_NOT_ALLOWED = new WebDavStatus(405, "Method Not Allowed");
    public static final WebDavStatus NOT_MODIFIED = new WebDavStatus(304, "Not Modified");
    public static final WebDavStatus PARTIAL_CONTENT = new WebDavStatus(206, "Partial Content");
    public static final WebDavStatus FORBIDDEN = new WebDavStatus(403, "Forbidden");
    public static final WebDavStatus NOT_IMPLEMENTED = new WebDavStatus(501, "Not Implemented");
    public static final WebDavStatus UNSUPPORTED_MEDIA_TYPE = new WebDavStatus(415, "Unsupported media type");
    public static final WebDavStatus INSUFFICIENT_STORAGE = new WebDavStatus(507, "Insufficient Storage");

    public WebDavStatus(int code, String description) {
        ArgumentUtil.checkArgumentNotNull(description, "description");
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHttpString() {
        return String.format("HTTP/1.1 %1s %2s", this.getCode(), this.getDescription());
    }
}

