/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.File;
import com.ithit.webdav.server.Folder;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.LockInfo;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.MethodHandler;
import com.ithit.webdav.server.Property;
import com.ithit.webdav.server.deltav.AutoVersion;
import com.ithit.webdav.server.deltav.DeltaVItem;
import com.ithit.webdav.server.deltav.Version;
import com.ithit.webdav.server.deltav.VersionableItem;
import com.ithit.webdav.server.exceptions.ConflictException;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.LockedException;
import com.ithit.webdav.server.exceptions.MultistatusException;
import com.ithit.webdav.server.exceptions.PreconditionFailedException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.DavNamespaceContext;
import com.ithit.webdav.server.handler.IfHelper;
import com.ithit.webdav.server.handler.MultistatusResponseWriter;
import com.ithit.webdav.server.handler.XmlUtil;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.quota.Quota;
import com.ithit.webdav.server.util.RequestUtil;
import com.ithit.webdav.server.util.StringUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

abstract class BaseDavHandler
implements MethodHandler {
    private DavRequest request;
    private DavResponse response;
    private final Engine engine;
    private final Logger logger;
    protected static final String nsDav = "DAV:";
    private static final String[] readonlyProps = new String[]{"creationdate", "displayname", "getcontentlength", "getcontenttype", "getlastmodified", "resourcetype", "supportedlock", "lockdiscovery", "checkout-set", "predecessor-set", "successor-set", "version-name", "getetag"};

    protected BaseDavHandler(Engine engine, Logger logger) {
        this.engine = engine;
        this.logger = logger;
    }

    @Override
    public void processRequest(DavRequest request, DavResponse response, HierarchyItem item) throws DavException, IOException {
        this.request = request;
        this.response = response;
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected String getDepth() {
        return this.request.getHeader("Depth");
    }

    protected DavRequest getRequest() {
        return this.request;
    }

    protected DavResponse getResponse() {
        return this.response;
    }

    protected String getRequestPath() {
        return RequestUtil.getRequestPath(this.request);
    }

    protected String getRequestPathAndQueryString() {
        return RequestUtil.getRequestPathAndQueryString(this.request);
    }

    protected String getDestination() throws ServerException {
        try {
            URI uri = new URI(this.request.getHeader("Destination"));
            return RequestUtil.stripContextPath(uri.getRawPath(), this.request);
        }
        catch (URISyntaxException e) {
            throw new ServerException("Invalid destination Uri", e);
        }
    }

    protected boolean exists(HierarchyItem item) {
        if (item == null) {
            this.setStatus(WebDavStatus.NOT_FOUND);
            return false;
        }
        return true;
    }

    protected static void requireParentExists(Folder parent) throws ConflictException {
        if (parent == null) {
            throw new ConflictException();
        }
    }

    protected void setStatus(WebDavStatus status) {
        this.response.setStatus(status.getCode(), status.getDescription());
    }

    protected static Property notFoundProp(String namesp, String name) {
        return new Property(namesp, name, null);
    }

    protected void addHeader(String headerName, String headerValue) {
        this.response.addHeader(headerName, headerValue);
    }

    protected Folder getParent(String path) throws DavException {
        int splitIndex;
        String parentPath = (path = StringUtil.trimEnd(path, "/")).substring(0, (splitIndex = path.lastIndexOf(47)) + 1);
        HierarchyItem item = this.engine.getHierarchyItem(parentPath);
        return item instanceof Folder ? (Folder)item : null;
    }

    protected String getName(String path) throws ServerException {
        path = StringUtil.trimEnd(path, "/");
        int splitIndex = path.lastIndexOf(47);
        try {
            return URLDecoder.decode(path.substring(splitIndex + 1).replaceAll("\\+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ServerException(e);
        }
    }

    public boolean writeModified(MultistatusResponseWriter mResp, HierarchyItem item) throws XMLStreamException, ServerException {
        long modified = item.getModified();
        if (modified != Long.MIN_VALUE) {
            String strModified = this.formatModified(modified);
            mResp.writeProperty("getlastmodified", nsDav, strModified);
            return true;
        }
        return false;
    }

    protected String formatModified(long modified) {
        String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(new Date(modified));
    }

    public boolean writeContentLength(MultistatusResponseWriter mResp, HierarchyItem item) throws XMLStreamException, ServerException {
        if (item instanceof File) {
            File res = (File)item;
            mResp.writeProperty("getcontentlength", nsDav, Long.toString(res.getContentLength()));
            return true;
        }
        return false;
    }

    public boolean writeEtag(MultistatusResponseWriter mResp, HierarchyItem item) throws XMLStreamException, ServerException {
        if (item instanceof File) {
            File res = (File)item;
            if (res.getEtag() != null) {
                mResp.writeProperty("getetag", nsDav, String.format("\"%s\"", res.getEtag()));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document initializeRequestDocumentAndMngr() throws IOException, ServerException {
        DocumentBuilderFactory objDocFactory = DocumentBuilderFactory.newInstance();
        try {
            String FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
            objDocFactory.setFeature(FEATURE, true);
        }
        catch (Exception ex) {
            this.getLogger().logError("Cannot configure XXE defense", ex);
        }
        objDocFactory.setNamespaceAware(true);
        try {
            DocumentBuilder objDocBuilder = objDocFactory.newDocumentBuilder();
            StringBuilder sb = new StringBuilder();
            String encoding = this.getRequest().getCharacterEncoding();
            InputStreamReader sr = new InputStreamReader(this.getRequest().getInputStream(), encoding == null ? "UTF-8" : encoding);
            try {
                int read;
                char[] chars = new char[1000];
                while ((read = sr.read(chars, 0, chars.length)) > 0) {
                    sb.append(chars, 0, read);
                }
            }
            finally {
                sr.close();
            }
            String data = sb.toString();
            if (data.length() == 0) {
                return null;
            }
            return objDocBuilder.parse(new InputSource(new StringReader(data)));
        }
        catch (SAXException e) {
            throw new ServerException((Throwable)e, WebDavStatus.BAD_REQUEST);
        }
        catch (ParserConfigurationException e) {
            throw new ServerException(e);
        }
    }

    protected Node selectNode(Document doc, String expression) throws ServerException {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            xPath.setNamespaceContext(new DavNamespaceContext());
            XPathExpression xPathExpr = xPath.compile(expression);
            return (Node)xPathExpr.evaluate(doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new ServerException(e);
        }
    }

    protected NodeList selectNodes(Document doc, String expression) throws ServerException {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            xPath.setNamespaceContext(new DavNamespaceContext());
            XPathExpression xPathExpr = xPath.compile(expression);
            return (NodeList)xPathExpr.evaluate(doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new ServerException(e);
        }
    }

    protected static void writeLockInfo(XMLStreamWriter w, LockInfo lockInfo) throws XMLStreamException {
        w.writeStartElement(nsDav, "activelock");
        w.writeStartElement(nsDav, "lockscope");
        w.writeEmptyElement(nsDav, lockInfo.isShared() ? "shared" : "exclusive");
        w.writeEndElement();
        w.writeStartElement(nsDav, "locktype");
        w.writeEmptyElement(nsDav, "write");
        w.writeEndElement();
        XmlUtil.writeElementString(w, "depth", nsDav, lockInfo.isDeep() ? "infinity" : "0");
        XmlUtil.writeElementString(w, "owner", nsDav, lockInfo.getOwner());
        w.writeStartElement(nsDav, "timeout");
        if (lockInfo.getTimeout() == -1L) {
            w.writeCharacters("Infinite");
        } else {
            w.writeCharacters("Second-" + lockInfo.getTimeout());
        }
        w.writeEndElement();
        w.writeStartElement(nsDav, "locktoken");
        XmlUtil.writeElementString(w, "href", nsDav, "opaquelocktoken:" + lockInfo.getToken());
        w.writeEndElement();
        w.writeEndElement();
    }

    @Override
    public boolean getLogInput() {
        return true;
    }

    @Override
    public boolean getLogOutput() {
        return true;
    }

    @Override
    public boolean getCalculateContentLength() {
        return true;
    }

    public Engine getEngine() {
        return this.engine;
    }

    protected boolean isOverwrite() {
        return "T".equals(this.getRequest().getHeader("Overwrite"));
    }

    protected void requireOverwrite() throws DavException {
        if (!this.isOverwrite()) {
            throw new PreconditionFailedException("Overwrite required");
        }
    }

    protected static boolean[] findReadOnlyProps(List<Property> props) {
        boolean found = false;
        boolean[] propsro = new boolean[props.size()];
        block0: for (int i = 0; i < props.size(); ++i) {
            if (!nsDav.equals(props.get(i).getNamespace())) continue;
            for (String readonlyProp : readonlyProps) {
                if (props.get(i).getName().equals(readonlyProp)) {
                    propsro[i] = true;
                    found = true;
                    continue block0;
                }
                propsro[i] = false;
            }
        }
        return (boolean[])(found ? propsro : null);
    }

    protected static void createFailedResponse(String itemUri, List<Property> setProps, List<Property> delProps, boolean[] setro, boolean[] delro) throws MultistatusException {
        int i;
        MultistatusException respro = new MultistatusException();
        for (i = 0; i < setProps.size(); ++i) {
            if (setro != null && setro[i]) {
                respro.addResponse(itemUri, setProps.get(i), WebDavStatus.CONFLICT);
                continue;
            }
            respro.addResponse(itemUri, setProps.get(i), WebDavStatus.FAILED_DEPENDENCY);
        }
        for (i = 0; i < delProps.size(); ++i) {
            if (delro != null && delro[i]) {
                respro.addResponse(itemUri, delProps.get(i), WebDavStatus.CONFLICT);
                continue;
            }
            respro.addResponse(itemUri, delProps.get(i), WebDavStatus.FAILED_DEPENDENCY);
        }
        throw respro;
    }

    protected static List<Property> updateLiveProperties(HierarchyItem item, List<Property> props) throws ServerException, MultistatusException, LockedException {
        DeltaVItem deltaVItem;
        ArrayList<Property> propsUpdated = new ArrayList<Property>();
        DeltaVItem deltaVItem2 = deltaVItem = item instanceof DeltaVItem ? (DeltaVItem)item : null;
        if (deltaVItem == null) {
            return propsUpdated;
        }
        for (Property p : props) {
            VersionableItem verItem;
            if (!p.getNamespace().equals(nsDav)) continue;
            if (p.getName().equals("comment")) {
                deltaVItem.setComment(p.getValue());
                propsUpdated.add(p);
                continue;
            }
            if (p.getName().equals("creator-displayname")) {
                deltaVItem.setCreatorDisplayName(p.getValue());
                propsUpdated.add(p);
                continue;
            }
            if (!p.getName().equals("auto-version")) continue;
            VersionableItem versionableItem = verItem = deltaVItem instanceof VersionableItem ? (VersionableItem)deltaVItem : null;
            if (verItem != null) {
                if (p.getValue().equals("checkout-checkin")) {
                    verItem.setAutoVersion(AutoVersion.CheckOutCheckIn);
                } else if (p.getValue().equals("checkout-unlocked-checkin")) {
                    verItem.setAutoVersion(AutoVersion.CheckOutUnlockedCheckIn);
                } else if (p.getValue().equals("checkout")) {
                    verItem.setAutoVersion(AutoVersion.CheckOut);
                } else if (p.getValue().equals("locked-checkout")) {
                    verItem.setAutoVersion(AutoVersion.LockedCheckOut);
                } else if (p.getValue().equals("")) {
                    verItem.setAutoVersion(AutoVersion.NoAutoVersioning);
                } else {
                    throw new ServerException(WebDavStatus.NOT_IMPLEMENTED);
                }
            }
            propsUpdated.add(p);
        }
        for (Property p : propsUpdated) {
            props.remove(p);
        }
        return propsUpdated;
    }

    protected boolean writeCreated(MultistatusResponseWriter mResp, HierarchyItem item) throws ServerException, XMLStreamException {
        long created = item.getCreated();
        if (created == Long.MIN_VALUE) {
            return false;
        }
        String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        mResp.writeProperty("creationdate", nsDav, sdf.format(new Date(created)));
        return true;
    }

    protected boolean writeContentType(MultistatusResponseWriter resp, HierarchyItem item) throws XMLStreamException, ServerException {
        if (item instanceof File) {
            String contentType = ((File)item).getContentType();
            resp.writeProperty("getcontenttype", nsDav, contentType == null ? "" : contentType);
            return true;
        }
        return false;
    }

    protected boolean writeCreatorDisplayname(MultistatusResponseWriter mResp, HierarchyItem item) throws ServerException, XMLStreamException {
        DeltaVItem deltaVItem;
        DeltaVItem deltaVItem2 = deltaVItem = item instanceof DeltaVItem ? (DeltaVItem)item : null;
        if (deltaVItem == null) {
            return false;
        }
        String creatorDisplayName = deltaVItem.getCreatorDisplayName();
        if (creatorDisplayName != null) {
            mResp.writeProperty("creator-displayname", nsDav, creatorDisplayName);
            return true;
        }
        return false;
    }

    protected boolean writeComment(MultistatusResponseWriter mResp, HierarchyItem item) throws XMLStreamException, ServerException {
        DeltaVItem deltaVItem;
        DeltaVItem deltaVItem2 = deltaVItem = item instanceof DeltaVItem ? (DeltaVItem)item : null;
        if (deltaVItem == null) {
            return false;
        }
        mResp.writeProperty("comment", nsDav, deltaVItem.getComment());
        return true;
    }

    private void writePredecessorSet(MultistatusResponseWriter mResp, Version item) throws ServerException, XMLStreamException {
        Version predecessor = item;
        XMLStreamWriter msWriter = mResp.startProperty(nsDav, "predecessor-set");
        do {
            if ((predecessor = predecessor.getPredecessor()) == null) continue;
            mResp.writeItemHref(msWriter, IfHelper.getPath(predecessor));
        } while (predecessor != null);
        mResp.endProperty();
    }

    protected boolean writePredecessorSet(MultistatusResponseWriter mResp, HierarchyItem item) throws ServerException, XMLStreamException {
        VersionableItem verItem;
        Version version;
        Version version2 = version = item instanceof Version ? (Version)item : null;
        if (version != null) {
            this.writePredecessorSet(mResp, version);
            return true;
        }
        VersionableItem versionableItem = verItem = item instanceof VersionableItem ? (VersionableItem)item : null;
        if (verItem == null || !verItem.isCheckedOut()) {
            return false;
        }
        XMLStreamWriter msWriter = mResp.startProperty(nsDav, "predecessor-set");
        for (Version predecessor = IfHelper.getCurrenVersion(verItem.getVersionHistory()); predecessor != null; predecessor = predecessor.getPredecessor()) {
            mResp.writeItemHref(msWriter, IfHelper.getPath(predecessor));
        }
        mResp.endProperty();
        return true;
    }

    protected boolean writeSuccessorSet(MultistatusResponseWriter mResp, HierarchyItem item) throws ServerException, XMLStreamException {
        Version version;
        Version version2 = version = item instanceof Version ? (Version)item : null;
        if (version != null) {
            this.writeSuccessorSet(mResp, version);
            return true;
        }
        return false;
    }

    protected void writeSuccessorSet(MultistatusResponseWriter mResp, Version item) throws ServerException, XMLStreamException {
        XMLStreamWriter msWriter = mResp.startProperty(nsDav, "successor-set");
        Version succ = item;
        do {
            if ((succ = succ.getSuccessor()) == null) continue;
            mResp.writeItemHref(msWriter, IfHelper.getPath(succ));
        } while (succ != null);
        mResp.endProperty();
    }

    protected boolean writeCheckedOut(MultistatusResponseWriter mResp, HierarchyItem item) throws ServerException, XMLStreamException {
        VersionableItem verItem;
        VersionableItem versionableItem = verItem = item instanceof VersionableItem ? (VersionableItem)item : null;
        if (verItem == null || verItem.getVersionHistory() == null) {
            return false;
        }
        if (verItem.isCheckedOut()) {
            XMLStreamWriter msWriter = mResp.startProperty(nsDav, "checked-out");
            mResp.writeItemHref(msWriter, IfHelper.getPath(IfHelper.getCurrenVersion(verItem.getVersionHistory())));
            mResp.endProperty();
            return true;
        }
        return false;
    }

    protected boolean writeCheckoutSet(MultistatusResponseWriter mResp, HierarchyItem item) throws ServerException, XMLStreamException {
        Version version;
        Version version2 = version = item instanceof Version ? (Version)item : null;
        if (version != null) {
            this.writeCheckoutSet(mResp, version);
            return true;
        }
        return false;
    }

    protected void writeCheckoutSet(MultistatusResponseWriter mResp, Version version) throws ServerException, XMLStreamException {
        VersionableItem verItem;
        XMLStreamWriter msWriter = mResp.startProperty(nsDav, "checkout-set");
        if (version != null && (verItem = IfHelper.getVersionableItem(version)).isCheckedOut() && version.getSuccessor() == null) {
            mResp.writeItemHref(msWriter, IfHelper.getPath(verItem));
        }
        mResp.endProperty();
    }

    protected boolean writeVersionName(MultistatusResponseWriter mResp, HierarchyItem item) throws ServerException, XMLStreamException {
        Version version;
        Version version2 = version = item instanceof Version ? (Version)item : null;
        if (version != null) {
            this.writeVersionName(mResp, version);
            return true;
        }
        return false;
    }

    protected void writeVersionName(MultistatusResponseWriter mResp, Version version) throws XMLStreamException, ServerException {
        mResp.writeProperty("version-name", nsDav, IfHelper.getVersionName(version));
    }

    boolean writeQuotaAvailableBytes(MultistatusResponseWriter mResp, HierarchyItem item) throws ServerException, XMLStreamException {
        Quota quota;
        Quota quota2 = quota = item instanceof Quota ? (Quota)((Object)item) : null;
        if (quota != null) {
            long availableBytes = 0L;
            try {
                availableBytes = quota.getAvailableBytes();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.writeQuotaAvailableBytes(mResp, availableBytes);
            return true;
        }
        return false;
    }

    private void writeQuotaAvailableBytes(MultistatusResponseWriter mResp, long bytes) throws XMLStreamException, ServerException {
        mResp.writeProperty("quota-available-bytes", nsDav, String.valueOf(bytes));
    }

    boolean writeQuotaUsedBytes(MultistatusResponseWriter mResp, HierarchyItem item) throws ServerException, XMLStreamException {
        Quota quota;
        Quota quota2 = quota = item instanceof Quota ? (Quota)((Object)item) : null;
        if (quota != null) {
            long usedBytes = 0L;
            try {
                usedBytes = quota.getUsedBytes();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.writeQuotaUsedBytes(mResp, usedBytes);
            return true;
        }
        return false;
    }

    private void writeQuotaUsedBytes(MultistatusResponseWriter mResp, long bytes) throws XMLStreamException, ServerException {
        mResp.writeProperty("quota-used-bytes", nsDav, String.valueOf(bytes));
    }

    private boolean ifNoneMatches(HierarchyItem item, String ifNotMatch) throws ServerException {
        ifNotMatch = ifNotMatch.trim();
        File file = (File)item;
        if (file == null) {
            return true;
        }
        if ("*".equals(ifNotMatch) && !StringUtil.isNullOrEmpty(file.getEtag())) {
            return false;
        }
        for (String s : ifNotMatch.split(",")) {
            String etag = StringUtil.trimStart(StringUtil.trimEnd(s.trim(), "\""), "\"");
            if (!etag.equals(file.getEtag())) continue;
            return false;
        }
        return true;
    }

    private boolean ifHeader(HierarchyItem item, String ifMatch) throws ServerException {
        if ((ifMatch = ifMatch.trim()).contains("[") && ifMatch.contains("]")) {
            File file = (File)item;
            if (file == null) {
                return false;
            }
            String etagWithQuotes = ifMatch.substring(ifMatch.lastIndexOf("[") + 1, ifMatch.lastIndexOf("]"));
            if (!(etagWithQuotes = StringUtil.trimEnd(StringUtil.trimStart(etagWithQuotes, "\""), "\"")).equals(file.getEtag())) {
                return false;
            }
        }
        return true;
    }

    protected boolean ifMatches(HierarchyItem item, String ifMatch) throws ServerException {
        ifMatch = ifMatch.trim();
        File file = (File)item;
        if (file == null) {
            return false;
        }
        if ("*".equals(ifMatch) && StringUtil.isNullOrEmpty(file.getEtag())) {
            return false;
        }
        for (String s : ifMatch.split(",")) {
            String etag = StringUtil.trimStart(StringUtil.trimEnd(s.trim(), "\""), "\"");
            if (!etag.equals(file.getEtag())) continue;
            return true;
        }
        return false;
    }

    protected boolean processIfHeaders(HierarchyItem item, WebDavStatus ifNoneMatchStatus) throws ServerException {
        String ifHdr = this.request.getHeader("If");
        String ifMatch = this.request.getHeader("If-Match");
        String ifNoneMatch = this.request.getHeader("If-None-Match");
        String ifModifiedSince = this.request.getHeader("If-Modified-Since");
        String ifUnmodifiedSince = this.request.getHeader("If-Unmodified-Since");
        if (!StringUtil.isNullOrEmpty(ifHdr) && !this.ifHeader(item, ifHdr)) {
            this.setStatus(WebDavStatus.PRECONDITION_FAILED);
            return false;
        }
        if (!StringUtil.isNullOrEmpty(ifMatch) && !this.ifMatches(item, ifMatch)) {
            this.setStatus(WebDavStatus.PRECONDITION_FAILED);
            return false;
        }
        if (!StringUtil.isNullOrEmpty(ifUnmodifiedSince)) {
            if (item == null) {
                return true;
            }
            try {
                Date ifUnmodified = this.getHttpDate(ifUnmodifiedSince);
                long resModified = this.getResModified(item);
                if (resModified > ifUnmodified.getTime()) {
                    this.setStatus(WebDavStatus.PRECONDITION_FAILED);
                    return false;
                }
            }
            catch (ParseException ex) {
                this.getLogger().logError("Cannot parse since modified date.", ex);
            }
        } else if (!StringUtil.isNullOrEmpty(ifNoneMatch)) {
            if (!this.ifNoneMatches(item, ifNoneMatch)) {
                this.setStatus(ifNoneMatchStatus);
                return false;
            }
        } else if (!StringUtil.isNullOrEmpty(ifModifiedSince)) {
            if (item == null) {
                return true;
            }
            try {
                Date ifModified = this.getHttpDate(ifModifiedSince);
                long resModified = this.getResModified(item);
                if (resModified <= ifModified.getTime()) {
                    this.setStatus(WebDavStatus.NOT_MODIFIED);
                    return false;
                }
            }
            catch (ParseException ex) {
                this.getLogger().logError("Cannot parse since modified date.", ex);
            }
        }
        return true;
    }

    private Date getHttpDate(String ifUnmodifiedSince) throws ParseException {
        String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
        return sdf.parse(ifUnmodifiedSince);
    }

    private long getResModified(HierarchyItem item) throws ServerException {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(item.getModified());
        calendar.clear(14);
        return calendar.getTimeInMillis();
    }
}

