/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.File;
import com.ithit.webdav.server.Folder;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Lock;
import com.ithit.webdav.server.LockInfo;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.Property;
import com.ithit.webdav.server.deltav.AutoVersion;
import com.ithit.webdav.server.deltav.DeltaVItem;
import com.ithit.webdav.server.deltav.History;
import com.ithit.webdav.server.deltav.Version;
import com.ithit.webdav.server.deltav.VersionableItem;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.MultistatusException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.handler.IfHelper;
import com.ithit.webdav.server.handler.MultistatusResponseWriter;
import com.ithit.webdav.server.resumableupload.UploadProgress;
import com.ithit.webdav.server.util.ChildIterable;
import com.ithit.webdav.server.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

abstract class BasePropDavHandler
extends BaseDavHandler {
    BasePropDavHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    void writeAllProp(MultistatusResponseWriter mResp, HierarchyItem item) throws XMLStreamException, MultistatusException, ServerException {
        mResp.startPropStat();
        mResp.startProp();
        this.writeContentLength(mResp, item);
        this.writeContentType(mResp, item);
        this.writeDisplayName(mResp, item);
        this.writeResourceType(mResp, item);
        this.writeCreated(mResp, item);
        this.writeModified(mResp, item);
        this.writeEtag(mResp, item);
        this.writeSupportedLock(mResp, item);
        this.writeQuotaAvailableBytes(mResp, item);
        this.writeQuotaUsedBytes(mResp, item);
        List<Property> itemProps = item.getProperties(null);
        if (itemProps != null) {
            for (Property p : itemProps) {
                mResp.writeProperty(p.getName(), p.getNamespace(), p.getValue());
            }
        }
        mResp.endProp();
        mResp.writeItemStatus(WebDavStatus.OK);
        mResp.endPropStat();
    }

    List<Property> writeProperties(MultistatusResponseWriter mResp, HierarchyItem item, Node propNode) throws XMLStreamException, DavException {
        List<Property> props;
        ArrayList<Property> notFoundProperties = new ArrayList<Property>();
        ArrayList<Property> unknownProperties = new ArrayList<Property>();
        for (Node n : new ChildIterable(propNode)) {
            if (n.getNodeType() != 1 || this.writeKnownDavProperty(mResp, item, n)) continue;
            unknownProperties.add(BasePropDavHandler.notFoundProp(n.getNamespaceURI(), n.getLocalName()));
        }
        if (unknownProperties.size() > 0 && (props = item.getProperties(unknownProperties.toArray(new Property[unknownProperties.size()]))) != null) {
            for (Property requiredProp : unknownProperties) {
                boolean found = false;
                for (Property p : props) {
                    if (!StringUtil.stringEquals(requiredProp.getNamespace(), p.getNamespace()) || !StringUtil.stringEquals(requiredProp.getName(), p.getName())) continue;
                    found = true;
                    if (p.getValue() != null) {
                        mResp.writeProperty(p.getName(), p.getNamespace(), p.getValue());
                        break;
                    }
                    notFoundProperties.add(p);
                    break;
                }
                if (found) continue;
                notFoundProperties.add(requiredProp);
            }
        }
        return notFoundProperties;
    }

    List<Property> getPropertyList(Node propNode) {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        for (Node n : new ChildIterable(propNode)) {
            if (n.getNodeType() != 1) continue;
            propertyList.add(BasePropDavHandler.notFoundProp(n.getNamespaceURI(), n.getLocalName()));
        }
        return propertyList;
    }

    void writeDavProperties(MultistatusResponseWriter mResp, HierarchyItem item, Node propNode) throws XMLStreamException, DavException {
        mResp.startPropStat();
        mResp.startProp();
        List<Property> notFoundProperties = this.writeProperties(mResp, item, propNode);
        mResp.endProp();
        mResp.writeItemStatus(WebDavStatus.OK);
        mResp.endPropStat();
        if (notFoundProperties.size() > 0) {
            mResp.startPropStat();
            mResp.startProp();
            for (Property p : notFoundProperties) {
                if (p.getValue() != null) continue;
                mResp.writeProperty(p.getName(), p.getNamespace(), "");
            }
            mResp.endProp();
            mResp.writeItemStatus(WebDavStatus.NOT_FOUND);
            mResp.endPropStat();
        }
    }

    private boolean writeKnownDavProperty(MultistatusResponseWriter mResp, HierarchyItem item, Node node) throws XMLStreamException, DavException {
        if (node.getNamespaceURI() == null || !node.getNamespaceURI().equals("DAV:")) {
            return false;
        }
        String localName = node.getLocalName();
        if (localName.equals("creationdate")) {
            return this.writeCreated(mResp, item);
        }
        if (localName.equals("displayname")) {
            return this.writeDisplayName(mResp, item);
        }
        if (localName.equals("getcontentlength")) {
            return this.writeContentLength(mResp, item);
        }
        if (localName.equals("getetag")) {
            return this.writeEtag(mResp, item);
        }
        if (localName.equals("getcontenttype")) {
            return this.writeContentType(mResp, item);
        }
        if (localName.equals("getlastmodified")) {
            return this.writeModified(mResp, item);
        }
        if (localName.equals("resourcetype")) {
            return this.writeResourceType(mResp, item);
        }
        if (localName.equals("supportedlock")) {
            return this.writeSupportedLock(mResp, item);
        }
        if (localName.equals("lockdiscovery")) {
            return this.writeLockDiscovery(mResp, item);
        }
        if (localName.equals("checked-in")) {
            return this.writeCheckedIn(mResp, item);
        }
        if (localName.equals("checked-out")) {
            return this.writeCheckedOut(mResp, item);
        }
        if (localName.equals("successor-set")) {
            return this.writeSuccessorSet(mResp, item);
        }
        if (localName.equals("predecessor-set")) {
            return this.writePredecessorSet(mResp, item);
        }
        if (localName.equals("checkout-set")) {
            return this.writeCheckoutSet(mResp, item);
        }
        if (localName.equals("creator-displayname")) {
            return this.writeCreatorDisplayname(mResp, item);
        }
        if (localName.equals("comment")) {
            return this.writeComment(mResp, item);
        }
        if (localName.equals("auto-version")) {
            return this.writeAutoVersion(mResp, item);
        }
        if (localName.equals("supported-report-set")) {
            return this.writeSupportedReportSet(mResp, item);
        }
        if (localName.equals("supported-method-set")) {
            return this.writeSupportedMethodSet(mResp, item);
        }
        if (localName.equals("supported-live-property-set")) {
            return this.writeSupportedLivePropertySet(mResp, item);
        }
        if (localName.equals("version-set")) {
            return this.writeVersionSet(mResp, item);
        }
        if (localName.equals("root-version")) {
            return this.writeRootVersion(mResp, item);
        }
        if (localName.equals("version-history")) {
            return this.writeVersionHistory(mResp, item);
        }
        if (localName.equals("version-name")) {
            return this.writeVersionName(mResp, item);
        }
        if (localName.equals("quota-available-bytes")) {
            return this.writeQuotaAvailableBytes(mResp, item);
        }
        if (localName.equals("quota-used-bytes")) {
            return this.writeQuotaUsedBytes(mResp, item);
        }
        return false;
    }

    void writePropertyNames(MultistatusResponseWriter mResp, HierarchyItem item) throws XMLStreamException, DavException {
        VersionableItem verItem;
        mResp.startPropStat();
        mResp.startProp();
        if (!(item instanceof Folder)) {
            mResp.writeEmptyProperty("getcontentlength", "DAV:");
            mResp.writeEmptyProperty("getcontenttype", "DAV:");
            mResp.writeEmptyProperty("getetag", "DAV:");
        }
        if (item instanceof DeltaVItem) {
            mResp.writeEmptyProperty("comment", "DAV:");
            mResp.writeEmptyProperty("creator-displayname", "DAV:");
        }
        VersionableItem versionableItem = verItem = item instanceof VersionableItem ? (VersionableItem)item : null;
        if (verItem != null && verItem.getVersionHistory() != null) {
            mResp.writeEmptyProperty("auto-version", "DAV:");
            if (verItem.isCheckedOut()) {
                mResp.writeEmptyProperty("checked-out", "DAV:");
                mResp.writeEmptyProperty("predecessor-set", "DAV:");
            } else {
                mResp.writeEmptyProperty("checked-in", "DAV:");
            }
        }
        mResp.writeEmptyProperty("displayname", "DAV:");
        mResp.writeEmptyProperty("resourcetype", "DAV:");
        mResp.writeEmptyProperty("creationdate", "DAV:");
        mResp.writeEmptyProperty("getlastmodified", "DAV:");
        mResp.writeEmptyProperty("supportedlock", "DAV:");
        mResp.writeEmptyProperty("lockdiscovery", "DAV:");
        mResp.writeEmptyProperty("supported-live-property-set", "DAV:");
        mResp.writeEmptyProperty("supported-method-set", "DAV:");
        mResp.writeEmptyProperty("supported-report-set", "DAV:");
        List<Property> itemProps = item.getProperties(null);
        if (itemProps != null) {
            for (Property p : itemProps) {
                if ("DAV:".equalsIgnoreCase(p.getNamespace())) {
                    mResp.writeEmptyProperty(p.getName(), p.getNamespace());
                    continue;
                }
                mResp.writeEmptyProperty(p.getName(), p.getNamespace(), "");
            }
        }
        mResp.endProp();
        mResp.writeItemStatus(WebDavStatus.OK);
        mResp.endPropStat();
    }

    private boolean writeCheckedIn(MultistatusResponseWriter mResp, HierarchyItem item) throws ServerException, XMLStreamException {
        VersionableItem verItem;
        VersionableItem versionableItem = verItem = item instanceof VersionableItem ? (VersionableItem)item : null;
        if (verItem == null || verItem.getVersionHistory() == null) {
            return false;
        }
        if (!verItem.isCheckedOut()) {
            XMLStreamWriter msWriter = mResp.startProperty("DAV:", "checked-in");
            mResp.writeItemHref(msWriter, IfHelper.getPath(IfHelper.getCurrenVersion(verItem.getVersionHistory())));
            mResp.endProperty();
            return true;
        }
        return false;
    }

    private boolean writeAutoVersion(MultistatusResponseWriter mResp, HierarchyItem item) throws ServerException, XMLStreamException {
        VersionableItem verItem;
        VersionableItem versionableItem = verItem = item instanceof VersionableItem ? (VersionableItem)item : null;
        if (verItem == null) {
            return false;
        }
        AutoVersion autoVersion = verItem.getAutoVersion();
        String value = "";
        if (autoVersion != AutoVersion.NoAutoVersioning) {
            if (autoVersion == AutoVersion.CheckOutCheckIn) {
                value = "checkout-checkin";
            } else if (autoVersion == AutoVersion.CheckOutUnlockedCheckIn) {
                value = "checkout-unlocked-checkin";
            } else if (autoVersion == AutoVersion.CheckOut) {
                value = "checkout";
            } else if (autoVersion == AutoVersion.LockedCheckOut) {
                value = "locked-checkout";
            }
        }
        XMLStreamWriter msWriter = mResp.startProperty("DAV:", "auto-version");
        if (value.length() > 0) {
            msWriter.writeEmptyElement("DAV:", value);
        }
        mResp.endProperty();
        return true;
    }

    private boolean writeSupportedReportSet(MultistatusResponseWriter mResp, HierarchyItem item) throws XMLStreamException {
        if (!(item instanceof VersionableItem || item instanceof Version || item instanceof History)) {
            return false;
        }
        XMLStreamWriter msWriter = mResp.startProperty("DAV:", "supported-report-set");
        msWriter.writeStartElement("DAV:", "supported-report");
        msWriter.writeStartElement("DAV:", "report");
        msWriter.writeEmptyElement("DAV:", "version-tree");
        if (item instanceof UploadProgress) {
            msWriter.writeEmptyElement("ithit", "upload-progress", "ithit");
        }
        msWriter.writeEndElement();
        msWriter.writeEndElement();
        mResp.endProperty();
        return true;
    }

    private boolean writeSupportedMethodSet(MultistatusResponseWriter mResp, HierarchyItem item) throws XMLStreamException {
        XMLStreamWriter msWriter = mResp.startProperty("DAV:", "supported-method-set");
        this.writeSupportedMethod(msWriter, "OPTIONS");
        this.writeSupportedMethod(msWriter, "HEAD");
        this.writeSupportedMethod(msWriter, "PROPFIND");
        if (!(item instanceof History)) {
            this.writeSupportedMethod(msWriter, "PROPPATCH");
            this.writeSupportedMethod(msWriter, "GET");
        }
        if (item instanceof Lock) {
            this.writeSupportedMethod(msWriter, "LOCK");
            this.writeSupportedMethod(msWriter, "UNLOCK");
        }
        if (item instanceof History || item instanceof Version) {
            this.writeSupportedMethod(msWriter, "REPORT");
            this.writeSupportedMethod(msWriter, "DELETE");
        } else {
            this.writeSupportedMethod(msWriter, "DELETE");
            this.writeSupportedMethod(msWriter, "MOVE");
            this.writeSupportedMethod(msWriter, "COPY");
            this.writeSupportedMethod(msWriter, "MKCOL");
            if (!(item instanceof Folder)) {
                this.writeSupportedMethod(msWriter, "PUT");
            }
        }
        if (item instanceof VersionableItem) {
            this.writeSupportedMethod(msWriter, "VERSION-CONTROL");
            this.writeSupportedMethod(msWriter, "REPORT");
            this.writeSupportedMethod(msWriter, "CHECKIN");
            this.writeSupportedMethod(msWriter, "CHECKOUT");
            this.writeSupportedMethod(msWriter, "UNCHECKOUT");
            this.writeSupportedMethod(msWriter, "UPDATE");
        }
        mResp.endProperty();
        return true;
    }

    private void writeSupportedMethod(XMLStreamWriter msWriter, String methodName) throws XMLStreamException {
        msWriter.writeStartElement("DAV:", "supported-method");
        msWriter.writeAttribute("name", methodName);
        msWriter.writeEndElement();
    }

    private boolean writeSupportedLivePropertySet(MultistatusResponseWriter mResp, HierarchyItem item) throws XMLStreamException {
        XMLStreamWriter msWriter = mResp.startProperty("DAV:", "supported-live-property-set");
        if (!(item instanceof History)) {
            this.writeSupportedLiveProperty(msWriter, "creationdate");
            this.writeSupportedLiveProperty(msWriter, "displayname");
            this.writeSupportedLiveProperty(msWriter, "resourcetype");
            this.writeSupportedLiveProperty(msWriter, "supported-live-property-set");
            this.writeSupportedLiveProperty(msWriter, "supported-method-set");
            this.writeSupportedLiveProperty(msWriter, "supported-report-set");
        }
        if (!(item instanceof Folder) && !(item instanceof History)) {
            this.writeSupportedLiveProperty(msWriter, "getcontentlength");
            this.writeSupportedLiveProperty(msWriter, "getcontenttype");
        }
        if (item instanceof DeltaVItem) {
            this.writeSupportedLiveProperty(msWriter, "comment");
            this.writeSupportedLiveProperty(msWriter, "creator-displayname");
        }
        if (item instanceof History) {
            this.writeSupportedLiveProperty(msWriter, "version-set");
            this.writeSupportedLiveProperty(msWriter, "root-version");
        } else if (item instanceof Version) {
            this.writeSupportedLiveProperty(msWriter, "predecessor-set");
            this.writeSupportedLiveProperty(msWriter, "successor-set");
            this.writeSupportedLiveProperty(msWriter, "version-name");
            this.writeSupportedLiveProperty(msWriter, "checkout-set");
            this.writeSupportedLiveProperty(msWriter, "version-history");
            this.writeSupportedLiveProperty(msWriter, "getetag");
        } else {
            this.writeSupportedLiveProperty(msWriter, "getlastmodified");
            this.writeSupportedLiveProperty(msWriter, "supportedlock");
            this.writeSupportedLiveProperty(msWriter, "lockdiscovery");
        }
        if (item instanceof VersionableItem) {
            this.writeSupportedLiveProperty(msWriter, "auto-version");
            this.writeSupportedLiveProperty(msWriter, "checked-in");
            this.writeSupportedLiveProperty(msWriter, "checked-out");
            this.writeSupportedLiveProperty(msWriter, "predecessor-set");
            this.writeSupportedLiveProperty(msWriter, "version-history");
        }
        mResp.endProperty();
        return true;
    }

    private void writeSupportedLiveProperty(XMLStreamWriter msWriter, String methodName) throws XMLStreamException {
        msWriter.writeStartElement("DAV:", "supported-live-property");
        msWriter.writeStartElement("DAV:", "prop");
        msWriter.writeEmptyElement("DAV:", methodName);
        msWriter.writeEndElement();
        msWriter.writeEndElement();
    }

    private boolean writeVersionSet(MultistatusResponseWriter mResp, HierarchyItem item) throws XMLStreamException, ServerException {
        History history;
        VersionableItem verItem = item instanceof VersionableItem ? (VersionableItem)item : null;
        History history2 = history = verItem != null ? verItem.getVersionHistory() : (History)item;
        if (history == null) {
            return false;
        }
        XMLStreamWriter msWriter = mResp.startProperty("DAV:", "version-set");
        List<? extends Version> versions = IfHelper.getVersionSet(history);
        for (Version version : versions) {
            mResp.writeItemHref(msWriter, IfHelper.getPath(version));
        }
        mResp.endProperty();
        return true;
    }

    private boolean writeRootVersion(MultistatusResponseWriter mResp, HierarchyItem item) throws ServerException, XMLStreamException {
        History history;
        History history2 = history = item instanceof History ? (History)item : null;
        if (history == null) {
            return false;
        }
        XMLStreamWriter msWriter = mResp.startProperty("DAV:", "root-version");
        mResp.writeItemHref(msWriter, IfHelper.getPath(IfHelper.getRootVersion(history)));
        mResp.endProperty();
        return true;
    }

    private boolean writeVersionHistory(MultistatusResponseWriter mResp, HierarchyItem item) throws ServerException, XMLStreamException {
        Version version;
        VersionableItem verItem = item instanceof VersionableItem ? (VersionableItem)item : null;
        Version version2 = version = item instanceof Version ? (Version)item : null;
        if (verItem == null && version == null) {
            return false;
        }
        if (version != null) {
            verItem = IfHelper.getVersionableItem(version);
        }
        XMLStreamWriter msWriter = mResp.startProperty("DAV:", "version-history");
        if (verItem.getVersionHistory() != null) {
            mResp.writeItemHref(msWriter, IfHelper.getPath(verItem.getVersionHistory()));
        }
        mResp.endProperty();
        return true;
    }

    private boolean writeResourceType(MultistatusResponseWriter mResp, HierarchyItem item) throws XMLStreamException {
        if (!(item instanceof File || item instanceof Folder || item instanceof History)) {
            return false;
        }
        XMLStreamWriter msWriter = mResp.startProperty("DAV:", "resourcetype");
        if (item instanceof Folder) {
            msWriter.writeEmptyElement("DAV:", "collection");
        }
        if (item instanceof History) {
            msWriter.writeEmptyElement("DAV:", "version-history");
        }
        mResp.endProperty();
        return true;
    }

    private boolean writeDisplayName(MultistatusResponseWriter mResp, HierarchyItem item) throws ServerException, XMLStreamException {
        mResp.writeProperty("displayname", "DAV:", IfHelper.getName(item));
        return true;
    }

    private boolean writeSupportedLock(MultistatusResponseWriter mResp, HierarchyItem item) throws XMLStreamException {
        if (!(item instanceof Lock)) {
            return false;
        }
        XMLStreamWriter msWriter = mResp.startProperty("DAV:", "supportedlock");
        msWriter.writeStartElement("DAV:", "lockentry");
        msWriter.writeStartElement("DAV:", "lockscope");
        msWriter.writeEmptyElement("DAV:", "exclusive");
        msWriter.writeEndElement();
        msWriter.writeStartElement("DAV:", "locktype");
        msWriter.writeEmptyElement("DAV:", "write");
        msWriter.writeEndElement();
        msWriter.writeEndElement();
        msWriter.writeStartElement("DAV:", "lockentry");
        msWriter.writeStartElement("DAV:", "lockscope");
        msWriter.writeEmptyElement("DAV:", "shared");
        msWriter.writeEndElement();
        msWriter.writeStartElement("DAV:", "locktype");
        msWriter.writeEmptyElement("DAV:", "write");
        msWriter.writeEndElement();
        msWriter.writeEndElement();
        mResp.endProperty();
        return true;
    }

    private boolean writeLockDiscovery(MultistatusResponseWriter mResp, HierarchyItem item) throws XMLStreamException, DavException {
        if (!(item instanceof Lock)) {
            return false;
        }
        Lock itemLock = (Lock)((Object)item);
        XMLStreamWriter sw = mResp.startProperty("DAV:", "lockdiscovery");
        List<LockInfo> activeLocks = itemLock.getActiveLocks();
        if (activeLocks != null) {
            for (LockInfo li : activeLocks) {
                BasePropDavHandler.writeLockInfo(sw, li);
            }
        }
        mResp.endProperty();
        return true;
    }

    protected static String getText(Node xmlNode) {
        String text = null;
        if (xmlNode != null && xmlNode.hasChildNodes() && xmlNode.getFirstChild() instanceof Text) {
            text = xmlNode.getFirstChild().getNodeValue();
        }
        if (StringUtil.isNullOrEmpty(text)) {
            return null;
        }
        return text;
    }
}

