/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.File;
import com.ithit.webdav.server.Folder;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Lock;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.deltav.AutoVersion;
import com.ithit.webdav.server.deltav.History;
import com.ithit.webdav.server.deltav.VersionableItem;
import com.ithit.webdav.server.exceptions.ConflictException;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.LockedException;
import com.ithit.webdav.server.exceptions.PreconditionFailedException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.handler.IfHelper;
import com.ithit.webdav.server.resumableupload.ResumableUpload;
import java.io.IOException;
import java.io.InputStream;

abstract class BaseUploadHandler
extends BaseDavHandler {
    public BaseUploadHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    private void checkLockCondition(HierarchyItem item) throws ServerException {
        if (item instanceof Lock) {
            Lock itemLock = (Lock)((Object)item);
            if (this.getRequest().getClientLockTokens().size() > 0 && !IfHelper.hasActiveLocks(itemLock)) {
                throw new ServerException(WebDavStatus.PRECONDITION_FAILED);
            }
        }
    }

    void processFileUpload(HierarchyItem item, UploadItemInfo itemInfo) throws DavException, IOException {
        History history;
        this.checkLockCondition(item);
        VersionableItem verItem = item instanceof VersionableItem ? (VersionableItem)item : null;
        History history2 = history = verItem == null ? null : verItem.getVersionHistory();
        if (item == null) {
            this.createNewFile(itemInfo);
            this.setStatus(WebDavStatus.CREATED);
        } else if (verItem != null && (this.getEngine().getAutoPutUnderVersionControl() || history != null)) {
            if (history == null) {
                verItem.putUnderVersionControl(true);
            }
            this.autoVersionLogic(verItem, itemInfo.getStream(), itemInfo.getContentLength(), itemInfo.getContentType());
            this.setStatus(WebDavStatus.OK);
        } else if (item instanceof File) {
            this.updateFileData((File)item, itemInfo.getStream(), itemInfo.getContentLength(), itemInfo.getContentType());
            this.setStatus(WebDavStatus.OK);
        } else {
            throw new ServerException(WebDavStatus.NOT_ALLOWED);
        }
    }

    private void autoPutUnderVersionControl(VersionableItem verItem) throws ServerException, LockedException {
        if (this.getEngine().getAutoPutUnderVersionControl() && verItem != null) {
            verItem.putUnderVersionControl(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void autoVersionLogic(VersionableItem verItem, InputStream inputStream, long length, String contentType) throws DavException, IOException {
        ResumableUpload resumableItem;
        File file = verItem instanceof File ? (File)((Object)verItem) : null;
        Lock itemLock = verItem instanceof Lock ? (Lock)((Object)verItem) : null;
        ResumableUpload resumableUpload = resumableItem = verItem instanceof ResumableUpload ? (ResumableUpload)((Object)verItem) : null;
        if (file == null) {
            throw new PreconditionFailedException();
        }
        boolean checkedOut = verItem.isCheckedOut();
        boolean autoCheckIn = false;
        AutoVersion autoVersionMode = verItem.getAutoVersion();
        if (autoVersionMode == AutoVersion.CheckOutCheckIn) {
            if (!checkedOut) {
                verItem.checkOut();
                verItem.setAutoCheckIn(false);
                if (resumableItem != null) {
                    resumableItem.setCheckInOnFileComplete(true);
                }
            }
            boolean fileComplete = this.updateFileData(file, inputStream, length, contentType);
            if (checkedOut && (!fileComplete || resumableItem == null || !resumableItem.getCheckInOnFileComplete())) return;
            verItem.checkIn();
            return;
        } else if (autoVersionMode == AutoVersion.CheckOutUnlockedCheckIn) {
            if (!checkedOut) {
                verItem.checkOut();
                verItem.setAutoCheckIn(true);
                if (resumableItem != null) {
                    resumableItem.setCheckInOnFileComplete(true);
                }
            }
            boolean fileComplete = this.updateFileData(file, inputStream, length, contentType);
            if (checkedOut && (!fileComplete || resumableItem == null || !resumableItem.getCheckInOnFileComplete()) || itemLock == null || IfHelper.hasActiveLocks(itemLock)) return;
            verItem.checkIn();
            return;
        } else if (autoVersionMode == AutoVersion.CheckOut) {
            if (!checkedOut) {
                verItem.checkOut();
                autoCheckIn = true;
            }
            this.updateFileData(file, inputStream, length, contentType);
            if (!autoCheckIn) return;
            verItem.setAutoCheckIn(true);
            return;
        } else if (autoVersionMode == AutoVersion.LockedCheckOut) {
            if (!checkedOut && itemLock != null && IfHelper.hasActiveLocks(itemLock)) {
                verItem.checkOut();
                autoCheckIn = true;
            }
            if (!verItem.isCheckedOut()) throw new ConflictException();
            boolean fileComplete = this.updateFileData(file, inputStream, length, contentType);
            if (!fileComplete || !autoCheckIn) return;
            verItem.setAutoCheckIn(autoCheckIn);
            return;
        } else {
            if (!checkedOut) {
                throw new ConflictException();
            }
            this.updateFileData(file, inputStream, length, contentType);
        }
    }

    private void createNewFile(UploadItemInfo itemInfo) throws DavException, IOException {
        Folder folder = itemInfo.getParent();
        String name = itemInfo.getName();
        BaseUploadHandler.requireParentExists(folder);
        File newFile = IfHelper.createFile(folder, name);
        this.updateContentAndPutUnderVersionControl(newFile, itemInfo.getStream(), itemInfo.getContentLength(), itemInfo.getContentType());
    }

    private void updateContentAndPutUnderVersionControl(File newFile, InputStream inputStream, long length, String contentType) throws ServerException, IOException, LockedException {
        boolean fileComplete;
        if (newFile != null && (fileComplete = this.updateFileData(newFile, inputStream, length, contentType)) && newFile instanceof VersionableItem) {
            this.autoPutUnderVersionControl((VersionableItem)((Object)newFile));
        }
    }

    protected abstract boolean updateFileData(File var1, InputStream var2, long var3, String var5) throws ServerException, IOException, LockedException;

    static interface UploadItemInfo {
        public Folder getParent() throws DavException;

        public String getName() throws ServerException;

        public File getItem() throws ServerException;

        public InputStream getStream();

        public long getContentLength();

        public String getContentType();
    }
}

