/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.deltav.AutoVersion;
import com.ithit.webdav.server.deltav.VersionableItem;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.resumableupload.ResumableUpload;
import java.io.IOException;

class CancelUploadHandler
extends BaseDavHandler {
    public CancelUploadHandler(Engine engine, Logger log) {
        super(engine, log);
    }

    @Override
    public void processRequest(DavRequest rt, DavResponse rs, HierarchyItem item) throws DavException, IOException {
        VersionableItem verItem;
        ResumableUpload resumableItem;
        super.processRequest(rt, rs, item);
        if (!this.processIfHeaders(item, WebDavStatus.PRECONDITION_FAILED)) {
            return;
        }
        if (!this.exists(item)) {
            return;
        }
        ResumableUpload resumableUpload = resumableItem = item instanceof ResumableUpload ? (ResumableUpload)((Object)item) : null;
        if (resumableItem == null) {
            throw new ServerException(WebDavStatus.CONFLICT);
        }
        resumableItem.cancelUpload();
        VersionableItem versionableItem = verItem = item instanceof VersionableItem ? (VersionableItem)item : null;
        if (verItem != null && verItem.getVersionHistory() != null) {
            AutoVersion autoVersionMode = verItem.getAutoVersion();
            if (autoVersionMode == AutoVersion.CheckOutCheckIn) {
                if (verItem.isCheckedOut() && resumableItem.getCheckInOnFileComplete()) {
                    verItem.unCheckOut();
                }
            } else if (autoVersionMode == AutoVersion.CheckOutUnlockedCheckIn) {
                if (verItem.isCheckedOut() && resumableItem.getCheckInOnFileComplete()) {
                    verItem.unCheckOut();
                }
            } else if (autoVersionMode == AutoVersion.CheckOut) {
                if (verItem.isCheckedOut() && verItem.getAutoCheckIn()) {
                    verItem.unCheckOut();
                }
            } else if (autoVersionMode == AutoVersion.LockedCheckOut && verItem.isCheckedOut() && verItem.getAutoCheckIn()) {
                verItem.unCheckOut();
            }
        }
        this.setStatus(WebDavStatus.OK);
    }
}

