/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.deltav.VersionableItem;
import com.ithit.webdav.server.exceptions.ConflictException;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.resumableupload.ResumableUpload;
import java.io.IOException;

class CheckoutHandler
extends BaseDavHandler {
    public CheckoutHandler(Engine engine, Logger log) {
        super(engine, log);
    }

    @Override
    public void processRequest(DavRequest rt, DavResponse rs, HierarchyItem item) throws DavException, IOException {
        VersionableItem verItem;
        super.processRequest(rt, rs, item);
        if (!this.processIfHeaders(item, WebDavStatus.PRECONDITION_FAILED)) {
            return;
        }
        if (!this.exists(item)) {
            return;
        }
        VersionableItem versionableItem = verItem = item instanceof VersionableItem ? (VersionableItem)item : null;
        if (verItem == null || verItem.getVersionHistory() == null) {
            throw new ServerException(WebDavStatus.CONFLICT);
        }
        if (!verItem.isCheckedOut()) {
            verItem.checkOut();
            verItem.setAutoCheckIn(false);
            if (verItem instanceof ResumableUpload) {
                ((ResumableUpload)((Object)verItem)).setCheckInOnFileComplete(false);
            }
        } else {
            throw new ConflictException("", "DAV:", "must-be-checked-in");
        }
        this.addHeader("Cache-Control", "no-cache");
        this.setStatus(WebDavStatus.OK);
    }
}

