/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.Folder;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.util.URIUtil;
import java.io.IOException;

class CopyHandler
extends BaseDavHandler {
    public CopyHandler(Engine engine, Logger log) {
        super(engine, log);
    }

    @Override
    public void processRequest(DavRequest rt, DavResponse rs, HierarchyItem srcItem) throws DavException, IOException {
        super.processRequest(rt, rs, srcItem);
        if (URIUtil.uriEquals(this.getRequestPath(), this.getDestination())) {
            throw new ServerException(WebDavStatus.FORBIDDEN);
        }
        if (!this.processIfHeaders(srcItem, WebDavStatus.PRECONDITION_FAILED)) {
            return;
        }
        if (!this.exists(srcItem)) {
            return;
        }
        String dstPath = this.getDestination();
        String dstName = this.getName(dstPath);
        Folder dstParent = this.getParent(dstPath);
        if (dstParent == null) {
            throw new ServerException(WebDavStatus.CONFLICT);
        }
        HierarchyItem dstItem = this.getEngine().getHierarchyItem(dstPath);
        if (dstItem != null) {
            this.requireOverwrite();
        }
        srcItem.copyTo(dstParent, dstName, this.getDepth() == null || this.getDepth().toLowerCase().equals("infinity"));
        this.setStatus(WebDavStatus.CREATED);
    }
}

