/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.deltav.History;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.handler.IfHelper;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import java.io.IOException;

class DeleteHandler
extends BaseDavHandler {
    protected DeleteHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    @Override
    public void processRequest(DavRequest request, DavResponse response, HierarchyItem item) throws DavException, IOException {
        super.processRequest(request, response, item);
        if (!this.processIfHeaders(item, WebDavStatus.PRECONDITION_FAILED)) {
            return;
        }
        if (!this.exists(item)) {
            return;
        }
        if (item instanceof History) {
            History versionHistory = (History)item;
            IfHelper.getVersionableItem(IfHelper.getCurrenVersion(versionHistory)).putUnderVersionControl(false);
        } else {
            item.delete();
        }
        this.getResponse().setContentLength(0L);
        this.setStatus(WebDavStatus.OK);
    }
}

