/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.File;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.util.StringUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

class GetHandler
extends BaseDavHandler {
    public static final String HTTP_DATE = "EEE, dd MMM yyyy HH:mm:ss zzz";

    public GetHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    @Override
    public void processRequest(DavRequest request, DavResponse response, HierarchyItem item) throws IOException, DavException {
        String contentType;
        super.processRequest(request, response, item);
        boolean returnBody = this.processIfHeaders(item, WebDavStatus.NOT_MODIFIED);
        if (!this.exists(item)) {
            return;
        }
        if (!(item instanceof File)) {
            throw new ServerException(WebDavStatus.METHOD_NOT_ALLOWED);
        }
        File res = (File)item;
        long contentLength = res.getContentLength();
        long byteStart = 0L;
        long byteEnd = contentLength - 1L;
        SimpleDateFormat sdf = new SimpleDateFormat(HTTP_DATE, Locale.ENGLISH);
        if (request.getHeader("If-Modified-Since") != null) {
            try {
                String modified = request.getHeader("If-Modified-Since");
                Date ifModified = sdf.parse(modified);
                GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                calendar.setTimeInMillis(res.getModified());
                calendar.clear(14);
                long resModified = calendar.getTimeInMillis();
                if (resModified <= ifModified.getTime()) {
                    returnBody = false;
                }
            }
            catch (ParseException ex) {
                this.getLogger().logError("Failed to parse if modified", ex);
            }
        }
        if (request.getHeader("Range") != null) {
            String rangeFull = request.getHeader("Range");
            String[] range = rangeFull.split("=");
            if (range.length == 2) {
                rangeFull = range[1].trim();
                if ((range = rangeFull.split("-")).length == 1 || range.length == 2) {
                    long rangeByteStart = -1L;
                    try {
                        rangeByteStart = Integer.decode(range[0]).intValue();
                    }
                    catch (NumberFormatException ex) {
                        this.getLogger().logError("Failed to parse range.", ex);
                    }
                    if (rangeByteStart >= 0L && rangeByteStart < contentLength) {
                        byteStart = rangeByteStart;
                    }
                }
                if (range.length == 2) {
                    long rangeByteEnd = -1L;
                    try {
                        rangeByteEnd = Integer.decode(range[1]).intValue();
                    }
                    catch (NumberFormatException ex) {
                        this.getLogger().logError("Failed to parse range.", ex);
                    }
                    if (rangeByteEnd >= 0L && rangeByteEnd < contentLength) {
                        byteEnd = rangeByteEnd;
                    }
                }
            }
            String ifRange = request.getHeader("If-Range");
            boolean isIfRangeMatches = true;
            if (!StringUtil.isNullOrEmpty(ifRange)) {
                Date ifRangeDate = null;
                try {
                    ifRangeDate = sdf.parse(ifRange);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (ifRangeDate != null) {
                    GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                    calendar.setTimeInMillis(res.getModified());
                    calendar.clear(14);
                    long resModified = calendar.getTimeInMillis();
                    if (resModified > ifRangeDate.getTime()) {
                        isIfRangeMatches = false;
                    }
                } else {
                    isIfRangeMatches = this.ifMatches(item, ifRange);
                }
                if (!isIfRangeMatches) {
                    byteStart = 0L;
                    byteEnd = contentLength - 1L;
                }
            }
            if (byteStart >= contentLength && contentLength > 0L) {
                this.setStatus(new WebDavStatus(416, "Requested Range Not Satisfiable"));
                returnBody = false;
            }
        }
        boolean calculateContentLength = this.getEngine().getCalculateContentLength();
        if (returnBody && calculateContentLength) {
            long cl = byteEnd + 1L - byteStart;
            response.setContentLength(cl);
        }
        this.addHeader("Accept-Ranges", "bytes");
        if (returnBody) {
            if (byteStart == 0L && byteEnd + 1L == contentLength) {
                this.setStatus(WebDavStatus.OK);
            } else {
                this.addHeader("Content-Range", "bytes " + byteStart + "-" + byteEnd + "/" + contentLength);
                this.setStatus(WebDavStatus.PARTIAL_CONTENT);
            }
        }
        if ((contentType = res.getContentType()) != null) {
            response.setContentType(contentType);
        }
        this.addHeader("Last-Modified", this.toRfc1123(res.getModified()));
        if (res.getEtag() != null) {
            this.addHeader("ETag", "\"" + res.getEtag() + "\"");
        }
        if (returnBody && contentLength > 0L) {
            res.read(this.getResponse().getOutputStream(), byteStart, byteEnd - byteStart + 1L);
        }
    }

    @Override
    public boolean getLogOutput() {
        return false;
    }

    @Override
    public boolean getCalculateContentLength() {
        return false;
    }

    private String toRfc1123(long modified) {
        String DATE_FORMAT = HTTP_DATE;
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(modified);
    }
}

