/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.File;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import java.io.IOException;

class HeadHandler
extends BaseDavHandler {
    public HeadHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    @Override
    public boolean getCalculateContentLength() {
        return false;
    }

    @Override
    public void processRequest(DavRequest rt, DavResponse rs, HierarchyItem item) throws IOException, DavException {
        super.processRequest(rt, rs, item);
        boolean returnBody = this.processIfHeaders(item, WebDavStatus.PRECONDITION_FAILED);
        if (!this.exists(item)) {
            return;
        }
        if (returnBody) {
            this.setStatus(WebDavStatus.OK);
        }
        if (!(item instanceof File)) {
            throw new ServerException(WebDavStatus.METHOD_NOT_ALLOWED);
        }
        File res = (File)item;
        String contentType = res.getContentType();
        if (contentType != null) {
            this.getResponse().setContentType(contentType);
        }
        this.addHeader("Last-Modified", this.formatModified(res.getModified()));
        if (res.getEtag() != null) {
            this.addHeader("ETag", "\"" + res.getEtag() + "\"");
        }
        this.getResponse().setContentLength(res.getContentLength());
    }
}

