/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.File;
import com.ithit.webdav.server.Folder;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Lock;
import com.ithit.webdav.server.LockInfo;
import com.ithit.webdav.server.LockResult;
import com.ithit.webdav.server.Property;
import com.ithit.webdav.server.RefreshLockResult;
import com.ithit.webdav.server.deltav.History;
import com.ithit.webdav.server.deltav.Version;
import com.ithit.webdav.server.deltav.VersionableItem;
import com.ithit.webdav.server.exceptions.LockedException;
import com.ithit.webdav.server.exceptions.MultistatusException;
import com.ithit.webdav.server.exceptions.PreconditionFailedException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.paging.OrderProperty;
import com.ithit.webdav.server.paging.PageResults;
import java.util.List;

public class IfHelper {
    public static String getPath(HierarchyItem item) throws ServerException {
        String path = item.getPath();
        if (path == null) {
            throw new ServerException("HierarchyItem.getPath() implementation returned null wich shall not happen");
        }
        return path;
    }

    public static PageResults getChildren(Folder folder, List<Property> propNames, Long offset, Long nResults, List<OrderProperty> orderProps) throws ServerException {
        PageResults children = folder.getChildren(propNames, offset, nResults, orderProps);
        if (children == null) {
            throw new ServerException("Folder.getChildren() implementation returned null, wich shall not happen.");
        }
        return children;
    }

    public static File createFile(Folder folder, String name) throws ServerException, LockedException {
        File newFile = folder.createFile(name);
        if (newFile == null) {
            throw new ServerException("Folder.createFile implementation returned null, wich shall not happen.");
        }
        return newFile;
    }

    public static String getName(HierarchyItem item) throws ServerException {
        String name = item.getName();
        if (name == null) {
            throw new ServerException("HierarchyItem.getName() implementation returned null, wich shall not happen.");
        }
        return name;
    }

    public static boolean hasActiveLocks(Lock itemLock) throws ServerException {
        List<LockInfo> locks = itemLock.getActiveLocks();
        return locks != null && locks.size() > 0;
    }

    public static LockResult lock(Lock itemLock, boolean shared, boolean deep, long timeout, String owner) throws ServerException, MultistatusException, LockedException {
        LockResult lr = itemLock.lock(shared, deep, timeout, owner);
        if (lr == null) {
            throw new ServerException("Lock.lock() implementation returned null, wich shall not happen.");
        }
        return lr;
    }

    public static RefreshLockResult refreshLock(Lock itemLock, String token, long timeout) throws ServerException, MultistatusException, LockedException, PreconditionFailedException {
        RefreshLockResult result = itemLock.refreshLock(token, timeout);
        if (result == null) {
            throw new ServerException("Lock.refhreshLock() implementation returned null, wich shall not happen.");
        }
        return result;
    }

    public static Version getCurrenVersion(History versionHistory) throws ServerException {
        Version version = versionHistory.getCurrentVersion();
        if (version == null) {
            throw new ServerException("Version.getCurrentVersion() implementation returned null, wich shall not happen.");
        }
        return version;
    }

    public static List<? extends Version> getVersionSet(History history) throws ServerException {
        List<? extends Version> versions = history.getVersionSet();
        if (versions == null) {
            throw new ServerException("History.getVersionSet() implementation returned null, wich shall not happen.");
        }
        return versions;
    }

    public static Version getRootVersion(History history) throws ServerException {
        Version rootVersion = history.getRootVersion();
        if (rootVersion == null) {
            throw new ServerException("History.getRootVersion() implementation returned null, wich shall not happen.");
        }
        return rootVersion;
    }

    public static VersionableItem getVersionableItem(Version version) throws ServerException {
        VersionableItem versionableItem = version.getVersionableItem();
        if (versionableItem == null) {
            throw new ServerException("Version.getVersionableItem() implementation returned null, wich shall not happen.");
        }
        return versionableItem;
    }

    public static String getVersionName(Version version) throws ServerException {
        String name = version.getVersionName();
        if (name == null || name.length() == 0) {
            throw new ServerException("Version.getName() implementation returned null or empty string, wich shall not happen.");
        }
        return name;
    }
}

