/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.File;
import com.ithit.webdav.server.Folder;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Lock;
import com.ithit.webdav.server.LockInfo;
import com.ithit.webdav.server.LockResult;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.Property;
import com.ithit.webdav.server.RefreshLockResult;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.LockedException;
import com.ithit.webdav.server.exceptions.MultistatusException;
import com.ithit.webdav.server.exceptions.PreconditionFailedException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.handler.IfHelper;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.util.ResponseUtil;
import java.io.IOException;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class LockHandler
extends BaseDavHandler {
    public LockHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    @Override
    public void processRequest(DavRequest rt, DavResponse rs, HierarchyItem item) throws IOException, DavException {
        super.processRequest(rt, rs, item);
        if (!this.processIfHeaders(item, WebDavStatus.PRECONDITION_FAILED)) {
            return;
        }
        LockInfo lockInfo = this.getLockInfo();
        try {
            if (lockInfo == null) {
                if (!this.exists(item)) {
                    return;
                }
                lockInfo = this.refreshLock(item);
            } else {
                if (item == null) {
                    this.createLockedItem(lockInfo);
                } else {
                    this.lockExistingItem(item, lockInfo);
                }
                this.addHeader("Lock-Token", "<opaquelocktoken:" + lockInfo.getToken() + ">");
            }
        }
        catch (MultistatusException ex) {
            String itemHref = this.getRequestPathAndQueryString();
            Property prop = new Property("DAV:", "lockdiscovery", "");
            ex.addResponse(itemHref, prop, WebDavStatus.FAILED_DEPENDENCY);
            throw ex;
        }
        this.writeLockDiscoveryResponse(lockInfo);
    }

    private void writeLockDiscoveryResponse(LockInfo lockInfo) throws IOException, ServerException {
        try {
            XMLStreamWriter msWriter = ResponseUtil.createXmlResponse(this.getResponse(), this.getEngine().getResponseCharacterEncoding());
            msWriter.writeStartDocument();
            msWriter.setPrefix("d", "DAV:");
            msWriter.writeStartElement("DAV:", "prop");
            msWriter.writeNamespace("d", "DAV:");
            msWriter.writeStartElement("DAV:", "lockdiscovery");
            LockHandler.writeLockInfo(msWriter, lockInfo);
            msWriter.writeEndElement();
            msWriter.writeEndElement();
            msWriter.writeEndDocument();
            msWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new ServerException(e);
        }
    }

    private void lockExistingItem(HierarchyItem item, LockInfo lockInfo) throws ServerException, MultistatusException, LockedException {
        Lock itemLock;
        Lock lock = itemLock = item instanceof Lock ? (Lock)((Object)item) : null;
        if (itemLock == null) {
            throw new ServerException(WebDavStatus.METHOD_NOT_ALLOWED);
        }
        LockResult result = IfHelper.lock(itemLock, lockInfo.isShared(), lockInfo.isDeep(), lockInfo.getTimeout(), lockInfo.getOwner());
        lockInfo.setToken(result.getToken());
        lockInfo.setTimeout(result.getTimeout());
        this.setStatus(WebDavStatus.OK);
    }

    private void createLockedItem(LockInfo lockInfo) throws DavException {
        Lock itemLock;
        String name = this.getName(this.getRequestPath());
        Folder parent = this.getParent(this.getRequestPath());
        LockHandler.requireParentExists(parent);
        File file = IfHelper.createFile(parent, name);
        Lock lock = itemLock = file instanceof Lock ? (Lock)((Object)file) : null;
        if (itemLock == null) {
            throw new ServerException("File created doesn't implement Lock interface");
        }
        LockResult lockResult = IfHelper.lock(itemLock, lockInfo.isShared(), lockInfo.isDeep(), lockInfo.getTimeout(), lockInfo.getOwner());
        lockInfo.setToken(lockResult.getToken());
        lockInfo.setTimeout(lockResult.getTimeout());
        this.setStatus(WebDavStatus.CREATED);
    }

    private LockInfo refreshLock(HierarchyItem item) throws ServerException, MultistatusException, LockedException, PreconditionFailedException {
        Lock itemLock;
        LockInfo lockInfo = new LockInfo();
        Lock lock = itemLock = item instanceof Lock ? (Lock)((Object)item) : null;
        if (itemLock == null) {
            throw new ServerException(WebDavStatus.METHOD_NOT_ALLOWED);
        }
        List<String> tokens = this.getRequest().getClientLockTokens();
        if (tokens.size() == 0) {
            throw new ServerException(WebDavStatus.METHOD_NOT_ALLOWED);
        }
        lockInfo.setToken(tokens.get(0));
        RefreshLockResult result = IfHelper.refreshLock(itemLock, lockInfo.getToken(), this.getTimeout());
        lockInfo.setTimeout(result.getTimeout());
        lockInfo.setShared(result.isShared());
        lockInfo.setDeep(result.isDeep());
        lockInfo.setOwner(result.getOwner());
        this.setStatus(WebDavStatus.OK);
        return lockInfo;
    }

    private LockInfo getLockInfo() throws ServerException, IOException {
        LockInfo lockInfo = new LockInfo();
        Document lockRequest = this.initializeRequestDocumentAndMngr();
        if (lockRequest == null) {
            return null;
        }
        Node node = this.selectNode(lockRequest, "/d:lockinfo/d:lockscope/d:shared");
        if (node != null) {
            lockInfo.setShared(true);
        } else {
            node = this.selectNode(lockRequest, "/d:lockinfo/d:lockscope/d:exclusive");
            if (node == null) {
                throw new ServerException(WebDavStatus.BAD_REQUEST);
            }
            lockInfo.setShared(false);
        }
        if ("0".equals(this.getDepth())) {
            lockInfo.setDeep(false);
        } else if (this.getDepth() == null || this.getDepth().toLowerCase().equals("infinity")) {
            lockInfo.setDeep(true);
        } else {
            throw new ServerException(WebDavStatus.BAD_REQUEST);
        }
        lockInfo.setTimeout(this.getTimeout());
        lockInfo.setToken(null);
        node = this.selectNode(lockRequest, "/d:lockinfo/d:owner");
        if (node != null) {
            lockInfo.setOwner(node.getTextContent());
        } else {
            lockInfo.setOwner("");
        }
        return lockInfo;
    }

    private long getTimeout() {
        if (this.getRequest().getHeader("Timeout") == null) {
            return -1L;
        }
        String timestr = this.getRequest().getHeader("Timeout").toLowerCase();
        String[] time = timestr.split(",");
        boolean found = false;
        for (String s : time) {
            if (!s.contains("second-")) continue;
            String[] temp = s.split("-");
            timestr = temp[1].trim();
            found = true;
            break;
        }
        return found ? Long.parseLong(timestr) : -1L;
    }
}

