/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.Folder;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import java.io.IOException;
import java.io.InputStream;

class MkcolHandler
extends BaseDavHandler {
    public MkcolHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    @Override
    public void processRequest(DavRequest rt, DavResponse rs, HierarchyItem item) throws IOException, DavException {
        super.processRequest(rt, rs, item);
        InputStream stream = this.getRequest().getInputStream();
        if (stream.read(new byte[1], 0, 1) > 0) {
            stream.close();
            throw new ServerException(WebDavStatus.UNSUPPORTED_MEDIA_TYPE);
        }
        stream.close();
        if (item != null) {
            throw new ServerException(WebDavStatus.NOT_ALLOWED);
        }
        String name = this.getName(this.getRequestPath());
        Folder parent = this.getParent(this.getRequestPath());
        MkcolHandler.requireParentExists(parent);
        parent.createFolder(name);
        this.setStatus(WebDavStatus.CREATED);
    }
}

