/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.Folder;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.util.URIUtil;
import java.io.IOException;

class MoveHandler
extends BaseDavHandler {
    public MoveHandler(Engine engine, Logger log) {
        super(engine, log);
    }

    @Override
    public void processRequest(DavRequest rt, DavResponse rs, HierarchyItem srcItem) throws DavException, IOException {
        super.processRequest(rt, rs, srcItem);
        if (URIUtil.uriEquals(this.getDestination(), this.getRequestPath())) {
            throw new ServerException(WebDavStatus.FORBIDDEN);
        }
        if (!this.processIfHeaders(srcItem, WebDavStatus.PRECONDITION_FAILED)) {
            return;
        }
        if (!this.exists(srcItem)) {
            return;
        }
        String dstPath = this.getDestination();
        Folder dstParent = this.getParent(dstPath);
        String dstName = this.getName(dstPath);
        HierarchyItem dstItem = this.getEngine().getHierarchyItem(dstPath);
        if (dstItem != null) {
            this.requireOverwrite();
        }
        srcItem.moveTo(dstParent, dstName);
        this.setStatus(WebDavStatus.CREATED);
    }
}

