/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Property;
import com.ithit.webdav.server.exceptions.ItemResponse;
import com.ithit.webdav.server.exceptions.PropStat;
import com.ithit.webdav.server.exceptions.PropStatResponse;
import com.ithit.webdav.server.exceptions.Response;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.XmlUtil;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.http.FilteredDavResponse;
import com.ithit.webdav.server.util.RequestUtil;
import com.ithit.webdav.server.util.ResponseUtil;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class MultistatusResponseWriter {
    private static final String nsDav = "DAV:";
    private DavResponse response;
    private DavRequest request;
    private XMLStreamWriter msWriter;
    private String charset;

    public MultistatusResponseWriter(DavRequest request, DavResponse response, String charset) {
        this.response = response;
        this.request = request;
        this.charset = charset;
    }

    public void startMultiStatusResponse() throws XMLStreamException, IOException {
        this.startMultiStatusResponse(false);
    }

    public void startMultiStatusResponse(boolean includePagingNamespace) throws XMLStreamException, IOException {
        this.response.setStatus(207, "Multi-Status");
        this.msWriter = ResponseUtil.createXmlResponse(this.response, this.charset);
        this.msWriter.writeStartDocument();
        this.msWriter.setPrefix("d", nsDav);
        this.msWriter.writeStartElement(nsDav, "multistatus");
        this.msWriter.writeNamespace("d", nsDav);
        if (includePagingNamespace) {
            this.msWriter.writeAttribute("xmlns", "", "ithitp", "https://www.ithit.com/pagingschema/");
        }
    }

    public void endMultiStatusResponse() throws XMLStreamException, IOException {
        FilteredDavResponse filteredResponse;
        this.msWriter.writeEndElement();
        this.msWriter.writeEndDocument();
        if (this.response instanceof FilteredDavResponse && (filteredResponse = (FilteredDavResponse)this.response).isCalcContentLength()) {
            int length = (int)filteredResponse.geFilteredDavOutputStream().getContentLength();
            filteredResponse.setContentLength(length);
        }
        this.msWriter.flush();
    }

    public void startResponse(String path) throws XMLStreamException, ServerException {
        this.msWriter.writeStartElement(nsDav, "response");
        this.writeItemHref(this.msWriter, path);
    }

    public void endResponse() throws XMLStreamException {
        this.msWriter.writeEndElement();
    }

    public void addStatusResponse(Response r) throws XMLStreamException, IOException, ServerException {
        this.startResponse(r.getItemPath());
        if (r instanceof PropStatResponse) {
            for (PropStat propStat : ((PropStatResponse)r).getPropStats()) {
                this.msWriter.writeStartElement(nsDav, "propstat");
                this.msWriter.writeStartElement(nsDav, "prop");
                for (Property prop : propStat.getProperties()) {
                    XmlUtil.writeElementString(this.msWriter, prop.getName(), prop.getNamespace(), "");
                }
                this.msWriter.writeEndElement();
                XmlUtil.writeElementString(this.msWriter, "status", nsDav, propStat.getStatus().getHttpString());
                this.msWriter.writeEndElement();
            }
        } else {
            WebDavStatus status = ((ItemResponse)r).getStatus();
            XmlUtil.writeElementString(this.msWriter, "status", nsDav, status.getHttpString());
        }
        if (r.getResponseDescription() != null && r.getResponseDescription().length() > 0) {
            XmlUtil.writeElementString(this.msWriter, "responsedescription", nsDav, r.getResponseDescription());
        }
        this.endResponse();
    }

    public void writeItemHref(XMLStreamWriter msWriter, String path) throws XMLStreamException, ServerException {
        String itemHref = RequestUtil.createUrl(path, this.request);
        msWriter.writeStartElement("d", "href", nsDav);
        msWriter.writeCharacters(itemHref);
        msWriter.writeEndElement();
    }

    public void startPropStat() throws XMLStreamException {
        this.msWriter.writeStartElement(nsDav, "propstat");
    }

    public void writeItemStatus(WebDavStatus status) throws XMLStreamException {
        XmlUtil.writeElementString(this.msWriter, "status", nsDav, status.getHttpString());
    }

    public void endPropStat() throws XMLStreamException {
        this.msWriter.writeEndElement();
    }

    public void startProp() throws XMLStreamException {
        this.msWriter.writeStartElement(nsDav, "prop");
    }

    public void endProp() throws XMLStreamException {
        this.msWriter.writeEndElement();
    }

    public void writeProperty(String name, String namespace, String value) throws XMLStreamException {
        XmlUtil.writeElementString(this.msWriter, name, namespace, value);
    }

    public void writePropertyWithPrefix(String prefix, String name, String namespace, String value) throws XMLStreamException {
        XmlUtil.writeElementStringWithPrefix(this.msWriter, prefix, name, namespace, value);
    }

    public void writeEmptyProperty(String name, String namespace) throws XMLStreamException {
        this.msWriter.writeEmptyElement(namespace, name);
    }

    public void writeEmptyProperty(String name, String namespace, String prefix) throws XMLStreamException {
        this.msWriter.writeEmptyElement(prefix, name, namespace);
    }

    public XMLStreamWriter startProperty(String namespace, String name) throws XMLStreamException {
        this.msWriter.writeStartElement(namespace, name);
        return this.msWriter;
    }

    public void endProperty() throws XMLStreamException {
        this.msWriter.writeEndElement();
    }
}

