/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.File;
import com.ithit.webdav.server.Folder;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Lock;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.deltav.History;
import com.ithit.webdav.server.deltav.Version;
import com.ithit.webdav.server.deltav.VersionableItem;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.resumableupload.ResumableUploadBase;
import com.ithit.webdav.server.search.Search;
import java.io.IOException;

final class OptionsHandler
extends BaseDavHandler {
    public OptionsHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    @Override
    public void processRequest(DavRequest request, DavResponse response, HierarchyItem item) throws DavException, IOException {
        super.processRequest(request, response, item);
        StringBuilder allowHeader = new StringBuilder();
        StringBuilder davHeader = new StringBuilder();
        if (item != null) {
            if (item instanceof Version) {
                davHeader.append("1, 2, 3, version-control");
                allowHeader.append("OPTIONS, PROPFIND, PROPPATCH, GET, HEAD, REPORT");
            } else if (item instanceof History) {
                davHeader.append("1, 2, 3, version-history");
                allowHeader.append("OPTIONS, PROPFIND, DELETE, HEAD, REPORT");
            } else {
                allowHeader.append("OPTIONS, PROPFIND, PROPPATCH, COPY, MOVE, DELETE");
            }
            if (item instanceof File && !(item instanceof Version)) {
                allowHeader.append(", GET, HEAD, PUT");
            } else if (item instanceof Folder) {
                allowHeader.append(", MKCOL");
            }
            if (item instanceof Lock) {
                allowHeader.append(", LOCK, UNLOCK");
                davHeader.append("1, 2, 3");
            } else if (!(item instanceof Version) && !(item instanceof History)) {
                davHeader.append("1, 3");
            }
            if (item instanceof Search) {
                allowHeader.append(", SEARCH");
                this.addHeader("DASL", "<DAV:basicsearch>");
            }
            if (item instanceof VersionableItem) {
                VersionableItem versionable = (VersionableItem)item;
                davHeader.append(", version-control");
                allowHeader.append(", VERSION-CONTROL");
                if (versionable.getVersionHistory() != null) {
                    davHeader.append(", checkout-in-place, version-history");
                    allowHeader.append(", CHECKIN, CHECKOUT, UNCHECKOUT, REPORT");
                    if (!versionable.isCheckedOut()) {
                        allowHeader.append(", UPDATE");
                        davHeader.append(", update");
                    }
                }
            }
            if (item instanceof ResumableUploadBase) {
                davHeader.append(", resumable-upload");
            }
            if (item instanceof Folder) {
                davHeader.append(", paging");
            }
        } else {
            Folder parent = this.getParent(this.getRequestPath());
            if (parent != null) {
                allowHeader.append("OPTIONS, GET, HEAD, PUT, MKCOL, PROPFIND");
                if (parent instanceof Lock) {
                    allowHeader.append(", LOCK");
                    davHeader.append("1, 2, 3");
                } else {
                    davHeader.append("1, 3");
                }
            } else {
                item = this.getEngine().getHierarchyItem("/");
                davHeader.append(item instanceof Lock ? "1, 2, 3" : "1, 3");
            }
        }
        this.addHeader("DAV", davHeader.toString());
        this.addHeader("Allow", allowHeader.toString());
        this.addHeader("Public", allowHeader.toString());
        this.addHeader("Accept-Ranges", "bytes");
        this.addHeader("MS-Author-Via", "DAV");
        this.setStatus(WebDavStatus.OK);
    }
}

