/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.File;
import com.ithit.webdav.server.Folder;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.ItemResponse;
import com.ithit.webdav.server.exceptions.LockedException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseUploadHandler;
import com.ithit.webdav.server.handler.MultistatusResponseWriter;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.resumableupload.PostReader;
import com.ithit.webdav.server.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;

class PostHandler
extends BaseUploadHandler {
    public PostHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    @Override
    public boolean getLogInput() {
        return false;
    }

    @Override
    public void processRequest(DavRequest request, DavResponse response, HierarchyItem item) throws DavException, IOException {
        super.processRequest(request, response, item);
        if (!this.processIfHeaders(item, WebDavStatus.PRECONDITION_FAILED)) {
            return;
        }
        if (PostHandler.isMultipart(request)) {
            response.setContentType("text/html");
            this.processMultipartRequest(item);
        }
        this.setStatus(WebDavStatus.OK);
    }

    private void processMultipartRequest(HierarchyItem item) throws IOException, DavException {
        String contentEncoding = this.getRequest().getHeader("Content-Encoding");
        PostReader postReader = new PostReader(this.getRequest().getInputStream(), PostHandler.getBoundary(this.getRequest()), StringUtil.isNullOrEmpty(contentEncoding) ? "UTF8" : contentEncoding, this.getRequest().getContentLength());
        while (postReader.moveNext()) {
            if (!postReader.isFile()) continue;
            this.processPostFile(item, postReader);
        }
        MultistatusResponseWriter sw = new MultistatusResponseWriter(this.getRequest(), this.getResponse(), this.getEngine().getResponseCharacterEncoding());
        try {
            sw.startMultiStatusResponse();
            sw.addStatusResponse(new ItemResponse(this.getRequestPathAndQueryString(), WebDavStatus.OK, null, null));
            sw.endMultiStatusResponse();
        }
        catch (XMLStreamException e) {
            throw new ServerException(e);
        }
    }

    private void processPostFile(HierarchyItem item, PostReader postReader) throws IOException, DavException {
        String fileName;
        Folder folder;
        if (item instanceof Folder) {
            folder = (Folder)item;
            fileName = PostHandler.getFileName(postReader.getFileName());
        } else {
            folder = this.getParent(this.getRequestPath());
            fileName = this.getName(this.getRequestPath());
        }
        if (StringUtil.isNullOrEmpty(fileName)) {
            return;
        }
        ItemInfo itemInfo = new ItemInfo(folder, fileName, this.getEngine(), postReader.getContentStream(), postReader.getContentStream().getLength(), postReader.getContentType());
        this.processFileUpload(itemInfo.getItem(), itemInfo);
    }

    @Override
    protected boolean updateFileData(File file, InputStream inputStream, long length, String contentType) throws ServerException, IOException, LockedException {
        file.write(inputStream, file.getContentType(), 0L, length);
        return true;
    }

    private static String getFileName(String name) {
        String[] parts = name.split("[/]");
        if (parts.length == 0) {
            return null;
        }
        parts = parts[parts.length - 1].split("\\\\");
        return parts[parts.length - 1];
    }

    private static boolean isMultipart(DavRequest request) {
        String contentType = request.getContentType();
        if (StringUtil.isNullOrEmpty(contentType)) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/form-data");
    }

    private static String getBoundary(DavRequest request) {
        String contentType = request.getContentType();
        int index = contentType.indexOf("boundary=");
        return index > 0 ? contentType.substring(index + "boundary=".length()) : null;
    }

    private class ItemInfo
    implements BaseUploadHandler.UploadItemInfo {
        private final Folder folder;
        private final String fileName;
        private final Engine engine;
        private final InputStream stream;
        private final String contentType;
        private long contentLength;

        public ItemInfo(Folder folder, String fileName, Engine engine, InputStream stream, long contentLength, String contentType) {
            this.folder = folder;
            this.fileName = fileName;
            this.contentLength = contentLength;
            this.engine = engine;
            this.stream = stream;
            this.contentType = contentType;
        }

        @Override
        public Folder getParent() {
            return this.folder;
        }

        @Override
        public String getName() {
            return this.fileName;
        }

        @Override
        public File getItem() throws ServerException {
            String path = this.folder.getPath();
            HierarchyItem file = this.engine.getHierarchyItem(path + (path.endsWith("/") ? "" : "/") + this.fileName);
            return file instanceof File ? (File)file : null;
        }

        @Override
        public InputStream getStream() {
            return this.stream;
        }

        @Override
        public long getContentLength() {
            return this.contentLength;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }
    }
}

