/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.File;
import com.ithit.webdav.server.Folder;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.Property;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BasePropDavHandler;
import com.ithit.webdav.server.handler.IfHelper;
import com.ithit.webdav.server.handler.MultistatusResponseWriter;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.paging.OrderProperty;
import com.ithit.webdav.server.paging.PageResults;
import com.ithit.webdav.server.util.ChildIterable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class PropfindHandler
extends BasePropDavHandler {
    private Document propRequest;

    public PropfindHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    @Override
    public void processRequest(DavRequest request, DavResponse response, HierarchyItem item) throws DavException, IOException {
        super.processRequest(request, response, item);
        if (!this.processIfHeaders(item, WebDavStatus.PRECONDITION_FAILED)) {
            return;
        }
        if (!(this.getDepth() == null || this.getDepth().equals("0") || this.getDepth().equals("1") || this.getDepth().toLowerCase().equals("infinity"))) {
            throw new ServerException(WebDavStatus.BAD_REQUEST);
        }
        if (!this.exists(item)) {
            return;
        }
        try {
            this.generatePropfindResponse(item);
        }
        catch (XMLStreamException e) {
            throw new ServerException(e);
        }
    }

    private void generatePropfindResponse(HierarchyItem item) throws DavException, IOException, XMLStreamException {
        boolean allprop;
        boolean propname = false;
        Long offset = null;
        Long nResults = null;
        ArrayList<Property> properties = new ArrayList();
        ArrayList<OrderProperty> orderProps = new ArrayList<OrderProperty>();
        this.propRequest = this.initializeRequestDocumentAndMngr();
        if (this.propRequest != null) {
            Node orderByProps;
            Node limitNode;
            allprop = this.selectNode(this.propRequest, "/d:propfind/d:allprop") != null;
            Node propNode = this.selectNode(this.propRequest, "/d:propfind/d:propname");
            if (propNode != null) {
                propname = true;
                properties = this.getPropertyList(propNode);
            }
            if ((limitNode = this.selectNode(this.propRequest, "/d:propfind/d:limit")) != null) {
                offset = Long.valueOf(PropfindHandler.getText(this.selectNode(this.propRequest, "//d:limit//d:offset")));
                nResults = Long.valueOf(PropfindHandler.getText(this.selectNode(this.propRequest, "//d:limit//d:nresults")));
            }
            if ((orderByProps = this.selectNode(this.propRequest, "/d:propfind/d:orderby")) != null) {
                this.readOrderProperty(orderProps, orderByProps);
            }
        } else {
            allprop = true;
        }
        MultistatusResponseWriter mResp = new MultistatusResponseWriter(this.getRequest(), this.getResponse(), this.getEngine().getResponseCharacterEncoding());
        mResp.startMultiStatusResponse(offset != null && nResults != null);
        if (item instanceof File) {
            this.writeElement(mResp, item, allprop, propname);
        } else if (this.getDepth() != null && this.getDepth().equals("0")) {
            this.writeElement(mResp, item, allprop, propname);
        } else if (this.getDepth() != null && this.getDepth().equals("1")) {
            if (item instanceof Folder) {
                Folder folder = (Folder)item;
                PageResults page = IfHelper.getChildren(folder, properties, offset, nResults, orderProps);
                if (offset != null && nResults != null && page.getTotalItems() != null) {
                    mResp.writePropertyWithPrefix("ithitp", "total", "https://www.ithit.com/pagingschema/", page.getTotalItems().toString());
                }
                this.writeElement(mResp, item, allprop, propname);
                for (HierarchyItem hierarchyItem : page.getPage()) {
                    this.writeElement(mResp, hierarchyItem, allprop, propname);
                }
            }
        } else {
            if (offset != null || nResults != null) {
                throw new ServerException("Depth.Infinity does not support D:limit.");
            }
            if (orderProps != null && orderProps.size() != 0) {
                throw new ServerException("Depth.Infinity does not support D:orderby.");
            }
            this.writeElementRecursive(mResp, item, allprop, propname, properties);
        }
        mResp.endMultiStatusResponse();
    }

    private void readOrderProperty(List<OrderProperty> orderProps, Node orderByProps) {
        for (Node node : new ChildIterable(orderByProps)) {
            boolean asc = true;
            Property property = null;
            NodeList childNodes = node.getChildNodes();
            if (childNodes.getLength() > 0) {
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node n = childNodes.item(i);
                    if (n.getNodeType() != 1) continue;
                    if (n.getLocalName().equalsIgnoreCase("prop")) {
                        for (int j = 0; j < n.getChildNodes().getLength(); ++j) {
                            Node pr = n.getChildNodes().item(j);
                            if (pr.getNodeType() != 1) continue;
                            property = PropfindHandler.notFoundProp(pr.getNamespaceURI(), pr.getLocalName());
                        }
                        continue;
                    }
                    asc = n.getLocalName().equalsIgnoreCase("ascending");
                }
            }
            orderProps.add(new OrderProperty(property, asc));
        }
    }

    private void writeElementRecursive(MultistatusResponseWriter mResp, HierarchyItem item, boolean allprop, boolean propname, List<Property> properties) throws XMLStreamException, DavException {
        this.writeElement(mResp, item, allprop, propname);
        if (item instanceof Folder) {
            Folder folder = (Folder)item;
            for (HierarchyItem hierarchyItem : IfHelper.getChildren(folder, properties, null, null, null).getPage()) {
                this.writeElementRecursive(mResp, hierarchyItem, allprop, propname, properties);
            }
        }
    }

    private void writeElement(MultistatusResponseWriter mResp, HierarchyItem item, boolean allprop, boolean propname) throws XMLStreamException, DavException {
        mResp.startResponse(IfHelper.getPath(item));
        if (allprop) {
            this.writeAllProp(mResp, item);
        } else if (propname) {
            this.writePropertyNames(mResp, item);
        } else {
            Node propNode = this.selectNode(this.propRequest, "/d:propfind/d:prop");
            this.writeDavProperties(mResp, item, propNode);
        }
        mResp.endResponse();
    }
}

