/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.File;
import com.ithit.webdav.server.Folder;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Lock;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.Property;
import com.ithit.webdav.server.deltav.AutoVersion;
import com.ithit.webdav.server.deltav.VersionableItem;
import com.ithit.webdav.server.exceptions.ConflictException;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.FailedDependencyException;
import com.ithit.webdav.server.exceptions.LockedException;
import com.ithit.webdav.server.exceptions.MultistatusException;
import com.ithit.webdav.server.exceptions.Response;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.handler.IfHelper;
import com.ithit.webdav.server.handler.MultistatusResponseWriter;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ProppatchHandler
extends BaseDavHandler {
    public ProppatchHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    @Override
    public void processRequest(DavRequest request, DavResponse response, HierarchyItem item) throws DavException, IOException {
        VersionableItem verItem;
        super.processRequest(request, response, item);
        if (!this.processIfHeaders(item, WebDavStatus.PRECONDITION_FAILED)) {
            return;
        }
        if (!this.exists(item)) {
            return;
        }
        Document document = this.initializeRequestDocumentAndMngr();
        VersionableItem versionableItem = verItem = item instanceof VersionableItem ? (VersionableItem)item : null;
        if (verItem != null && this.getEngine().getAutoPutUnderVersionControl()) {
            verItem.putUnderVersionControl(true);
        }
        if (verItem != null && verItem.getVersionHistory() != null) {
            this.autoVersionLogic(document, item, verItem);
        } else if (item instanceof File || item instanceof Folder) {
            this.changeProperties(document, item);
        } else {
            throw new ServerException(WebDavStatus.NOT_ALLOWED);
        }
        MultistatusException ex = new MultistatusException();
        String itemPath = IfHelper.getPath(item);
        for (Property property : this.getSetProps(document)) {
            ex.addResponse(itemPath, property, WebDavStatus.OK);
        }
        for (Property property : this.getDelProps(document)) {
            ex.addResponse(itemPath, property, WebDavStatus.OK);
        }
        MultistatusResponseWriter writer = new MultistatusResponseWriter(this.getRequest(), this.getResponse(), this.getEngine().getResponseCharacterEncoding());
        try {
            writer.startMultiStatusResponse();
            for (Response resp : ex.getResponses()) {
                writer.addStatusResponse(resp);
            }
            writer.endMultiStatusResponse();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ServerException(xMLStreamException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void autoVersionLogic(Document document, HierarchyItem item, VersionableItem verItem) throws MultistatusException, ServerException, ConflictException, FailedDependencyException, LockedException {
        boolean checkedOut = verItem.isCheckedOut();
        Lock itemLock = item instanceof Lock ? (Lock)((Object)item) : null;
        AutoVersion autoVersionMode = verItem.getAutoVersion();
        if (autoVersionMode == AutoVersion.CheckOutCheckIn) {
            if (!checkedOut) {
                verItem.checkOut();
                verItem.setAutoCheckIn(false);
            }
            this.changeProperties(document, item);
            if (checkedOut) return;
            verItem.checkIn();
            return;
        } else if (autoVersionMode == AutoVersion.CheckOutUnlockedCheckIn) {
            if (!checkedOut) {
                verItem.checkOut();
                verItem.setAutoCheckIn(true);
            }
            this.changeProperties(document, item);
            if (checkedOut || itemLock == null || IfHelper.hasActiveLocks(itemLock)) return;
            verItem.checkIn();
            return;
        } else if (autoVersionMode == AutoVersion.CheckOut) {
            if (!checkedOut) {
                verItem.checkOut();
                verItem.setAutoCheckIn(true);
            }
            this.changeProperties(document, item);
            return;
        } else if (autoVersionMode == AutoVersion.LockedCheckOut) {
            if (!checkedOut && itemLock != null && IfHelper.hasActiveLocks(itemLock)) {
                verItem.checkOut();
                verItem.setAutoCheckIn(true);
            }
            if (!verItem.isCheckedOut()) throw new ConflictException();
            this.changeProperties(document, item);
            return;
        } else {
            if (!checkedOut) {
                throw new ConflictException();
            }
            this.changeProperties(document, item);
        }
    }

    private void changeProperties(Document propRequest, HierarchyItem item) throws MultistatusException, ServerException, FailedDependencyException, LockedException, ConflictException {
        List<Property> setProps = this.getSetProps(propRequest);
        List<Property> delProps = this.getDelProps(propRequest);
        if (setProps.size() == 0 && delProps.size() == 0) {
            throw new ServerException(WebDavStatus.BAD_REQUEST);
        }
        boolean[] setReadOnly = null;
        boolean[] delReadOnly = null;
        boolean setReadOnlyFound = false;
        boolean delReadOnlyFound = false;
        if (setProps.size() != 0) {
            setReadOnly = ProppatchHandler.findReadOnlyProps(setProps);
            boolean bl = setReadOnlyFound = setReadOnly != null;
        }
        if (delProps.size() != 0) {
            delReadOnly = ProppatchHandler.findReadOnlyProps(delProps);
            boolean bl = delReadOnlyFound = delReadOnly != null;
        }
        if (setReadOnlyFound || delReadOnlyFound) {
            ProppatchHandler.createFailedResponse(IfHelper.getPath(item), setProps, delProps, setReadOnly, delReadOnly);
        } else {
            List<Property> updatedLiveProps = ProppatchHandler.updateLiveProperties(item, setProps);
            try {
                if (setProps.size() != 0 || delProps.size() != 0) {
                    item.updateProperties(setProps.toArray(new Property[setProps.size()]), delProps.toArray(new Property[delProps.size()]));
                }
            }
            catch (MultistatusException ex) {
                for (Property p : updatedLiveProps) {
                    ex.addResponse(IfHelper.getPath(item), p, WebDavStatus.OK);
                }
                throw ex;
            }
        }
    }

    protected static void createFailedResponse(String itemPath, List<Property> setProps, List<Property> delProps, boolean[] setro, boolean[] delro) throws MultistatusException {
        int i;
        MultistatusException respro = new MultistatusException();
        for (i = 0; i < setProps.size(); ++i) {
            if (setro != null && setro[i]) {
                respro.addResponse(itemPath, setProps.get(i), WebDavStatus.CONFLICT);
                continue;
            }
            respro.addResponse(itemPath, setProps.get(i), WebDavStatus.FAILED_DEPENDENCY);
        }
        for (i = 0; i < delProps.size(); ++i) {
            if (delro != null && delro[i]) {
                respro.addResponse(itemPath, delProps.get(i), WebDavStatus.CONFLICT);
                continue;
            }
            respro.addResponse(itemPath, delProps.get(i), WebDavStatus.FAILED_DEPENDENCY);
        }
        throw respro;
    }

    private List<Property> getSetProps(Document propRequest) throws ServerException {
        ArrayList<Property> setProps = new ArrayList<Property>();
        NodeList setNodes = this.selectNodes(propRequest, "/d:propertyupdate/d:set/d:prop/*");
        if (setNodes.getLength() > 0) {
            for (int i = 0; i < setNodes.getLength(); ++i) {
                Node autoversion;
                String propValue = setNodes.item(i).getTextContent();
                if (propValue == null || propValue.length() == 0) {
                    propValue = this.getInnerText(setNodes.item(i));
                }
                if (setNodes.item(i).getLocalName().equals("auto-version") && setNodes.item(i).getNamespaceURI().equals("DAV:") && (autoversion = this.selectNode(propRequest, "/d:propertyupdate/d:set/d:prop/d:auto-version/*")) != null && autoversion.getNamespaceURI().equals("DAV:")) {
                    propValue = autoversion.getLocalName();
                }
                Property p = new Property(setNodes.item(i).getNamespaceURI(), setNodes.item(i).getLocalName(), propValue);
                setProps.add(p);
            }
        }
        return setProps;
    }

    private String getInnerText(Node node) throws ServerException {
        try {
            StreamResult result = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                DOMSource source = new DOMSource(node.getChildNodes().item(i));
                transformer.transform(source, result);
            }
            return result.getWriter().toString();
        }
        catch (TransformerException e) {
            throw new ServerException(e);
        }
    }

    private List<Property> getDelProps(Document propRequest) throws ServerException {
        ArrayList<Property> delProps = new ArrayList<Property>();
        NodeList delNodes = this.selectNodes(propRequest, "/d:propertyupdate/d:remove/d:prop/*");
        if (delNodes.getLength() > 0) {
            for (int i = 0; i < delNodes.getLength(); ++i) {
                Property p = new Property(delNodes.item(i).getNamespaceURI(), delNodes.item(i).getLocalName(), "");
                delProps.add(p);
            }
        }
        return delProps;
    }
}

