/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.File;
import com.ithit.webdav.server.Folder;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.LockedException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseUploadHandler;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.util.RequestUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PutHandler
extends BaseUploadHandler {
    private static final Pattern contentRangeRegex = Pattern.compile("\\s*bytes\\s*(\\d+)-(\\d+)/((?:\\d+)|(?:\\*))");
    private long start;
    private long end;
    private long length;
    private boolean hasContentRange;

    public PutHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    @Override
    public void processRequest(DavRequest rt, DavResponse rs, HierarchyItem item) throws DavException, IOException {
        File res;
        super.processRequest(rt, rs, item);
        if (!this.processIfHeaders(item, WebDavStatus.PRECONDITION_FAILED)) {
            return;
        }
        this.parseContentRange();
        ItemInfo itemInfo = new ItemInfo(this);
        this.processFileUpload(item, itemInfo);
        if (item instanceof File && (res = (File)item).getEtag() != null) {
            this.addHeader("ETag", "\"" + res.getEtag() + "\"");
        }
    }

    @Override
    public boolean getLogInput() {
        return false;
    }

    private void parseContentRange() throws ServerException {
        String contentRange = this.getRequest().getHeader("Content-Range");
        if (contentRange != null) {
            Matcher match = contentRangeRegex.matcher(contentRange);
            if (!match.matches()) {
                throw new ServerException(WebDavStatus.BAD_REQUEST);
            }
            this.start = Long.decode(match.group(1));
            this.end = Long.decode(match.group(2));
            this.length = match.group(3).equals("*") ? -1L : Long.decode(match.group(3));
            this.hasContentRange = true;
        }
    }

    @Override
    protected boolean updateFileData(File file, InputStream inputStream, long contentLength, String contentType) throws ServerException, IOException, LockedException {
        long write;
        if (this.hasContentRange) {
            long written = file.write(inputStream, contentType, this.start, this.length);
            return this.start + written - 1L == this.end;
        }
        long cLength = this.getRequest().getContentLength();
        return cLength == (write = file.write(inputStream, this.getRequest().getContentType(), this.start, cLength)) || cLength < 0L;
    }

    private class ItemInfo
    implements BaseUploadHandler.UploadItemInfo {
        private final PutHandler handler;
        private final InputStream stream;

        public ItemInfo(PutHandler handler) throws IOException {
            this.handler = handler;
            this.stream = PutHandler.this.getRequest().getInputStream();
        }

        @Override
        public Folder getParent() throws DavException {
            return this.handler.getParent(RequestUtil.getRequestPathAndQueryString(this.handler.getRequest()));
        }

        @Override
        public String getName() throws ServerException {
            return this.handler.getName(this.handler.getRequestPath());
        }

        @Override
        public File getItem() throws ServerException {
            return (File)PutHandler.this.getEngine().getHierarchyItem(this.handler.getRequestPathAndQueryString());
        }

        @Override
        public InputStream getStream() {
            return this.stream;
        }

        @Override
        public long getContentLength() {
            return PutHandler.this.hasContentRange ? this.handler.length : PutHandler.this.getRequest().getContentLength();
        }

        @Override
        public String getContentType() {
            return this.handler.getRequest().getContentType();
        }
    }
}

