/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.Property;
import com.ithit.webdav.server.deltav.DeltaVItem;
import com.ithit.webdav.server.deltav.History;
import com.ithit.webdav.server.deltav.Version;
import com.ithit.webdav.server.deltav.VersionableItem;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.MultistatusException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.handler.IfHelper;
import com.ithit.webdav.server.handler.MultistatusResponseWriter;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.resumableupload.ResumableUpload;
import com.ithit.webdav.server.resumableupload.UploadProgress;
import com.ithit.webdav.server.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class ReportHandler
extends BaseDavHandler {
    public ReportHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    @Override
    public void processRequest(DavRequest rt, DavResponse rs, HierarchyItem item) throws IOException, DavException {
        super.processRequest(rt, rs, item);
        if (!this.processIfHeaders(item, WebDavStatus.PRECONDITION_FAILED)) {
            return;
        }
        if (!this.exists(item)) {
            return;
        }
        VersionableItem dvItem = item instanceof VersionableItem ? (VersionableItem)item : null;
        Document document = this.initializeRequestDocumentAndMngr();
        Node uploadProgressNode = this.selectNode(document, "i:upload-progress");
        if (uploadProgressNode != null) {
            this.handleUploadProgress(item);
            return;
        }
        if (dvItem != null && dvItem.getVersionHistory() != null) {
            this.generateReportResponse(document, dvItem.getVersionHistory());
        } else if (item instanceof Version) {
            this.generateReportResponse(document, ((Version)item).getVersionableItem().getVersionHistory());
        } else {
            throw new ServerException(WebDavStatus.CONFLICT);
        }
    }

    private void handleUploadProgress(HierarchyItem item) throws ServerException, IOException {
        UploadProgress progress;
        UploadProgress uploadProgress = progress = item instanceof UploadProgress ? (UploadProgress)((Object)item) : null;
        if (progress == null) {
            this.setStatus(WebDavStatus.NOT_IMPLEMENTED);
            return;
        }
        try {
            MultistatusResponseWriter sw = new MultistatusResponseWriter(this.getRequest(), this.getResponse(), this.getEngine().getResponseCharacterEncoding());
            sw.startMultiStatusResponse();
            for (ResumableUpload resumableUpload : progress.getUploadProgress()) {
                HierarchyItem uploadItem;
                HierarchyItem hierarchyItem = uploadItem = resumableUpload instanceof HierarchyItem ? (HierarchyItem)((Object)resumableUpload) : null;
                if (uploadItem == null) {
                    this.setStatus(WebDavStatus.NOT_IMPLEMENTED);
                    return;
                }
                sw.startResponse(uploadItem.getPath());
                sw.startPropStat();
                sw.startProp();
                sw.writeProperty("bytes-uploaded", "ithit", Long.toString(resumableUpload.getBytesUploaded()));
                sw.writeProperty("last-chunk-saved", "ithit", this.formatModified(resumableUpload.getLastChunkSaved()));
                sw.writeProperty("total-content-length", "ithit", Long.toString(resumableUpload.getTotalContentLength()));
                sw.endProp();
                sw.writeItemStatus(WebDavStatus.OK);
                sw.endPropStat();
                sw.endResponse();
            }
            sw.endMultiStatusResponse();
        }
        catch (XMLStreamException ex) {
            throw new ServerException(ex);
        }
    }

    private void generateReportResponse(Document document, History history) throws ServerException, IOException, MultistatusException {
        if (document == null) {
            throw new ServerException(WebDavStatus.NOT_IMPLEMENTED);
        }
        Node versionHeadNode = this.selectNode(document, "/d:version-tree");
        if (versionHeadNode == null) {
            throw new ServerException(WebDavStatus.NOT_IMPLEMENTED);
        }
        Node versionPropNode = this.selectNode(document, "/d:version-tree/d:prop");
        if (versionPropNode == null) {
            throw new ServerException(WebDavStatus.NOT_IMPLEMENTED);
        }
        try {
            MultistatusResponseWriter writer = new MultistatusResponseWriter(this.getRequest(), this.getResponse(), this.getEngine().getResponseCharacterEncoding());
            writer.startMultiStatusResponse();
            List<? extends Version> versions = history.getVersionSet();
            for (Version version : versions) {
                this.writeElementReport(writer, version, versionPropNode);
            }
            writer.endMultiStatusResponse();
        }
        catch (XMLStreamException e) {
            throw new ServerException(e);
        }
    }

    private void writeElementReport(MultistatusResponseWriter writer, DeltaVItem item, Node versionPropNode) throws XMLStreamException, ServerException, MultistatusException {
        Version version = item instanceof Version ? (Version)item : null;
        writer.startResponse(IfHelper.getPath(version));
        writer.startPropStat();
        writer.startProp();
        ArrayList<Property> propList = new ArrayList<Property>();
        for (int i = 0; i < versionPropNode.getChildNodes().getLength(); ++i) {
            Node n = versionPropNode.getChildNodes().item(i);
            if (n.getNodeType() != 1) continue;
            if (StringUtil.stringEquals(n.getNamespaceURI(), "DAV:")) {
                boolean written = false;
                String localName = n.getLocalName().toLowerCase();
                if (localName.equals("creationdate")) {
                    written = this.writeCreated(writer, item);
                } else if (localName.equals("getlastmodified")) {
                    written = this.writeModified(writer, item);
                } else if (localName.equals("getcontentlength")) {
                    written = this.writeContentLength(writer, item);
                } else if (localName.equals("getcontenttype")) {
                    written = this.writeContentType(writer, item);
                } else if (localName.equals("creator-displayname")) {
                    written = this.writeCreatorDisplayname(writer, item);
                } else if (localName.equals("comment")) {
                    written = this.writeComment(writer, item);
                } else if (localName.equals("predecessor-set")) {
                    written = this.writePredecessorSet(writer, item);
                } else if (localName.equals("successor-set")) {
                    written = true;
                    this.writeSuccessorSet(writer, version);
                } else if (localName.equals("checkout-set")) {
                    written = true;
                    this.writeCheckoutSet(writer, version);
                } else if (localName.equals("version-name")) {
                    written = true;
                    this.writeVersionName(writer, version);
                }
                if (written) continue;
                propList.add(ReportHandler.notFoundProp(n.getNamespaceURI(), n.getLocalName()));
                continue;
            }
            propList.add(ReportHandler.notFoundProp(n.getNamespaceURI(), n.getLocalName()));
        }
        ArrayList<Property> notFoundProps = new ArrayList<Property>();
        List<Property> props = item.getProperties(propList.toArray(new Property[propList.size()]));
        for (Property requiredProp : propList) {
            boolean found = false;
            for (Property p : props) {
                if (!StringUtil.stringEquals(p.getName(), requiredProp.getName()) || !StringUtil.stringEquals(p.getNamespace(), requiredProp.getNamespace())) continue;
                found = true;
                if (p.getValue() != null) {
                    writer.writeProperty(p.getName(), p.getNamespace(), p.getValue());
                    break;
                }
                notFoundProps.add(p);
                break;
            }
            if (found) continue;
            notFoundProps.add(requiredProp);
        }
        writer.endProp();
        writer.writeItemStatus(WebDavStatus.OK);
        writer.endPropStat();
        if (notFoundProps.size() > 0) {
            writer.startPropStat();
            writer.startProp();
            for (Property p : notFoundProps) {
                writer.writeEmptyProperty(p.getName(), p.getNamespace());
            }
            writer.endProp();
            writer.writeItemStatus(WebDavStatus.NOT_FOUND);
            writer.endPropStat();
        }
        writer.endResponse();
    }
}

