/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.Property;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BasePropDavHandler;
import com.ithit.webdav.server.handler.IfHelper;
import com.ithit.webdav.server.handler.MultistatusResponseWriter;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.paging.PageResults;
import com.ithit.webdav.server.search.Search;
import com.ithit.webdav.server.search.SearchOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class SearchHandler
extends BasePropDavHandler {
    private Document searchRequest;

    protected SearchHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    @Override
    public void processRequest(DavRequest request, DavResponse response, HierarchyItem item) throws DavException, IOException {
        Node limitNode;
        Search searchItem;
        super.processRequest(request, response, item);
        if (!this.exists(item)) {
            return;
        }
        Search search = searchItem = item instanceof Search ? (Search)item : null;
        if (searchItem == null) {
            throw new ServerException(WebDavStatus.METHOD_NOT_ALLOWED);
        }
        this.searchRequest = this.initializeRequestDocumentAndMngr();
        Long offset = null;
        Long nResults = null;
        Node propNode = this.selectNode(this.searchRequest, "//d:select/d:prop");
        if (propNode == null) {
            throw new ServerException("<![CDATA[Can not parse properies to find.]]>", WebDavStatus.NOT_IMPLEMENTED);
        }
        Node allpropNode = this.selectNode(this.searchRequest, "//d:select/d:prop/d:allprop");
        boolean allProp = allpropNode != null;
        ArrayList<Property> propNames = new ArrayList();
        if (!allProp) {
            propNames = this.getPropertyList(this.selectNode(this.searchRequest, "//d:select/d:prop"));
        }
        Node containsNode = this.selectNode(this.searchRequest, "//d:where//d:contains");
        String contentCondition = SearchHandler.getText(containsNode);
        String fileNameCondition = null;
        Node propsLikeNode = this.selectNode(this.searchRequest, "//d:where//d:like");
        if (propsLikeNode != null) {
            Node literalNode = this.selectNode(this.searchRequest, "//d:where//d:like/d:literal");
            Node propLikeNode = this.selectNode(this.searchRequest, "//d:where//d:like/d:prop");
            fileNameCondition = SearchHandler.getText(literalNode);
            List<Property> likeProps = this.getPropertyList(propLikeNode);
            if (likeProps.size() == 0 || !likeProps.get(0).getName().equals("displayname")) {
                throw new ServerException("<![CDATA[Only search by <displayname> supported within <like> element.]]>", WebDavStatus.NOT_IMPLEMENTED);
            }
        }
        if ((limitNode = this.selectNode(this.searchRequest, "//d:limit")) != null) {
            offset = Long.valueOf(SearchHandler.getText(this.selectNode(this.searchRequest, "//d:limit//d:offset")));
            nResults = Long.valueOf(SearchHandler.getText(this.selectNode(this.searchRequest, "//d:limit//d:nresults")));
        }
        if (fileNameCondition != null || contentCondition != null) {
            SearchOptions searchOptions = new SearchOptions(fileNameCondition != null, contentCondition != null);
            PageResults pageResults = searchItem.search(fileNameCondition != null ? fileNameCondition : contentCondition, searchOptions, propNames, offset, nResults);
            List<? extends HierarchyItem> items = pageResults.getPage();
            Long totalItems = pageResults.getTotalItems();
            try {
                this.generateSearchResponse(items, allProp, totalItems);
            }
            catch (XMLStreamException e) {
                throw new ServerException(e);
            }
        } else {
            throw new ServerException("<![CDATA[Your request xml contains errors or unsupported elements. Here is simple example of request: <d:searchrequest xmlns:d=\"DAV:\">  <d:basicsearch>    <d:select>      <d:prop><d:allprop/></d:prop>    </d:select>    <d:where>      <d:or>        <d:like>          <d:prop><d:displayname/></d:prop>          <d:literal>note*</d:literal>        </d:like>        <d:contains>note*</d:contains>      </d:or>    </d:where>  </d:basicsearch></d:searchrequest>]]>", WebDavStatus.NOT_IMPLEMENTED);
        }
    }

    private void generateSearchResponse(List<? extends HierarchyItem> result, boolean allProp, Long totalItems) throws IOException, XMLStreamException, DavException {
        MultistatusResponseWriter mResp = new MultistatusResponseWriter(this.getRequest(), this.getResponse(), this.getEngine().getResponseCharacterEncoding());
        mResp.startMultiStatusResponse(totalItems != null);
        if (result != null) {
            if (totalItems != null) {
                mResp.writePropertyWithPrefix("ithitp", "total", "https://www.ithit.com/pagingschema/", totalItems.toString());
            }
            for (HierarchyItem hierarchyItem : result) {
                mResp.startResponse(IfHelper.getPath(hierarchyItem));
                if (allProp) {
                    this.writeAllProp(mResp, hierarchyItem);
                } else {
                    Node propNode = this.selectNode(this.searchRequest, "//d:select/d:prop");
                    this.writeDavProperties(mResp, hierarchyItem, propNode);
                }
                mResp.endResponse();
            }
        }
        mResp.endMultiStatusResponse();
    }
}

