/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Lock;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.deltav.VersionableItem;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.util.RequestUtil;
import java.io.IOException;

class UnlockHandler
extends BaseDavHandler {
    public UnlockHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    @Override
    public void processRequest(DavRequest rt, DavResponse rs, HierarchyItem item) throws IOException, DavException {
        VersionableItem verItem;
        Lock itemLock;
        String token;
        super.processRequest(rt, rs, item);
        if (!this.processIfHeaders(item, WebDavStatus.PRECONDITION_FAILED)) {
            return;
        }
        try {
            token = RequestUtil.getGuidFromToken(this.getRequest().getHeader("Lock-Token"));
        }
        catch (Throwable ex) {
            throw new ServerException(WebDavStatus.BAD_REQUEST);
        }
        if (!this.exists(item)) {
            return;
        }
        Lock lock = itemLock = item instanceof Lock ? (Lock)((Object)item) : null;
        if (itemLock == null) {
            throw new ServerException(WebDavStatus.METHOD_NOT_ALLOWED);
        }
        VersionableItem versionableItem = verItem = item instanceof VersionableItem ? (VersionableItem)item : null;
        if (verItem != null && verItem.getVersionHistory() != null && verItem.isCheckedOut() && verItem.getAutoCheckIn()) {
            verItem.checkIn();
        }
        itemLock.unlock(token);
        this.setStatus(WebDavStatus.NO_CONTENT);
    }
}

