/*
 * Decompiled with CFR 0.152.
 */
package com.ithit.webdav.server.handler;

import com.ithit.webdav.server.Engine;
import com.ithit.webdav.server.HierarchyItem;
import com.ithit.webdav.server.Logger;
import com.ithit.webdav.server.Property;
import com.ithit.webdav.server.deltav.Version;
import com.ithit.webdav.server.deltav.VersionableItem;
import com.ithit.webdav.server.exceptions.ConflictException;
import com.ithit.webdav.server.exceptions.DavException;
import com.ithit.webdav.server.exceptions.FailedDependencyException;
import com.ithit.webdav.server.exceptions.LockedException;
import com.ithit.webdav.server.exceptions.MultistatusException;
import com.ithit.webdav.server.exceptions.Response;
import com.ithit.webdav.server.exceptions.ServerException;
import com.ithit.webdav.server.exceptions.WebDavStatus;
import com.ithit.webdav.server.handler.BaseDavHandler;
import com.ithit.webdav.server.handler.IfHelper;
import com.ithit.webdav.server.handler.MultistatusResponseWriter;
import com.ithit.webdav.server.http.DavRequest;
import com.ithit.webdav.server.http.DavResponse;
import com.ithit.webdav.server.util.RequestUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class UpdateHandler
extends BaseDavHandler {
    public UpdateHandler(Engine engine, Logger logger) {
        super(engine, logger);
    }

    @Override
    public void processRequest(DavRequest rt, DavResponse rs, HierarchyItem item) throws IOException, DavException {
        VersionableItem verContrItem;
        super.processRequest(rt, rs, item);
        if (!this.processIfHeaders(item, WebDavStatus.PRECONDITION_FAILED)) {
            return;
        }
        if (!this.exists(item)) {
            return;
        }
        VersionableItem versionableItem = verContrItem = item instanceof VersionableItem ? (VersionableItem)item : null;
        if (verContrItem == null) {
            throw new ServerException(WebDavStatus.METHOD_NOT_ALLOWED);
        }
        if (verContrItem.isCheckedOut()) {
            throw new ConflictException("Must be checked in", "DAV:", "must-be-checked-in");
        }
        Document document = this.initializeRequestDocumentAndMngr();
        if (document == null) {
            throw new ServerException(WebDavStatus.BAD_REQUEST);
        }
        Node hrefNode = this.selectNode(document, "/d:update/d:version/d:href");
        Node propNode = this.selectNode(document, "/d:update/d:prop");
        if (hrefNode == null && propNode == null) {
            throw new ServerException(WebDavStatus.BAD_REQUEST);
        }
        this.addHeader("Cache-Control", "no-cache");
        MultistatusException ex = new MultistatusException();
        if (hrefNode != null) {
            this.writeUpdateResponse(ex, hrefNode, verContrItem);
        }
        if (propNode != null) {
            this.writePropResponse(document, ex, item);
        }
        MultistatusResponseWriter writer = new MultistatusResponseWriter(this.getRequest(), this.getResponse(), this.getEngine().getResponseCharacterEncoding());
        try {
            writer.startMultiStatusResponse();
            for (Response resp : ex.getResponses()) {
                writer.addStatusResponse(resp);
            }
            writer.endMultiStatusResponse();
        }
        catch (XMLStreamException e) {
            throw new ServerException(e);
        }
    }

    private void writePropResponse(Document document, MultistatusException ex, HierarchyItem item) throws ServerException, MultistatusException, FailedDependencyException, LockedException, ConflictException {
        List<Property> setProps = this.getSetProps(document);
        ArrayList<Property> delProps = new ArrayList<Property>(0);
        boolean[] setReadOnly = null;
        boolean[] delReadOnly = null;
        boolean setReadOnlyFound = false;
        if (setProps.size() != 0) {
            setReadOnly = UpdateHandler.findReadOnlyProps(setProps);
            boolean bl = setReadOnlyFound = setReadOnly != null;
        }
        if (delProps.size() != 0) {
            delReadOnly = UpdateHandler.findReadOnlyProps(delProps);
        }
        List<Object> updatedLiveProps = new ArrayList();
        if (setReadOnlyFound) {
            UpdateHandler.createFailedResponse(this.getRequestPathAndQueryString(), setProps, delProps, setReadOnly, delReadOnly);
        } else {
            updatedLiveProps = UpdateHandler.updateLiveProperties(item, setProps);
            try {
                item.updateProperties(setProps.toArray(new Property[setProps.size()]), null);
            }
            catch (MultistatusException mex) {
                for (Property property : updatedLiveProps) {
                    mex.addResponse(IfHelper.getPath(item), property, WebDavStatus.OK);
                }
                throw mex;
            }
        }
        String itemPath = this.getRequestPathAndQueryString();
        for (Property property : setProps) {
            ex.addResponse(itemPath, property, WebDavStatus.OK);
        }
        for (Property property : updatedLiveProps) {
            ex.addResponse(itemPath, property, WebDavStatus.OK);
        }
    }

    private List<Property> getSetProps(Document document) throws ServerException {
        ArrayList<Property> setProps = new ArrayList<Property>();
        NodeList setNodes = this.selectNodes(document, "/d:update/d:prop/*");
        if (setNodes.getLength() > 0) {
            for (int i = 0; i < setNodes.getLength(); ++i) {
                Property p = new Property(setNodes.item(i).getNamespaceURI(), setNodes.item(i).getLocalName(), setNodes.item(i).getTextContent());
                setProps.add(p);
            }
        }
        return setProps;
    }

    private void writeUpdateResponse(MultistatusException exception, Node hrefNode, VersionableItem verContrItem) throws DavException {
        Version version;
        String href = RequestUtil.getPathAndQueryString(hrefNode.getTextContent(), this.getRequest());
        HierarchyItem item = this.getEngine().getHierarchyItem(href);
        Version version2 = version = item instanceof Version ? (Version)item : null;
        if (version == null) {
            MultistatusException ex = new MultistatusException();
            ex.addResponse(this.getRequestPathAndQueryString(), WebDavStatus.NOT_FOUND);
            throw ex;
        }
        try {
            verContrItem.updateToVersion(version);
            exception.addResponse(this.getRequestPathAndQueryString(), WebDavStatus.OK);
        }
        catch (ServerException e) {
            MultistatusException ex = new MultistatusException();
            ex.addResponse(this.getRequestPathAndQueryString(), e.getStatus());
            throw ex;
        }
    }
}

